/*
 * Decompiled with CFR 0.152.
 */
package org.onion_lang.onion.compiler.environment;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.onion_lang.onion.compiler.environment.LocalBinding;
import org.onion_lang.onion.compiler.utility.Systems;

public class LocalScope {
    private LocalScope parent;
    private Map bindings = new HashMap();

    public LocalScope(LocalScope parent) {
        this.parent = parent;
    }

    public LocalScope newChildScope() {
        return new LocalScope(this);
    }

    public Set entries() {
        HashSet entries = new HashSet();
        entries.addAll(this.bindings.values());
        return entries;
    }

    public boolean contains(String name) {
        return this.bindings.containsKey(name);
    }

    public boolean put(String name, LocalBinding binding) {
        if (this.bindings.containsKey(name)) {
            return true;
        }
        this.bindings.put(name, binding);
        return false;
    }

    public LocalBinding get(String name) {
        return (LocalBinding)this.bindings.get(name);
    }

    public LocalBinding lookup(String name) {
        for (LocalScope table = this; table != null; table = table.getParent()) {
            if (!table.contains(name)) continue;
            return table.get(name);
        }
        return null;
    }

    public String toString() {
        String separator = Systems.getLineSeparator();
        StringBuffer string = new StringBuffer();
        string.append("[");
        string.append(separator);
        Iterator i = this.bindings.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            string.append("  ");
            string.append(name);
            string.append(":");
            string.append(((LocalBinding)this.bindings.get(name)).getType());
            string.append(separator);
        }
        string.append("]");
        return new String(string);
    }

    public LocalScope getParent() {
        return this.parent;
    }
}

