/*
 * Decompiled with CFR 0.152.
 */
package org.onion_lang.onion.compiler.environment;

import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.onion_lang.onion.compiler.environment.ClassTable;
import org.onion_lang.onion.lang.kernel.type.BasicSymbol;
import org.onion_lang.onion.lang.kernel.type.ClassSymbol;
import org.onion_lang.onion.lang.kernel.type.TypeSymbol;

public class OnionTypeBridge {
    private static Map basicTypeTable = new HashMap(){
        {
            this.put(BasicType.BYTE, BasicSymbol.BYTE);
            this.put(BasicType.SHORT, BasicSymbol.SHORT);
            this.put(BasicType.CHAR, BasicSymbol.CHAR);
            this.put(BasicType.INT, BasicSymbol.INT);
            this.put(BasicType.LONG, BasicSymbol.LONG);
            this.put(BasicType.FLOAT, BasicSymbol.FLOAT);
            this.put(BasicType.DOUBLE, BasicSymbol.DOUBLE);
            this.put(BasicType.BOOLEAN, BasicSymbol.BOOLEAN);
            this.put(BasicType.VOID, BasicSymbol.VOID);
        }
    };
    private ClassTable table;

    public OnionTypeBridge(ClassTable table) {
        this.table = table;
    }

    public TypeSymbol toOnionType(Type type) {
        ArrayType arrType;
        TypeSymbol component;
        TypeSymbol returnType = (TypeSymbol)basicTypeTable.get(type);
        if (returnType != null) {
            return returnType;
        }
        if (type instanceof ObjectType) {
            ObjectType objType = (ObjectType)type;
            ClassSymbol symbol = this.table.load(objType.getClassName());
            if (symbol != null) {
                return symbol;
            }
            return null;
        }
        if (type instanceof ArrayType && (component = this.toOnionType((arrType = (ArrayType)type).getBasicType())) != null) {
            return this.table.loadArray(component, arrType.getDimensions());
        }
        return null;
    }
}

