/*
 * Decompiled with CFR 0.152.
 */
package org.onion_lang.onion.compiler.phase.analysis;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.onion_lang.onion.compiler.environment.ClosureLocalBinding;
import org.onion_lang.onion.compiler.environment.ConstructorSymbolComparator;
import org.onion_lang.onion.compiler.environment.FieldSymbolComparator;
import org.onion_lang.onion.compiler.environment.LocalFrame;
import org.onion_lang.onion.compiler.environment.MethodSymbolComparator;
import org.onion_lang.onion.compiler.phase.CodeAnalysisPhase;
import org.onion_lang.onion.compiler.problem.SemanticErrorReporter;
import org.onion_lang.onion.compiler.utility.Methods;
import org.onion_lang.onion.lang.kernel.BlockNode;
import org.onion_lang.onion.lang.kernel.ClassNode;
import org.onion_lang.onion.lang.kernel.ConstructorNode;
import org.onion_lang.onion.lang.kernel.ExpressionNode;
import org.onion_lang.onion.lang.kernel.ExpressionStatementNode;
import org.onion_lang.onion.lang.kernel.FieldNode;
import org.onion_lang.onion.lang.kernel.FieldRefNode;
import org.onion_lang.onion.lang.kernel.LocalRefNode;
import org.onion_lang.onion.lang.kernel.MethodCallNode;
import org.onion_lang.onion.lang.kernel.MethodNode;
import org.onion_lang.onion.lang.kernel.ReturnNode;
import org.onion_lang.onion.lang.kernel.SelfNode;
import org.onion_lang.onion.lang.kernel.StatementNode;
import org.onion_lang.onion.lang.kernel.type.BasicSymbol;
import org.onion_lang.onion.lang.kernel.type.ClassSymbol;
import org.onion_lang.onion.lang.kernel.type.FieldSymbol;
import org.onion_lang.onion.lang.kernel.type.MethodSymbol;
import org.onion_lang.onion.lang.kernel.type.TypeSymbol;
import org.onion_lang.onion.lang.syntax.AbstractSyntaxTreeNode;
import org.onion_lang.onion.lang.syntax.AccessSection;
import org.onion_lang.onion.lang.syntax.ClassDeclaration;
import org.onion_lang.onion.lang.syntax.CompilationUnit;
import org.onion_lang.onion.lang.syntax.ConstructorDeclaration;
import org.onion_lang.onion.lang.syntax.DelegationDeclaration;
import org.onion_lang.onion.lang.syntax.FieldDeclaration;
import org.onion_lang.onion.lang.syntax.FunctionDeclaration;
import org.onion_lang.onion.lang.syntax.GlobalVariableDeclaration;
import org.onion_lang.onion.lang.syntax.InterfaceDeclaration;
import org.onion_lang.onion.lang.syntax.InterfaceMethodDeclaration;
import org.onion_lang.onion.lang.syntax.MemberDeclaration;
import org.onion_lang.onion.lang.syntax.MethodDeclaration;
import org.onion_lang.onion.lang.syntax.Modifier;
import org.onion_lang.onion.lang.syntax.TopLevelElement;
import org.onion_lang.onion.lang.syntax.visitor.ASTVisitor;

public class DuplicationChecker
extends ASTVisitor
implements SemanticErrorReporter.Constants {
    private CodeAnalysisPhase state;
    private Set methods;
    private Set constructors;
    private Set fields;
    private Set globalVariables;
    private Set functions;

    public DuplicationChecker(CodeAnalysisPhase phase) {
        this.state = phase;
        this.methods = new TreeSet(new MethodSymbolComparator());
        this.fields = new TreeSet(new FieldSymbolComparator());
        this.constructors = new TreeSet(new ConstructorSymbolComparator());
        this.globalVariables = new TreeSet(new FieldSymbolComparator());
        this.functions = new TreeSet(new MethodSymbolComparator());
    }

    public void process(CompilationUnit unit) {
        this.state.setUnit(unit);
        this.globalVariables.clear();
        this.functions.clear();
        TopLevelElement[] toplevels = unit.getTopLevels();
        for (int i = 0; i < toplevels.length; ++i) {
            this.state.setCurrentResolver(this.state.getResolver(this.state.topClass()));
            this.accept(toplevels[i]);
        }
    }

    public Object visit(ClassDeclaration ast, Object context) {
        ClassNode node = (ClassNode)this.state.lookupKernelNode(ast);
        if (node == null) {
            return null;
        }
        this.methods.clear();
        this.fields.clear();
        this.constructors.clear();
        this.state.setContextClass(node);
        this.state.setCurrentResolver(this.state.getResolver(node.getName()));
        if (ast.getDefaultSection() != null) {
            this.accept(ast.getDefaultSection());
        }
        AccessSection[] sections = ast.getSections();
        for (int i = 0; i < sections.length; ++i) {
            this.accept(sections[i]);
        }
        this.generateMethods();
        return null;
    }

    private void generateMethods() {
        TreeSet generated = new TreeSet(new MethodSymbolComparator());
        TreeSet methodSet = new TreeSet(new MethodSymbolComparator());
        Iterator i = this.fields.iterator();
        while (i.hasNext()) {
            FieldNode node = (FieldNode)i.next();
            if (!Modifier.isForwarded(node.getModifier())) continue;
            this.generateDelegationMethods(node, generated, methodSet);
        }
    }

    private void generateDelegationMethods(FieldNode node, Set generated, Set methodSet) {
        ClassSymbol type = (ClassSymbol)node.getType();
        Set src = Methods.intefaceMethods(type);
        Iterator i = src.iterator();
        while (i.hasNext()) {
            MethodSymbol method = (MethodSymbol)i.next();
            if (methodSet.contains(method)) continue;
            if (generated.contains(method)) {
                this.report(26, this.state.lookupAST(node), new Object[]{method.getClassType(), method.getName(), method.getArguments()});
                continue;
            }
            MethodNode generatedMethod = this.createEmptyMethod(node, method);
            generated.add(generatedMethod);
            this.state.getContextClass().addMethod(generatedMethod);
        }
    }

    private MethodNode createEmptyMethod(FieldSymbol field, MethodSymbol method) {
        ExpressionNode target = new FieldRefNode(new SelfNode(this.state.getContextClass()), field);
        TypeSymbol[] args = method.getArguments();
        ExpressionNode[] params = new ExpressionNode[args.length];
        LocalFrame frame = new LocalFrame(null);
        for (int i = 0; i < params.length; ++i) {
            int index = frame.addEntry("arg" + i, args[i]);
            params[i] = new LocalRefNode(new ClosureLocalBinding(0, index, args[i]));
        }
        target = new MethodCallNode(target, method, params);
        BlockNode statement = method.getReturnType() != BasicSymbol.VOID ? new BlockNode(new StatementNode[]{new ReturnNode(target)}) : new BlockNode(new StatementNode[]{new ExpressionStatementNode(target), new ReturnNode(null)});
        MethodNode node = new MethodNode(128, this.state.getContextClass(), method.getName(), method.getArguments(), method.getReturnType(), statement);
        node.setFrame(frame);
        return node;
    }

    public Object visit(InterfaceDeclaration ast, Object context) {
        ClassNode node = (ClassNode)this.state.lookupKernelNode(ast);
        if (node == null) {
            return null;
        }
        this.methods.clear();
        this.fields.clear();
        this.constructors.clear();
        this.state.setContextClass(node);
        this.state.setCurrentResolver(this.state.getResolver(node.getName()));
        InterfaceMethodDeclaration[] members = ast.getDeclarations();
        for (int i = 0; i < members.length; ++i) {
            this.accept(members[i], context);
        }
        return null;
    }

    public Object visit(ConstructorDeclaration ast, Object context) {
        ConstructorNode node = (ConstructorNode)this.state.lookupKernelNode(ast);
        if (node == null) {
            return null;
        }
        if (this.constructors.contains(node)) {
            ClassSymbol classType = node.getClassType();
            TypeSymbol[] args = node.getArguments();
            this.report(25, ast, new Object[]{classType, args});
        } else {
            this.constructors.add(node);
        }
        return null;
    }

    public Object visit(DelegationDeclaration ast, Object context) {
        FieldNode node = (FieldNode)this.state.lookupKernelNode(ast);
        if (node == null) {
            return null;
        }
        if (this.fields.contains(node)) {
            ClassSymbol classType = node.getClassType();
            String name = node.getName();
            this.report(9, ast, new Object[]{classType, name});
        } else {
            this.fields.add(node);
        }
        return null;
    }

    public Object visit(MethodDeclaration ast, Object context) {
        MethodNode node = (MethodNode)this.state.lookupKernelNode(ast);
        if (node == null) {
            return null;
        }
        if (this.methods.contains(node)) {
            ClassSymbol classType = node.getClassType();
            String name = node.getName();
            TypeSymbol[] args = node.getArguments();
            this.report(10, ast, new Object[]{classType, name, args});
        } else {
            this.methods.add(node);
        }
        return null;
    }

    public Object visit(FieldDeclaration ast, Object context) {
        FieldNode node = (FieldNode)this.state.lookupKernelNode(ast);
        if (node == null) {
            return null;
        }
        if (this.fields.contains(node)) {
            ClassSymbol classType = node.getClassType();
            String name = node.getName();
            this.report(9, ast, new Object[]{classType, name});
        } else {
            this.fields.add(node);
        }
        return null;
    }

    public Object visit(InterfaceMethodDeclaration ast, Object context) {
        MethodNode node = (MethodNode)this.state.lookupKernelNode(ast);
        if (node == null) {
            return null;
        }
        if (this.methods.contains(node)) {
            ClassSymbol classType = node.getClassType();
            String name = node.getName();
            TypeSymbol[] args = node.getArguments();
            this.report(10, ast, new Object[]{classType, name, args});
        } else {
            this.methods.add(node);
        }
        return null;
    }

    public Object visit(FunctionDeclaration ast, Object context) {
        MethodNode node = (MethodNode)this.state.lookupKernelNode(ast);
        if (node == null) {
            return null;
        }
        if (this.functions.contains(node)) {
            ClassSymbol classType = node.getClassType();
            String name = node.getName();
            TypeSymbol[] args = node.getArguments();
            this.report(12, ast, new Object[]{name, args});
        } else {
            this.functions.add(node);
        }
        return null;
    }

    public Object visit(GlobalVariableDeclaration ast, Object context) {
        FieldNode node = (FieldNode)this.state.lookupKernelNode(ast);
        if (node == null) {
            return null;
        }
        if (this.globalVariables.contains(node)) {
            ClassSymbol classType = node.getClassType();
            String name = node.getName();
            this.report(11, ast, new Object[]{name});
        } else {
            this.globalVariables.add(node);
        }
        return null;
    }

    public Object visit(AccessSection section, Object context) {
        if (section == null) {
            return null;
        }
        MemberDeclaration[] members = section.getMembers();
        for (int i = 0; i < members.length; ++i) {
            this.accept(members[i], context);
        }
        return null;
    }

    private void report(int error, AbstractSyntaxTreeNode ast, Object[] items) {
        this.state.report(error, ast, items);
    }
}

