/*
 * Decompiled with CFR 0.152.
 */
package org.onion_lang.onion.lang.kernel;

import org.onion_lang.onion.lang.kernel.BooleanNode;
import org.onion_lang.onion.lang.kernel.ByteNode;
import org.onion_lang.onion.lang.kernel.CharNode;
import org.onion_lang.onion.lang.kernel.DoubleNode;
import org.onion_lang.onion.lang.kernel.FloatNode;
import org.onion_lang.onion.lang.kernel.IntegerNode;
import org.onion_lang.onion.lang.kernel.KernelNode;
import org.onion_lang.onion.lang.kernel.LongNode;
import org.onion_lang.onion.lang.kernel.NullNode;
import org.onion_lang.onion.lang.kernel.ShortNode;
import org.onion_lang.onion.lang.kernel.type.BasicSymbol;
import org.onion_lang.onion.lang.kernel.type.TypeSymbol;

public abstract class ExpressionNode
implements KernelNode {
    public abstract TypeSymbol type();

    public boolean isBasicType() {
        return this.type().isBasicType();
    }

    public boolean isArrayType() {
        return this.type().isArrayType();
    }

    public boolean isClassType() {
        return this.type().isClassType();
    }

    public boolean isNullType() {
        return this.type().isNullType();
    }

    public boolean isReferenceType() {
        return this.type().isReferenceType();
    }

    public static ExpressionNode defaultValue(TypeSymbol type) {
        if (type == BasicSymbol.CHAR) {
            return new CharNode('\u0000');
        }
        if (type == BasicSymbol.BYTE) {
            return new ByteNode(0);
        }
        if (type == BasicSymbol.SHORT) {
            return new ShortNode(0);
        }
        if (type == BasicSymbol.INT) {
            return new IntegerNode(0);
        }
        if (type == BasicSymbol.LONG) {
            return new LongNode(0L);
        }
        if (type == BasicSymbol.FLOAT) {
            return new FloatNode(0.0f);
        }
        if (type == BasicSymbol.DOUBLE) {
            return new DoubleNode(0.0);
        }
        if (type == BasicSymbol.BOOLEAN) {
            return new BooleanNode(false);
        }
        if (type.isReferenceType()) {
            return new NullNode();
        }
        return null;
    }
}

