/*
 * Decompiled with CFR 0.152.
 */
package org.onion_lang.onion.compiler;

import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.onion_lang.onion.lang.kernel.type.ArraySymbol;
import org.onion_lang.onion.lang.kernel.type.BasicSymbol;
import org.onion_lang.onion.lang.kernel.type.ClassSymbol;
import org.onion_lang.onion.lang.kernel.type.TypeSymbol;

public class VMTypeBridge {
    private static Map basicTypeTable = new HashMap(){
        {
            this.put(BasicSymbol.BYTE, BasicType.BYTE);
            this.put(BasicSymbol.SHORT, BasicType.SHORT);
            this.put(BasicSymbol.CHAR, BasicType.CHAR);
            this.put(BasicSymbol.INT, BasicType.INT);
            this.put(BasicSymbol.LONG, BasicType.LONG);
            this.put(BasicSymbol.FLOAT, BasicType.FLOAT);
            this.put(BasicSymbol.DOUBLE, BasicType.DOUBLE);
            this.put(BasicSymbol.BOOLEAN, BasicType.BOOLEAN);
            this.put(BasicSymbol.VOID, BasicType.VOID);
        }
    };

    public Type toVMType(TypeSymbol type) {
        if (type.isBasicType()) {
            return (BasicType)basicTypeTable.get(type);
        }
        if (type.isArrayType()) {
            ArraySymbol arrayType = (ArraySymbol)type;
            return new ArrayType(this.toVMType(arrayType.getComponent()), arrayType.getDimension());
        }
        if (type.isClassType()) {
            return new ObjectType(((ClassSymbol)type).getName());
        }
        return Type.NULL;
    }
}

