/*
 * Decompiled with CFR 0.152.
 */
package org.onion_lang.onion.compiler.environment;

import org.onion_lang.onion.compiler.environment.ClosureLocalBinding;
import org.onion_lang.onion.compiler.environment.LocalFrame;
import org.onion_lang.onion.compiler.utility.SymbolGenerator;
import org.onion_lang.onion.lang.kernel.ConstructorNode;
import org.onion_lang.onion.lang.kernel.type.BasicSymbol;
import org.onion_lang.onion.lang.kernel.type.ConstructorSymbol;
import org.onion_lang.onion.lang.kernel.type.MethodSymbol;
import org.onion_lang.onion.lang.kernel.type.TypeSymbol;

public class LocalContext {
    private boolean isStatic;
    private boolean isGlobal;
    private boolean isMethod;
    private LocalFrame contextFrame = new LocalFrame(null);
    private MethodSymbol method;
    private ConstructorNode constructor;
    private SymbolGenerator generator = new SymbolGenerator("symbol#");

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public void setGlobal(boolean isGlobal) {
        this.isGlobal = isGlobal;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public String generateName() {
        return this.generator.generate();
    }

    public TypeSymbol getReturnType() {
        if (this.isMethod) {
            return this.method.getReturnType();
        }
        return BasicSymbol.VOID;
    }

    public MethodSymbol getMethod() {
        return this.method;
    }

    public ConstructorSymbol getConstructor() {
        return this.constructor;
    }

    public void setMethod(MethodSymbol method) {
        this.method = method;
        this.isMethod = true;
    }

    public void setConstructor(ConstructorNode constructor) {
        this.constructor = constructor;
        this.isMethod = false;
    }

    public void openFrame() {
        this.contextFrame = new LocalFrame(this.contextFrame);
    }

    public void closeFrame() {
        this.contextFrame = this.contextFrame.getParent();
    }

    public int depth() {
        if (this.contextFrame == null) {
            return -1;
        }
        return this.contextFrame.depth();
    }

    public LocalFrame getContextFrame() {
        return this.contextFrame;
    }

    public void setContextFrame(LocalFrame frame) {
        this.contextFrame = frame;
    }

    public void openScope() {
        this.contextFrame.openScope();
    }

    public void closeScope() {
        this.contextFrame.closeScope();
    }

    public ClosureLocalBinding lookup(String name) {
        return this.contextFrame.lookup(name);
    }

    public ClosureLocalBinding lookupOnlyCurrentScope(String name) {
        return this.contextFrame.lookupOnlyCurrentScope(name);
    }

    public int addEntry(String name, TypeSymbol type) {
        return this.contextFrame.addEntry(name, type);
    }

    public String addEntry(TypeSymbol type) {
        String name = this.generateName();
        this.contextFrame.addEntry(name, type);
        return name;
    }
}

