/*
 * Decompiled with CFR 0.152.
 */
package org.onion_lang.onion.compiler.environment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.onion_lang.onion.compiler.environment.ClosureLocalBinding;
import org.onion_lang.onion.compiler.environment.LocalBinding;
import org.onion_lang.onion.compiler.environment.LocalScope;
import org.onion_lang.onion.lang.kernel.type.TypeSymbol;

public class LocalFrame {
    private LocalFrame parent;
    private LocalScope scope;
    private List allScopes;
    private int maxIndex;
    private boolean closed;

    public LocalFrame(LocalFrame parent) {
        this.parent = parent;
        this.scope = new LocalScope(null);
        this.allScopes = new ArrayList();
        this.allScopes.add(this.scope);
    }

    public LocalFrame newChildFrame() {
        return new LocalFrame(this);
    }

    public LocalFrame getParent() {
        return this.parent;
    }

    public void openScope() {
        this.scope = this.scope.newChildScope();
        this.allScopes.add(this.scope);
    }

    LocalScope getScope() {
        return this.scope;
    }

    public void closeScope() {
        this.scope = this.scope.getParent();
    }

    public LocalBinding[] entries() {
        Set entries = this.entrySet();
        LocalBinding[] binds = new LocalBinding[entries.size()];
        Iterator iterator = entries.iterator();
        for (int i = 0; i < binds.length; ++i) {
            binds[i] = (LocalBinding)iterator.next();
        }
        Arrays.sort(binds, new Comparator(){

            public int compare(Object binding1, Object binding2) {
                return ((LocalBinding)binding1).getIndex() - ((LocalBinding)binding2).getIndex();
            }
        });
        return binds;
    }

    public int addEntry(String name, TypeSymbol type) {
        LocalBinding bind = this.scope.get(name);
        if (bind != null) {
            return -1;
        }
        int index = this.maxIndex++;
        this.scope.put(name, new LocalBinding(index, type));
        return index;
    }

    public ClosureLocalBinding lookup(String name) {
        LocalFrame frame = this;
        int frameIndex = 0;
        while (frame != null) {
            LocalBinding binding = frame.scope.lookup(name);
            if (binding != null) {
                return new ClosureLocalBinding(frameIndex, binding.getIndex(), binding.getType());
            }
            ++frameIndex;
            frame = frame.parent;
        }
        return null;
    }

    public ClosureLocalBinding lookupOnlyCurrentScope(String name) {
        LocalBinding binding = this.scope.get(name);
        if (binding != null) {
            return new ClosureLocalBinding(0, binding.getIndex(), binding.getType());
        }
        return null;
    }

    public void setAllClosed(boolean closed) {
        for (LocalFrame frame = this; frame != null; frame = frame.getParent()) {
            frame.setClosed(closed);
        }
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public int depth() {
        int depth = -1;
        for (LocalFrame frame = this; frame != null; frame = frame.getParent()) {
            ++depth;
        }
        return depth;
    }

    private Set entrySet() {
        HashSet entries = new HashSet();
        Iterator scopes = this.allScopes.iterator();
        while (scopes.hasNext()) {
            entries.addAll(((LocalScope)scopes.next()).entries());
        }
        return entries;
    }
}

