/*
 * Decompiled with CFR 0.152.
 */
package org.onion_lang.onion.compiler.environment;

import org.onion_lang.onion.compiler.environment.ClassTable;
import org.onion_lang.onion.compiler.environment.ImportList;
import org.onion_lang.onion.lang.kernel.type.BasicSymbol;
import org.onion_lang.onion.lang.kernel.type.ClassSymbol;
import org.onion_lang.onion.lang.kernel.type.TypeSymbol;
import org.onion_lang.onion.lang.syntax.TypeComponent;
import org.onion_lang.onion.lang.syntax.TypeSpecifier;

public class NameResolution {
    private ImportList imports;
    private ClassTable table;

    public NameResolution(ImportList imports, ClassTable table) {
        this.imports = imports;
        this.table = table;
    }

    public TypeSymbol resolve(TypeSpecifier specifier) {
        TypeSymbol componentType = this.resolveSub(specifier.getComponent());
        if (specifier.getDimension() > 0) {
            return this.table.loadArray(componentType, specifier.getDimension());
        }
        return componentType;
    }

    private TypeSymbol resolveSub(TypeComponent component) {
        String name = component.getName();
        if (component.getKind() == 0) {
            if (name.equals("char")) {
                return BasicSymbol.CHAR;
            }
            if (name.equals("byte")) {
                return BasicSymbol.BYTE;
            }
            if (name.equals("short")) {
                return BasicSymbol.SHORT;
            }
            if (name.equals("int")) {
                return BasicSymbol.INT;
            }
            if (name.equals("long")) {
                return BasicSymbol.LONG;
            }
            if (name.equals("float")) {
                return BasicSymbol.FLOAT;
            }
            if (name.equals("double")) {
                return BasicSymbol.DOUBLE;
            }
            if (name.equals("boolean")) {
                return BasicSymbol.BOOLEAN;
            }
            return BasicSymbol.VOID;
        }
        if (component.getKind() == 1) {
            return this.forSName(name);
        }
        return this.forQName(name);
    }

    private ClassSymbol forQName(String qualifiedName) {
        return this.table.load(qualifiedName);
    }

    private ClassSymbol forSName(String simpleName) {
        for (int i = 0; i < this.imports.size(); ++i) {
            ClassSymbol resolvedSymbol;
            String qualifiedName = this.imports.get(i).match(simpleName);
            if (qualifiedName == null || (resolvedSymbol = this.forQName(qualifiedName)) == null) continue;
            return resolvedSymbol;
        }
        return null;
    }
}

