/*
 * Decompiled with CFR 0.152.
 */
package org.onion_lang.onion.compiler.environment.javawrapper;

import java.util.ArrayList;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;
import org.onion_lang.onion.compiler.OnionTypeBridge;
import org.onion_lang.onion.compiler.environment.ClassTable;
import org.onion_lang.onion.compiler.environment.javawrapper.ClassFileConstructorSymbol;
import org.onion_lang.onion.compiler.environment.javawrapper.ClassFileFieldSymbol;
import org.onion_lang.onion.compiler.environment.javawrapper.ClassFileMethodSymbol;
import org.onion_lang.onion.lang.kernel.type.AbstractClassSymbol;
import org.onion_lang.onion.lang.kernel.type.ClassSymbol;
import org.onion_lang.onion.lang.kernel.type.ConstructorSymbol;
import org.onion_lang.onion.lang.kernel.type.FieldSymbol;
import org.onion_lang.onion.lang.kernel.type.MethodSymbol;
import org.onion_lang.onion.lang.kernel.type.TypeSymbol;

public class ClassFileSymbol
extends AbstractClassSymbol
implements Constants {
    private static final String CONSTRUCTOR_NAME = "<init>";
    private JavaClass javaClass;
    private ClassTable table;
    private int modifier;
    private MethodSymbol[] methods;
    private FieldSymbol[] fields;
    private ConstructorSymbol[] constructors;
    private OnionTypeBridge bridge;

    public ClassFileSymbol(JavaClass javaClass, ClassTable table) {
        this.javaClass = javaClass;
        this.table = table;
        this.bridge = new OnionTypeBridge(table);
        this.modifier = ClassFileSymbol.toOnionModifier(javaClass.getModifiers());
    }

    public boolean isInterface() {
        return (this.javaClass.getModifiers() & 0x200) != 0;
    }

    public int getModifier() {
        return this.modifier;
    }

    public String getName() {
        return this.javaClass.getClassName();
    }

    public ClassSymbol getSuperClass() {
        ClassSymbol superClass = this.table.load(this.javaClass.getSuperclassName());
        if (superClass == this) {
            return null;
        }
        return superClass;
    }

    public ClassSymbol[] getInterfaces() {
        String[] interfaceNames = this.javaClass.getInterfaceNames();
        ClassSymbol[] interfaces = new ClassSymbol[interfaceNames.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaces[i] = this.table.load(interfaceNames[i]);
        }
        return interfaces;
    }

    public MethodSymbol[] getMethods() {
        if (this.methods == null) {
            this.setMethods(this.javaClass.getMethods());
        }
        return (MethodSymbol[])this.methods.clone();
    }

    public FieldSymbol[] getFields() {
        if (this.fields == null) {
            this.setFields(this.javaClass.getFields());
        }
        return (FieldSymbol[])this.fields.clone();
    }

    public ConstructorSymbol[] getConstructors() {
        if (this.constructors == null) {
            this.setConstructors(this.javaClass.getMethods());
        }
        return (ConstructorSymbol[])this.constructors.clone();
    }

    private static int toOnionModifier(int src) {
        int modifier = 0;
        return modifier |= ClassFileSymbol.isOn(src, 16) ? 4 : (modifier |= ClassFileSymbol.isOn(src, 1024) ? 8 : (modifier |= ClassFileSymbol.isOn(src, 32) ? 2 : (modifier |= ClassFileSymbol.isOn(src, 8) ? 32 : (modifier |= ClassFileSymbol.isOn(src, 1) ? 128 : (modifier |= ClassFileSymbol.isOn(src, 4) ? 256 : (modifier |= ClassFileSymbol.isOn(src, 2) ? 512 : modifier))))));
    }

    private static boolean isOn(int modifier, int flag) {
        return (modifier & flag) != 0;
    }

    private void setMethods(Method[] methods) {
        ArrayList<MethodSymbol> symbols = new ArrayList<MethodSymbol>();
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].getName().equals(CONSTRUCTOR_NAME)) continue;
            symbols.add(this.convertMethod(methods[i]));
        }
        this.methods = symbols.toArray(new MethodSymbol[0]);
    }

    private void setFields(Field[] fields) {
        FieldSymbol[] symbols = new FieldSymbol[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            symbols[i] = this.convertField(fields[i]);
        }
        this.fields = symbols;
    }

    private void setConstructors(Method[] methods) {
        ArrayList<ConstructorSymbol> symbols = new ArrayList<ConstructorSymbol>();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(CONSTRUCTOR_NAME)) continue;
            symbols.add(this.convertConstructor(methods[i]));
        }
        this.constructors = symbols.toArray(new ConstructorSymbol[0]);
    }

    private MethodSymbol convertMethod(Method method) {
        Type[] arguments = method.getArgumentTypes();
        TypeSymbol[] argumentSymbols = new TypeSymbol[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Type argument = arguments[i];
            argumentSymbols[i] = this.bridge.toOnionType(arguments[i]);
        }
        TypeSymbol returnSymbol = this.bridge.toOnionType(method.getReturnType());
        return new ClassFileMethodSymbol(ClassFileSymbol.toOnionModifier(method.getModifiers()), this, method.getName(), argumentSymbols, returnSymbol);
    }

    private FieldSymbol convertField(Field field) {
        TypeSymbol symbol = this.bridge.toOnionType(field.getType());
        return new ClassFileFieldSymbol(ClassFileSymbol.toOnionModifier(field.getModifiers()), this, field.getName(), symbol);
    }

    private ConstructorSymbol convertConstructor(Method method) {
        Type[] arguments = method.getArgumentTypes();
        TypeSymbol[] argumentSymbols = new TypeSymbol[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Type argument = arguments[i];
            argumentSymbols[i] = this.bridge.toOnionType(arguments[i]);
        }
        return new ClassFileConstructorSymbol(ClassFileSymbol.toOnionModifier(method.getModifiers()), this, method.getName(), argumentSymbols);
    }
}

