/*
 * Decompiled with CFR 0.152.
 */
package org.onion_lang.onion.compiler.phase;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.onion_lang.onion.compiler.CompilerConfig;
import org.onion_lang.onion.compiler.environment.ClassTable;
import org.onion_lang.onion.compiler.environment.ImportList;
import org.onion_lang.onion.compiler.environment.NameResolution;
import org.onion_lang.onion.compiler.phase.analysis.ClassTableBuilder;
import org.onion_lang.onion.compiler.phase.analysis.DuplicationChecker;
import org.onion_lang.onion.compiler.phase.analysis.TypeChecker;
import org.onion_lang.onion.compiler.phase.analysis.TypeHeaderAnalysis;
import org.onion_lang.onion.compiler.problem.CompilationFailureException;
import org.onion_lang.onion.compiler.problem.CompilationProblem;
import org.onion_lang.onion.compiler.problem.SemanticErrorReporter;
import org.onion_lang.onion.compiler.utility.Paths;
import org.onion_lang.onion.compiler.utility.Systems;
import org.onion_lang.onion.lang.kernel.BinaryExpressionNode;
import org.onion_lang.onion.lang.kernel.ClassNode;
import org.onion_lang.onion.lang.kernel.ExpressionNode;
import org.onion_lang.onion.lang.kernel.KernelNode;
import org.onion_lang.onion.lang.kernel.type.ArraySymbol;
import org.onion_lang.onion.lang.kernel.type.BasicSymbol;
import org.onion_lang.onion.lang.kernel.type.ClassSymbol;
import org.onion_lang.onion.lang.kernel.type.TypeSymbol;
import org.onion_lang.onion.lang.syntax.ASTNode;
import org.onion_lang.onion.lang.syntax.CompilationUnit;
import org.onion_lang.onion.lang.syntax.ModuleDeclaration;
import org.onion_lang.onion.lang.syntax.TypeSpecifier;

public class CodeAnalysisPhase
implements SemanticErrorReporter.Constants,
BinaryExpressionNode.Constants {
    private SemanticErrorReporter reporter;
    private CompilerConfig configuration;
    private ClassTable table;
    private Map toAST;
    private Map toKernelNode;
    private Map resolutions;
    private ClassTableBuilder builder;
    private TypeHeaderAnalysis analysis;
    private DuplicationChecker duplicationChecker;
    private TypeChecker checker;
    private CompilationUnit currentUnit;
    private ImportList currentImport;
    private ClassNode contextClass;
    private NameResolution currentResolver;
    private int access;

    public CodeAnalysisPhase(CompilerConfig configuration) {
        this.configuration = configuration;
        this.table = new ClassTable(CodeAnalysisPhase.classpath(configuration.getClassPath()));
        this.builder = new ClassTableBuilder(this);
        this.analysis = new TypeHeaderAnalysis(this);
        this.duplicationChecker = new DuplicationChecker(this);
        this.checker = new TypeChecker(this);
        this.toAST = new HashMap();
        this.toKernelNode = new HashMap();
        this.resolutions = new HashMap();
        this.reporter = new SemanticErrorReporter(configuration.getMaxErrorReports());
    }

    public String topClass() {
        ModuleDeclaration module = this.currentUnit.getModuleDeclaration();
        String moduleName = module != null ? module.getName() : null;
        return this.createName(moduleName, Paths.extCutName(this.currentUnit.getSourceFileName()) + "Main");
    }

    public ClassTable table() {
        return this.table;
    }

    public void setCurrentResolver(NameResolution resolver) {
        this.currentResolver = resolver;
    }

    public NameResolution getCurrentResolver() {
        return this.currentResolver;
    }

    public void setUnit(CompilationUnit unit) {
        this.currentUnit = unit;
    }

    public CompilationUnit getUnit() {
        return this.currentUnit;
    }

    public void setImport(ImportList imports) {
        this.currentImport = imports;
    }

    public ImportList getImport() {
        return this.currentImport;
    }

    public void put(ASTNode astNode, KernelNode kernelNode) {
        this.toKernelNode.put(astNode, kernelNode);
        this.toAST.put(kernelNode, astNode);
    }

    public ASTNode lookupAST(KernelNode kernelNode) {
        return (ASTNode)this.toAST.get(kernelNode);
    }

    public KernelNode lookupKernelNode(ASTNode astNode) {
        return (KernelNode)this.toKernelNode.get(astNode);
    }

    public void setContextClass(ClassNode contextClass) {
        this.contextClass = contextClass;
    }

    public ClassNode getContextClass() {
        return this.contextClass;
    }

    public void setAccess(int access) {
        this.access = access;
    }

    public int getAccess() {
        return this.access;
    }

    public void putResolver(String className, NameResolution table) {
        this.resolutions.put(className, table);
    }

    public NameResolution getResolver(String className) {
        return (NameResolution)this.resolutions.get(className);
    }

    private String createName(String moduleName, String simpleName) {
        return (moduleName != null ? moduleName + "." : "") + simpleName;
    }

    public ClassNode[] process(CompilationUnit[] units) {
        int i;
        for (i = 0; i < units.length; ++i) {
            this.builder.process(units[i]);
        }
        for (i = 0; i < units.length; ++i) {
            this.analysis.process(units[i]);
        }
        for (i = 0; i < units.length; ++i) {
            this.checker.process(units[i]);
        }
        for (i = 0; i < units.length; ++i) {
            this.duplicationChecker.process(units[i]);
        }
        CompilationProblem[] problems = this.reporter.getProblems();
        if (problems.length > 0) {
            throw new CompilationFailureException(Arrays.asList(problems));
        }
        return this.table.getSourceClasses();
    }

    private static String classpath(String[] classPaths) {
        StringBuffer path = new StringBuffer();
        if (classPaths.length > 0) {
            path.append(classPaths[0]);
            for (int i = 1; i < classPaths.length; ++i) {
                path.append(Systems.getPathSeparator());
                path.append(classPaths[i]);
            }
        }
        return new String(path);
    }

    public TypeSymbol resolve(TypeSpecifier type, NameResolution resolver) {
        TypeSymbol resolvedType = resolver.resolve(type);
        if (resolvedType == null) {
            this.report(3, type, new Object[]{type.getComponentName()});
        }
        return resolvedType;
    }

    public TypeSymbol resolve(TypeSpecifier type) {
        return this.resolve(type, this.getCurrentResolver());
    }

    public void report(int error, ASTNode node, Object[] items) {
        this.reporter.setSourceFile(this.currentUnit.getSourceFileName());
        this.reporter.report(error, node.getSourcePosition(), items);
    }

    public static TypeSymbol promoteNumericTypes(TypeSymbol left, TypeSymbol right) {
        if (!CodeAnalysisPhase.numeric(left) || !CodeAnalysisPhase.numeric(right)) {
            return null;
        }
        if (left == BasicSymbol.DOUBLE || right == BasicSymbol.DOUBLE) {
            return BasicSymbol.DOUBLE;
        }
        if (left == BasicSymbol.FLOAT || right == BasicSymbol.FLOAT) {
            return BasicSymbol.FLOAT;
        }
        if (left == BasicSymbol.LONG || right == BasicSymbol.LONG) {
            return BasicSymbol.LONG;
        }
        return BasicSymbol.INT;
    }

    public static boolean hasNumericType(ExpressionNode expression) {
        return CodeAnalysisPhase.numeric(expression.type());
    }

    private static boolean numeric(TypeSymbol symbol) {
        return symbol.isBasicType() && (symbol == BasicSymbol.BYTE || symbol == BasicSymbol.SHORT || symbol == BasicSymbol.INT || symbol == BasicSymbol.LONG || symbol == BasicSymbol.FLOAT || symbol == BasicSymbol.DOUBLE);
    }

    public ClassSymbol load(String name) {
        return this.table.load(name);
    }

    public ClassSymbol loadTopClass() {
        return this.table.load(this.topClass());
    }

    public ArraySymbol loadArray(TypeSymbol type, int dimension) {
        return this.table.loadArray(type, dimension);
    }

    public ClassSymbol rootClass() {
        return this.table.rootClass();
    }
}

