/*
 * Decompiled with CFR 0.152.
 */
package org.onion_lang.onion.compiler.phase;

import java.io.IOException;
import java.util.ArrayList;
import org.onion_lang.onion.compiler.CompilerConfig;
import org.onion_lang.onion.compiler.problem.CompilationFailureException;
import org.onion_lang.onion.compiler.problem.CompilationProblem;
import org.onion_lang.onion.compiler.utility.Inputs;
import org.onion_lang.onion.compiler.utility.Messages;
import org.onion_lang.onion.lang.syntax.CompilationUnit;
import org.onion_lang.onion.lang.syntax.SourcePosition;
import org.onion_lang.onion.lang.syntax.parser.JavaccOnionParser;
import org.onion_lang.onion.lang.syntax.parser.ParseException;
import org.onion_lang.onion.lang.syntax.parser.Token;

public class ParsingPhase {
    private CompilerConfig config;

    public ParsingPhase(CompilerConfig config) {
        this.config = config;
    }

    public CompilationUnit[] process(String[] paths) {
        CompilationUnit[] units = new CompilationUnit[paths.length];
        ArrayList<CompilationProblem> problems = new ArrayList<CompilationProblem>();
        for (int i = 0; i < paths.length; ++i) {
            try {
                units[i] = this.parse(paths[i]);
                continue;
            }
            catch (IOException e) {
                problems.add(ParsingPhase.createFileCannotRead(paths[i]));
                continue;
            }
            catch (ParseException e) {
                problems.add(ParsingPhase.createParseFailure(paths[i], e));
            }
        }
        if (problems.size() > 0) {
            throw new CompilationFailureException(problems);
        }
        return units;
    }

    static CompilationProblem createFileCannotRead(String path) {
        return new CompilationProblem(null, null, Messages.get("error.fileRead", path));
    }

    static CompilationProblem createParseFailure(String path, ParseException ex) {
        Token errorToken = ex.currentToken.next;
        return new CompilationProblem(path, new SourcePosition(errorToken.beginColumn, errorToken.beginColumn), Messages.get("error.parsing.syntax", ex.getLocalizedMessage()));
    }

    static String toString(int value) {
        return Integer.toString(value);
    }

    JavaccOnionParser parser(String path) throws IOException {
        return new JavaccOnionParser(Inputs.newReader(path, this.config.getEncoding()));
    }

    CompilationUnit parse(String path) throws IOException, ParseException {
        CompilationUnit unit = this.parser(path).CompilationUnit();
        unit.setSourceFileName(path);
        return unit;
    }
}

