/*
 * Decompiled with CFR 0.152.
 */
package org.onion_lang.onion.compiler.phase.analysis;

import org.onion_lang.onion.compiler.environment.ClassTable;
import org.onion_lang.onion.compiler.environment.ImportItem;
import org.onion_lang.onion.compiler.environment.ImportList;
import org.onion_lang.onion.compiler.environment.NameResolution;
import org.onion_lang.onion.compiler.phase.CodeAnalysisPhase;
import org.onion_lang.onion.compiler.problem.SemanticErrorReporter;
import org.onion_lang.onion.compiler.utility.Paths;
import org.onion_lang.onion.lang.kernel.ClassNode;
import org.onion_lang.onion.lang.kernel.type.ClassSymbol;
import org.onion_lang.onion.lang.syntax.ClassDeclaration;
import org.onion_lang.onion.lang.syntax.CompilationUnit;
import org.onion_lang.onion.lang.syntax.ImportListDeclaration;
import org.onion_lang.onion.lang.syntax.InterfaceDeclaration;
import org.onion_lang.onion.lang.syntax.ModuleDeclaration;
import org.onion_lang.onion.lang.syntax.TopLevelElement;
import org.onion_lang.onion.lang.syntax.TypeDeclaration;
import org.onion_lang.onion.lang.syntax.visitor.ASTVisitor;

public class ClassTableBuilder
extends ASTVisitor
implements SemanticErrorReporter.Constants {
    private CodeAnalysisPhase phase;

    public ClassTableBuilder(CodeAnalysisPhase phase) {
        this.phase = phase;
    }

    public void process(CompilationUnit unit) {
        this.phase.setUnit(unit);
        ModuleDeclaration module = unit.getModuleDeclaration();
        String moduleName = module != null ? module.getName() : null;
        ImportList imports = this.createImport(moduleName, unit.getImportListDeclaration());
        this.phase.setImport(imports);
        TopLevelElement[] toplevels = unit.getTopLevels();
        int count = 0;
        for (int i = 0; i < toplevels.length; ++i) {
            TopLevelElement toplevel = toplevels[i];
            if (toplevel instanceof TypeDeclaration) {
                this.accept(toplevel, moduleName);
                continue;
            }
            ++count;
        }
        ClassTable table = this.phase.table();
        if (count > 0) {
            ClassNode node = ClassNode.newClass(0, this.phase.topClass(), table.rootClass(), new ClassSymbol[0]);
            node.setSourceFile(Paths.getName(unit.getSourceFileName()));
            node.setResolutionComplete(true);
            table.addSourceClass(node);
            node.addDefaultConstructor();
            this.phase.put(unit, node);
            this.phase.putResolver(node.getName(), new NameResolution(imports, table));
        }
    }

    public Object visit(ClassDeclaration ast, Object context) {
        String module = (String)context;
        ClassNode node = ClassNode.newClass(ast.getModifier(), this.createName(module, ast.getName()), null, null);
        node.setSourceFile(Paths.getName(this.phase.getUnit().getSourceFileName()));
        if (this.phase.table().lookup(node.getName()) != null) {
            this.phase.report(8, ast, new Object[]{node.getName()});
            return null;
        }
        ClassTable table = this.phase.table();
        this.phase.table().addSourceClass(node);
        this.phase.put(ast, node);
        this.phase.putResolver(node.getName(), new NameResolution(this.phase.getImport(), table));
        return null;
    }

    public Object visit(InterfaceDeclaration ast, Object context) {
        String module = (String)context;
        ClassNode node = ClassNode.newInterface(ast.getModifier(), this.createName(module, ast.getName()), null);
        node.setSourceFile(Paths.getName(this.phase.getUnit().getSourceFileName()));
        ClassTable table = this.phase.table();
        if (table.lookup(node.getName()) != null) {
            this.phase.report(8, ast, new Object[]{node.getName()});
            return null;
        }
        table.addSourceClass(node);
        this.phase.put(ast, node);
        this.phase.putResolver(node.getName(), new NameResolution(this.phase.getImport(), this.phase.table()));
        return null;
    }

    private ImportList createImport(String module, ImportListDeclaration imports) {
        ImportList list = new ImportList();
        list.add(new ImportItem("*", "java.lang.*"));
        list.add(new ImportItem("*", "java.io.*"));
        list.add(new ImportItem("*", "java.util.*"));
        list.add(new ImportItem("*", "javax.swing.*"));
        list.add(new ImportItem("*", module != null ? module + ".*" : "*"));
        if (imports != null) {
            for (int i = 0; i < imports.size(); ++i) {
                list.add(new ImportItem(imports.getName(i), imports.getFQCN(i)));
            }
        }
        return list;
    }

    private String createName(String moduleName, String simpleName) {
        return (moduleName != null ? moduleName + "." : "") + simpleName;
    }
}

