/*
 * Decompiled with CFR 0.152.
 */
package org.onion_lang.onion.compiler.phase.analysis;

import java.util.ArrayList;
import org.onion_lang.onion.compiler.environment.ClosureLocalBinding;
import org.onion_lang.onion.compiler.environment.LocalContext;
import org.onion_lang.onion.compiler.environment.LocalFrame;
import org.onion_lang.onion.compiler.environment.NameResolution;
import org.onion_lang.onion.compiler.phase.CodeAnalysisPhase;
import org.onion_lang.onion.compiler.problem.SemanticErrorReporter;
import org.onion_lang.onion.compiler.utility.Boxing;
import org.onion_lang.onion.lang.kernel.ArrayAssignmentNode;
import org.onion_lang.onion.lang.kernel.ArrayLengthNode;
import org.onion_lang.onion.lang.kernel.ArrayRefNode;
import org.onion_lang.onion.lang.kernel.BinaryExpressionNode;
import org.onion_lang.onion.lang.kernel.BlockNode;
import org.onion_lang.onion.lang.kernel.BooleanNode;
import org.onion_lang.onion.lang.kernel.BreakNode;
import org.onion_lang.onion.lang.kernel.CastNode;
import org.onion_lang.onion.lang.kernel.ClassNode;
import org.onion_lang.onion.lang.kernel.ClosureNode;
import org.onion_lang.onion.lang.kernel.ConstructorNode;
import org.onion_lang.onion.lang.kernel.ContinueNode;
import org.onion_lang.onion.lang.kernel.DoubleNode;
import org.onion_lang.onion.lang.kernel.EmptyNode;
import org.onion_lang.onion.lang.kernel.ExpressionNode;
import org.onion_lang.onion.lang.kernel.ExpressionStatementNode;
import org.onion_lang.onion.lang.kernel.FieldAssignmentNode;
import org.onion_lang.onion.lang.kernel.FieldRefNode;
import org.onion_lang.onion.lang.kernel.FloatNode;
import org.onion_lang.onion.lang.kernel.IfNode;
import org.onion_lang.onion.lang.kernel.IntegerNode;
import org.onion_lang.onion.lang.kernel.IsInstanceNode;
import org.onion_lang.onion.lang.kernel.ListNode;
import org.onion_lang.onion.lang.kernel.LocalAssignmentNode;
import org.onion_lang.onion.lang.kernel.LocalRefNode;
import org.onion_lang.onion.lang.kernel.LongNode;
import org.onion_lang.onion.lang.kernel.LoopNode;
import org.onion_lang.onion.lang.kernel.MethodCallNode;
import org.onion_lang.onion.lang.kernel.MethodNode;
import org.onion_lang.onion.lang.kernel.NewArrayNode;
import org.onion_lang.onion.lang.kernel.NewNode;
import org.onion_lang.onion.lang.kernel.NullNode;
import org.onion_lang.onion.lang.kernel.ReturnNode;
import org.onion_lang.onion.lang.kernel.SelfNode;
import org.onion_lang.onion.lang.kernel.StatementNode;
import org.onion_lang.onion.lang.kernel.StaticFieldRefNode;
import org.onion_lang.onion.lang.kernel.StaticMethodCallNode;
import org.onion_lang.onion.lang.kernel.StringNode;
import org.onion_lang.onion.lang.kernel.SuperCallNode;
import org.onion_lang.onion.lang.kernel.SuperInitNode;
import org.onion_lang.onion.lang.kernel.SynchronizedNode;
import org.onion_lang.onion.lang.kernel.ThrowNode;
import org.onion_lang.onion.lang.kernel.TryNode;
import org.onion_lang.onion.lang.kernel.UnaryExpressionNode;
import org.onion_lang.onion.lang.kernel.type.ArraySymbol;
import org.onion_lang.onion.lang.kernel.type.BasicSymbol;
import org.onion_lang.onion.lang.kernel.type.ClassSymbol;
import org.onion_lang.onion.lang.kernel.type.ConstructorSymbol;
import org.onion_lang.onion.lang.kernel.type.FieldSymbol;
import org.onion_lang.onion.lang.kernel.type.MemberSymbol;
import org.onion_lang.onion.lang.kernel.type.MethodSymbol;
import org.onion_lang.onion.lang.kernel.type.ObjectSymbol;
import org.onion_lang.onion.lang.kernel.type.TypeRules;
import org.onion_lang.onion.lang.kernel.type.TypeSymbol;
import org.onion_lang.onion.lang.syntax.ASTNode;
import org.onion_lang.onion.lang.syntax.AccessSection;
import org.onion_lang.onion.lang.syntax.Addition;
import org.onion_lang.onion.lang.syntax.AdditionAssignment;
import org.onion_lang.onion.lang.syntax.ArgumentDeclaration;
import org.onion_lang.onion.lang.syntax.ArrayCreation;
import org.onion_lang.onion.lang.syntax.Assignment;
import org.onion_lang.onion.lang.syntax.BinaryExpression;
import org.onion_lang.onion.lang.syntax.BitAnd;
import org.onion_lang.onion.lang.syntax.BitOr;
import org.onion_lang.onion.lang.syntax.BlockStatement;
import org.onion_lang.onion.lang.syntax.BooleanLiteral;
import org.onion_lang.onion.lang.syntax.BreakStatement;
import org.onion_lang.onion.lang.syntax.CaseBranch;
import org.onion_lang.onion.lang.syntax.Cast;
import org.onion_lang.onion.lang.syntax.ClassDeclaration;
import org.onion_lang.onion.lang.syntax.ClosureExpression;
import org.onion_lang.onion.lang.syntax.CompilationUnit;
import org.onion_lang.onion.lang.syntax.CondStatement;
import org.onion_lang.onion.lang.syntax.ConstructorDeclaration;
import org.onion_lang.onion.lang.syntax.ContinueStatement;
import org.onion_lang.onion.lang.syntax.CurrentInstance;
import org.onion_lang.onion.lang.syntax.DelegationDeclaration;
import org.onion_lang.onion.lang.syntax.Division;
import org.onion_lang.onion.lang.syntax.DivisionAssignment;
import org.onion_lang.onion.lang.syntax.DoubleLiteral;
import org.onion_lang.onion.lang.syntax.EmptyStatement;
import org.onion_lang.onion.lang.syntax.Equal;
import org.onion_lang.onion.lang.syntax.Expression;
import org.onion_lang.onion.lang.syntax.ExpressionStatement;
import org.onion_lang.onion.lang.syntax.FieldDeclaration;
import org.onion_lang.onion.lang.syntax.FieldOrMethodRef;
import org.onion_lang.onion.lang.syntax.FloatLiteral;
import org.onion_lang.onion.lang.syntax.ForStatement;
import org.onion_lang.onion.lang.syntax.ForeachStatement;
import org.onion_lang.onion.lang.syntax.FunctionDeclaration;
import org.onion_lang.onion.lang.syntax.GlobalVariableDeclaration;
import org.onion_lang.onion.lang.syntax.GreaterOrEqual;
import org.onion_lang.onion.lang.syntax.GreaterThan;
import org.onion_lang.onion.lang.syntax.IDExpression;
import org.onion_lang.onion.lang.syntax.IfStatement;
import org.onion_lang.onion.lang.syntax.Indexing;
import org.onion_lang.onion.lang.syntax.InstanceCreation;
import org.onion_lang.onion.lang.syntax.IntegerLiteral;
import org.onion_lang.onion.lang.syntax.InterfaceDeclaration;
import org.onion_lang.onion.lang.syntax.InterfaceMethodDeclaration;
import org.onion_lang.onion.lang.syntax.IsInstance;
import org.onion_lang.onion.lang.syntax.LessOrEqual;
import org.onion_lang.onion.lang.syntax.LessThan;
import org.onion_lang.onion.lang.syntax.ListLiteral;
import org.onion_lang.onion.lang.syntax.LocalVariableDeclaration;
import org.onion_lang.onion.lang.syntax.LogicalAnd;
import org.onion_lang.onion.lang.syntax.LogicalOr;
import org.onion_lang.onion.lang.syntax.LogicalRightShift;
import org.onion_lang.onion.lang.syntax.LongLiteral;
import org.onion_lang.onion.lang.syntax.MathLeftShift;
import org.onion_lang.onion.lang.syntax.MathRightShift;
import org.onion_lang.onion.lang.syntax.MethodCall;
import org.onion_lang.onion.lang.syntax.MethodDeclaration;
import org.onion_lang.onion.lang.syntax.Modifier;
import org.onion_lang.onion.lang.syntax.Modulo;
import org.onion_lang.onion.lang.syntax.ModuloAssignment;
import org.onion_lang.onion.lang.syntax.Multiplication;
import org.onion_lang.onion.lang.syntax.MultiplicationAssignment;
import org.onion_lang.onion.lang.syntax.Negate;
import org.onion_lang.onion.lang.syntax.Not;
import org.onion_lang.onion.lang.syntax.NotEqual;
import org.onion_lang.onion.lang.syntax.NullLiteral;
import org.onion_lang.onion.lang.syntax.Posit;
import org.onion_lang.onion.lang.syntax.ReferenceEqual;
import org.onion_lang.onion.lang.syntax.ReferenceNotEqual;
import org.onion_lang.onion.lang.syntax.ReturnStatement;
import org.onion_lang.onion.lang.syntax.SelectStatement;
import org.onion_lang.onion.lang.syntax.SelfFieldReference;
import org.onion_lang.onion.lang.syntax.SelfMethodCall;
import org.onion_lang.onion.lang.syntax.Statement;
import org.onion_lang.onion.lang.syntax.StaticIDExpression;
import org.onion_lang.onion.lang.syntax.StaticMethodCall;
import org.onion_lang.onion.lang.syntax.StringLiteral;
import org.onion_lang.onion.lang.syntax.Subtraction;
import org.onion_lang.onion.lang.syntax.SubtractionAssignment;
import org.onion_lang.onion.lang.syntax.SuperMethodCall;
import org.onion_lang.onion.lang.syntax.SynchronizedStatement;
import org.onion_lang.onion.lang.syntax.ThrowStatement;
import org.onion_lang.onion.lang.syntax.TopLevelElement;
import org.onion_lang.onion.lang.syntax.TryStatement;
import org.onion_lang.onion.lang.syntax.TypeDeclaration;
import org.onion_lang.onion.lang.syntax.TypeSpecifier;
import org.onion_lang.onion.lang.syntax.WhileStatement;
import org.onion_lang.onion.lang.syntax.XOR;
import org.onion_lang.onion.lang.syntax.visitor.ASTVisitor;

public class TypeChecker
extends ASTVisitor
implements SemanticErrorReporter.Constants,
BinaryExpressionNode.Constants,
UnaryExpressionNode.Constants {
    private CodeAnalysisPhase state;

    public TypeChecker(CodeAnalysisPhase state) {
        this.state = state;
    }

    public void process(CompilationUnit unit) {
        this.accept(unit);
    }

    public Object visit(CompilationUnit unit, Object object) {
        this.state.setUnit(unit);
        TopLevelElement[] toplevels = unit.getTopLevels();
        LocalContext context = new LocalContext();
        ArrayList<StatementNode> statements = new ArrayList<StatementNode>();
        String implicitClassName = this.state.topClass();
        this.state.setCurrentResolver(this.state.getResolver(implicitClassName));
        ClassNode implicitClass = (ClassNode)this.state.loadTopClass();
        ArraySymbol argsType = this.state.loadArray(this.state.load("java.lang.String"), 1);
        MethodNode method = new MethodNode(128, implicitClass, "start", new TypeSymbol[]{argsType}, BasicSymbol.VOID, null);
        context.addEntry("args", argsType);
        for (int i = 0; i < toplevels.length; ++i) {
            TopLevelElement element = toplevels[i];
            if (!(element instanceof TypeDeclaration)) {
                this.state.setContextClass(implicitClass);
            }
            if (element instanceof Statement) {
                context.setMethod(method);
                StatementNode statement = (StatementNode)this.accept(toplevels[i], context);
                statements.add(statement);
                continue;
            }
            this.accept(toplevels[i], null);
        }
        if (implicitClass != null) {
            statements.add(new ReturnNode(null));
            method.setBlock(new BlockNode(statements.toArray(new StatementNode[0])));
            method.setFrame(context.getContextFrame());
            implicitClass.addMethod(method);
            implicitClass.addMethod(this.createStartupMethod(implicitClass, method, "main", new TypeSymbol[]{argsType}, BasicSymbol.VOID));
        }
        return null;
    }

    private MethodNode createStartupMethod(ClassSymbol top, MethodSymbol ref, String name, TypeSymbol[] args, TypeSymbol returnType) {
        MethodNode method = new MethodNode(160, top, name, args, returnType, null);
        LocalFrame frame = new LocalFrame(null);
        ExpressionNode[] params = new ExpressionNode[args.length];
        for (int i = 0; i < args.length; ++i) {
            int index = frame.addEntry("args" + i, args[i]);
            params[i] = new LocalRefNode(0, index, args[i]);
        }
        method.setFrame(frame);
        ConstructorSymbol c = top.findConstructor(new ExpressionNode[0])[0];
        ExpressionNode exp = new NewNode(c, new ExpressionNode[0]);
        exp = new MethodCallNode(exp, ref, params);
        BlockNode block = new BlockNode(new StatementNode[]{new ExpressionStatementNode(exp)});
        block = this.addReturnNode(block, BasicSymbol.VOID);
        method.setBlock(block);
        return method;
    }

    public Object visit(InterfaceDeclaration ast, Object context) {
        this.state.setContextClass((ClassNode)this.state.lookupKernelNode(ast));
        return null;
    }

    public Object visit(ClassDeclaration ast, Object context) {
        this.state.setContextClass((ClassNode)this.state.lookupKernelNode(ast));
        this.state.setCurrentResolver(this.state.getResolver(this.state.getContextClass().getName()));
        if (ast.getDefaultSection() != null) {
            this.accept(ast.getDefaultSection(), context);
        }
        this.acceptEach(ast.getSections(), context);
        return null;
    }

    public Object visit(AccessSection ast, Object context) {
        this.acceptEach(ast.getMembers(), context);
        return null;
    }

    public Object visit(Addition ast, Object context) {
        ExpressionNode left = this.processExpression(ast.getLeft(), context);
        ExpressionNode right = this.processExpression(ast.getRight(), context);
        if (left == null || right == null) {
            return null;
        }
        if (left.isBasicType() && right.isBasicType()) {
            return this.processNumericalBinaryExpression(0, ast, left, right, context);
        }
        if (left.isBasicType()) {
            if (left.type() == BasicSymbol.VOID) {
                this.report(27, ast.getLeft(), new Object[]{left.type()});
                return null;
            }
            left = Boxing.boxing(this.state.table(), left);
        }
        if (right.isBasicType()) {
            if (right.type() == BasicSymbol.VOID) {
                this.report(27, ast.getRight(), new Object[]{right.type()});
                return null;
            }
            right = Boxing.boxing(this.state.table(), right);
        }
        MethodSymbol toString = this.findMethod(ast.getLeft(), (ObjectSymbol)left.type(), "toString");
        left = new MethodCallNode(left, toString, new ExpressionNode[0]);
        toString = this.findMethod(ast.getRight(), (ObjectSymbol)right.type(), "toString");
        right = new MethodCallNode(right, toString, new ExpressionNode[0]);
        MethodSymbol concat = this.findMethod(ast, (ObjectSymbol)left.type(), "concat", new ExpressionNode[]{right});
        return new MethodCallNode(left, concat, new ExpressionNode[]{right});
    }

    public Object visit(Subtraction ast, Object context) {
        ExpressionNode left = this.processExpression(ast.getLeft(), context);
        ExpressionNode right = this.processExpression(ast.getRight(), context);
        if (left == null || right == null) {
            return null;
        }
        return this.processNumericalBinaryExpression(1, ast, left, right, context);
    }

    public Object visit(Multiplication ast, Object context) {
        ExpressionNode left = this.processExpression(ast.getLeft(), context);
        ExpressionNode right = this.processExpression(ast.getRight(), context);
        if (left == null || right == null) {
            return null;
        }
        return this.processNumericalBinaryExpression(2, ast, left, right, context);
    }

    public Object visit(Division ast, Object context) {
        ExpressionNode left = this.processExpression(ast.getLeft(), context);
        ExpressionNode right = this.processExpression(ast.getRight(), context);
        if (left == null || right == null) {
            return null;
        }
        return this.processNumericalBinaryExpression(3, ast, left, right, context);
    }

    public Object visit(Modulo ast, Object context) {
        ExpressionNode left = this.processExpression(ast.getLeft(), context);
        ExpressionNode right = this.processExpression(ast.getRight(), context);
        if (left == null || right == null) {
            return null;
        }
        return this.processNumericalBinaryExpression(4, ast, left, right, context);
    }

    public Object visit(XOR ast, Object context) {
        return this.processBitExpression(9, ast, context);
    }

    public Object visit(Equal ast, Object context) {
        return this.processEqualExpression(17, ast, context);
    }

    public Object visit(NotEqual ast, Object context) {
        return this.processEqualExpression(18, ast, context);
    }

    public Object visit(ReferenceEqual ast, Object context) {
        return this.processReferenceEqualExpression(17, ast, context);
    }

    public Object visit(ReferenceNotEqual ast, Object context) {
        return this.processReferenceEqualExpression(18, ast, context);
    }

    public Object visit(LessOrEqual ast, Object context) {
        ExpressionNode[] ops = this.processComparableExpression(ast, context);
        if (ops == null) {
            return null;
        }
        return new BinaryExpressionNode(15, BasicSymbol.BOOLEAN, ops[0], ops[1]);
    }

    public Object visit(LessThan ast, Object context) {
        ExpressionNode[] ops = this.processComparableExpression(ast, context);
        if (ops == null) {
            return null;
        }
        return new BinaryExpressionNode(13, BasicSymbol.BOOLEAN, ops[0], ops[1]);
    }

    public Object visit(GreaterOrEqual ast, Object context) {
        ExpressionNode[] ops = this.processComparableExpression(ast, context);
        if (ops == null) {
            return null;
        }
        return new BinaryExpressionNode(16, BasicSymbol.BOOLEAN, ops[0], ops[1]);
    }

    public Object visit(GreaterThan ast, Object context) {
        ExpressionNode[] ops = this.processComparableExpression(ast, context);
        if (ops == null) {
            return null;
        }
        return new BinaryExpressionNode(14, BasicSymbol.BOOLEAN, ops[0], ops[1]);
    }

    public Object visit(LogicalAnd ast, Object context) {
        ExpressionNode[] ops = this.processLogicalExpression(ast, context);
        if (ops == null) {
            return null;
        }
        return new BinaryExpressionNode(5, BasicSymbol.BOOLEAN, ops[0], ops[1]);
    }

    public Object visit(LogicalOr ast, Object context) {
        ExpressionNode[] ops = this.processLogicalExpression(ast, context);
        if (ops == null) {
            return null;
        }
        return new BinaryExpressionNode(6, BasicSymbol.BOOLEAN, ops[0], ops[1]);
    }

    public Object visit(LogicalRightShift ast, Object context) {
        return this.processShiftExpression(12, ast, context);
    }

    public Object visit(MathLeftShift ast, Object context) {
        return this.processShiftExpression(10, ast, context);
    }

    public Object visit(MathRightShift ast, Object context) {
        return this.processShiftExpression(11, ast, context);
    }

    public Object visit(BitAnd ast, Object context) {
        return this.processBitExpression(7, ast, context);
    }

    public Object visit(BitOr expression, Object context) {
        return this.processBitExpression(7, expression, context);
    }

    ExpressionNode[] processLogicalExpression(BinaryExpression ast, Object context) {
        ExpressionNode left = this.processExpression(ast.getLeft(), context);
        ExpressionNode right = this.processExpression(ast.getRight(), context);
        if (left == null || right == null) {
            return null;
        }
        TypeSymbol leftType = left.type();
        TypeSymbol rightType = right.type();
        if (leftType != BasicSymbol.BOOLEAN || rightType != BasicSymbol.BOOLEAN) {
            this.report(1, ast, new Object[]{ast.getSymbol(), new TypeSymbol[]{left.type(), right.type()}});
            return null;
        }
        return new ExpressionNode[]{left, right};
    }

    ExpressionNode processShiftExpression(int kind, BinaryExpression ast, Object context) {
        ExpressionNode left = this.processExpression(ast.getLeft(), context);
        ExpressionNode right = this.processExpression(ast.getRight(), context);
        if (left == null || right == null) {
            return null;
        }
        if (!left.type().isBasicType()) {
            ExpressionNode[] params = new ExpressionNode[]{right};
            Object[] result = this.tryFindMethod(ast, (ObjectSymbol)left.type(), "add", params);
            if (result[1] == null) {
                this.report(5, ast, new Object[]{left.type(), "add", this.types(params)});
                return null;
            }
            return new MethodCallNode(left, (MethodSymbol)result[1], params);
        }
        if (!right.type().isBasicType()) {
            this.report(1, ast, new Object[]{ast.getSymbol(), new TypeSymbol[]{left.type(), right.type()}});
            return null;
        }
        BasicSymbol leftType = (BasicSymbol)left.type();
        BasicSymbol rightType = (BasicSymbol)right.type();
        if (!leftType.isInteger() || !rightType.isInteger()) {
            this.report(1, ast, new Object[]{ast.getSymbol(), new TypeSymbol[]{left.type(), right.type()}});
            return null;
        }
        TypeSymbol leftResultType = TypeChecker.promoteInteger(leftType);
        if (leftResultType != leftType) {
            left = new CastNode(left, leftResultType);
        }
        if (rightType != BasicSymbol.INT) {
            right = new CastNode(right, BasicSymbol.INT);
        }
        return new BinaryExpressionNode(kind, BasicSymbol.BOOLEAN, left, right);
    }

    static TypeSymbol promoteInteger(TypeSymbol type) {
        if (type == BasicSymbol.BYTE || type == BasicSymbol.SHORT || type == BasicSymbol.CHAR || type == BasicSymbol.INT) {
            return BasicSymbol.INT;
        }
        if (type == BasicSymbol.LONG) {
            return BasicSymbol.LONG;
        }
        return null;
    }

    ExpressionNode processBitExpression(int kind, BinaryExpression ast, Object context) {
        ExpressionNode left = this.processExpression(ast.getLeft(), context);
        ExpressionNode right = this.processExpression(ast.getRight(), context);
        if (left == null || right == null) {
            return null;
        }
        if (!left.isBasicType() || !right.isBasicType()) {
            this.report(1, ast, new Object[]{ast.getSymbol(), new TypeSymbol[]{left.type(), right.type()}});
            return null;
        }
        BasicSymbol leftType = (BasicSymbol)left.type();
        BasicSymbol rightType = (BasicSymbol)right.type();
        TypeSymbol resultType = null;
        if (leftType.isInteger() && rightType.isInteger()) {
            resultType = TypeChecker.promoteNumericTypes(leftType, rightType);
        } else if (leftType.isBoolean() && rightType.isBoolean()) {
            resultType = BasicSymbol.BOOLEAN;
        } else {
            this.report(1, ast, new Object[]{ast.getSymbol(), new TypeSymbol[]{leftType, rightType}});
            return null;
        }
        if (left.type() != resultType) {
            left = new CastNode(left, resultType);
        }
        if (right.type() != resultType) {
            right = new CastNode(right, resultType);
        }
        return new BinaryExpressionNode(kind, resultType, left, right);
    }

    ExpressionNode processNumericalBinaryExpression(int kind, BinaryExpression ast, ExpressionNode left, ExpressionNode right, Object context) {
        if (!TypeChecker.hasNumericType(left) || !TypeChecker.hasNumericType(right)) {
            this.report(1, ast, new Object[]{ast.getSymbol(), new TypeSymbol[]{left.type(), right.type()}});
            return null;
        }
        TypeSymbol resultType = TypeChecker.promoteNumericTypes(left.type(), right.type());
        if (left.type() != resultType) {
            left = new CastNode(left, resultType);
        }
        if (right.type() != resultType) {
            right = new CastNode(right, resultType);
        }
        return new BinaryExpressionNode(kind, resultType, left, right);
    }

    ExpressionNode processReferenceEqualExpression(int kind, BinaryExpression ast, Object context) {
        ExpressionNode left = this.processExpression(ast.getLeft(), context);
        ExpressionNode right = this.processExpression(ast.getRight(), context);
        if (left == null || right == null) {
            return null;
        }
        TypeSymbol leftType = left.type();
        TypeSymbol rightType = right.type();
        if (left.isBasicType() && !right.isBasicType() || !left.isBasicType() && right.isBasicType()) {
            this.report(1, ast, new Object[]{ast.getSymbol(), new TypeSymbol[]{leftType, rightType}});
            return null;
        }
        if (left.isBasicType() && right.isBasicType()) {
            if (TypeChecker.hasNumericType(left) && TypeChecker.hasNumericType(right)) {
                TypeSymbol resultType = TypeChecker.promoteNumericTypes(leftType, rightType);
                if (resultType != left.type()) {
                    left = new CastNode(left, resultType);
                }
                if (resultType != right.type()) {
                    right = new CastNode(right, resultType);
                }
            } else if (leftType != BasicSymbol.BOOLEAN || rightType != BasicSymbol.BOOLEAN) {
                this.report(1, ast, new Object[]{ast.getSymbol(), new TypeSymbol[]{leftType, rightType}});
                return null;
            }
        }
        return new BinaryExpressionNode(kind, BasicSymbol.BOOLEAN, left, right);
    }

    ExpressionNode processEqualExpression(int kind, BinaryExpression ast, Object context) {
        ExpressionNode left = this.processExpression(ast.getLeft(), context);
        ExpressionNode right = this.processExpression(ast.getRight(), context);
        if (left == null || right == null) {
            return null;
        }
        TypeSymbol leftType = left.type();
        TypeSymbol rightType = right.type();
        if (left.isBasicType() && !right.isBasicType() || !left.isBasicType() && right.isBasicType()) {
            this.report(1, ast, new Object[]{ast.getSymbol(), new TypeSymbol[]{leftType, rightType}});
            return null;
        }
        if (left.isBasicType() && right.isBasicType()) {
            if (TypeChecker.hasNumericType(left) && TypeChecker.hasNumericType(right)) {
                TypeSymbol resultType = TypeChecker.promoteNumericTypes(leftType, rightType);
                if (resultType != left.type()) {
                    left = new CastNode(left, resultType);
                }
                if (resultType != right.type()) {
                    right = new CastNode(right, resultType);
                }
            } else if (leftType != BasicSymbol.BOOLEAN || rightType != BasicSymbol.BOOLEAN) {
                this.report(1, ast, new Object[]{ast.getSymbol(), new TypeSymbol[]{leftType, rightType}});
                return null;
            }
        } else if (left.isReferenceType() && right.isReferenceType()) {
            return this.createEquals(kind, left, right);
        }
        return new BinaryExpressionNode(kind, BasicSymbol.BOOLEAN, left, right);
    }

    ExpressionNode createEquals(int kind, ExpressionNode left, ExpressionNode right) {
        right = new CastNode(right, this.state.rootClass());
        ExpressionNode[] params = new ExpressionNode[]{right};
        ObjectSymbol target = (ObjectSymbol)left.type();
        MethodSymbol[] methods = target.findMethod("equals", params);
        ExpressionNode node = new MethodCallNode(left, methods[0], params);
        if (kind == 18) {
            node = new UnaryExpressionNode(2, BasicSymbol.BOOLEAN, node);
        }
        return node;
    }

    ExpressionNode[] processComparableExpression(BinaryExpression ast, Object context) {
        ExpressionNode left = this.processExpression(ast.getLeft(), context);
        ExpressionNode right = this.processExpression(ast.getRight(), context);
        if (left == null || right == null) {
            return null;
        }
        TypeSymbol leftType = left.type();
        TypeSymbol rightType = right.type();
        if (!TypeChecker.numeric(left.type()) || !TypeChecker.numeric(right.type())) {
            this.report(1, ast, new Object[]{ast.getSymbol(), new TypeSymbol[]{left.type(), right.type()}});
            return null;
        }
        TypeSymbol resultType = TypeChecker.promoteNumericTypes(leftType, rightType);
        if (leftType != resultType) {
            left = new CastNode(left, resultType);
        }
        if (rightType != resultType) {
            right = new CastNode(right, resultType);
        }
        return new ExpressionNode[]{left, right};
    }

    public Object visit(FloatLiteral ast, Object context) {
        return new FloatNode(ast.value);
    }

    public Object visit(SuperMethodCall ast, Object context) {
        ExpressionNode[] params = this.processExpressions(ast.getParameters(), context);
        if (params == null) {
            return null;
        }
        ClassNode contextClass = this.state.getContextClass();
        Object[] result = this.tryFindMethod(ast, contextClass.getSuperClass(), ast.getName(), params);
        if (result[1] == null) {
            Boolean notFound = (Boolean)result[0];
            if (notFound.booleanValue()) {
                this.report(5, ast, new Object[]{contextClass, ast.getName(), this.types(params)});
            }
            return null;
        }
        MethodSymbol method = (MethodSymbol)result[1];
        return new SuperCallNode(new SelfNode(contextClass), method, params);
    }

    public Object visit(DoubleLiteral ast, Object context) {
        return new DoubleNode(ast.value);
    }

    public Object visit(IntegerLiteral ast, Object context) {
        return new IntegerNode(ast.value);
    }

    public Object visit(LongLiteral ast, Object context) {
        return new LongNode(ast.getValue());
    }

    public Object visit(BooleanLiteral ast, Object context) {
        return new BooleanNode(ast.getValue());
    }

    public Object visit(ListLiteral ast, Object context) {
        ExpressionNode[] elements = new ExpressionNode[ast.size()];
        for (int i = 0; i < ast.size(); ++i) {
            elements[i] = this.processExpression(ast.getExpression(i), context);
        }
        ListNode node = new ListNode(elements, this.state.load("java.util.List"));
        return node;
    }

    public Object visit(StringLiteral ast, Object context) {
        return new StringNode(ast.value, this.state.load("java.lang.String"));
    }

    public Object visit(NullLiteral ast, Object context) {
        return new NullNode();
    }

    public Object visit(Posit ast, Object context) {
        ExpressionNode node = this.processExpression(ast.getTarget(), context);
        if (node == null) {
            return null;
        }
        if (!TypeChecker.hasNumericType(node)) {
            this.report(1, ast, new Object[]{"+", new TypeSymbol[]{node.type()}});
            return null;
        }
        node = new UnaryExpressionNode(0, node.type(), node);
        return node;
    }

    public Object visit(Negate ast, Object context) {
        ExpressionNode node = this.processExpression(ast.getTarget(), context);
        if (node == null) {
            return null;
        }
        if (!TypeChecker.hasNumericType(node)) {
            this.report(1, ast, new Object[]{"-", new TypeSymbol[]{node.type()}});
            return null;
        }
        node = new UnaryExpressionNode(1, node.type(), node);
        return node;
    }

    public Object visit(Not ast, Object context) {
        ExpressionNode node = this.processExpression(ast.getTarget(), context);
        if (node == null) {
            return null;
        }
        if (node.type() != BasicSymbol.BOOLEAN) {
            this.report(1, ast, new Object[]{"!", new TypeSymbol[]{node.type()}});
            return null;
        }
        node = new UnaryExpressionNode(2, BasicSymbol.BOOLEAN, node);
        return node;
    }

    public Object visit(Assignment ast, Object context) {
        Expression left = ast.getLeft();
        if (left instanceof IDExpression) {
            return this.processLocalAssign(ast, context);
        }
        if (left instanceof SelfFieldReference) {
            return this.processSelfFieldAssign(ast, context);
        }
        if (left instanceof Indexing) {
            return this.processArrayAssign(ast, context);
        }
        if (left instanceof FieldOrMethodRef) {
            return this.processFieldOrMethodAssign(ast, context);
        }
        return null;
    }

    private ExpressionNode processLocalAssign(Assignment ast, Object context) {
        TypeSymbol leftType;
        int index;
        int frame;
        ExpressionNode value = this.processExpression(ast.getRight(), context);
        if (value == null) {
            return null;
        }
        IDExpression id = (IDExpression)ast.getLeft();
        LocalContext local = (LocalContext)context;
        ClosureLocalBinding bind = local.lookup(id.name);
        TypeSymbol rightType = value.type();
        if (bind != null) {
            frame = bind.getFrame();
            index = bind.getIndex();
            leftType = bind.getType();
        } else {
            frame = 0;
            leftType = rightType.isNullType() ? this.state.rootClass() : rightType;
            index = local.addEntry(id.name, leftType);
        }
        value = this.processAssignable(ast.getRight(), leftType, value);
        if (value == null) {
            return null;
        }
        return new LocalAssignmentNode(frame, index, leftType, value);
    }

    private Object processSelfFieldAssign(Assignment ast, Object context) {
        ExpressionNode value = this.processExpression(ast.getRight(), context);
        if (value == null) {
            return null;
        }
        SelfFieldReference ref = (SelfFieldReference)ast.getLeft();
        LocalContext local = (LocalContext)context;
        ClassSymbol selfClass = local.isGlobal() ? this.state.loadTopClass() : (local.getMethod() != null ? local.getMethod().getClassType() : local.getConstructor().getClassType());
        FieldSymbol field = this.findField(selfClass, ref.getName());
        if (field == null) {
            this.report(4, ref, new Object[]{selfClass, ref.getName()});
            return null;
        }
        if (!this.isAccessible(field, selfClass)) {
            this.report(14, ast, new Object[]{field.getClassType(), field.getName(), selfClass});
            return null;
        }
        value = this.processAssignable(ast.getRight(), field.getType(), value);
        if (value == null) {
            return null;
        }
        return new FieldAssignmentNode(new SelfNode(selfClass), field, value);
    }

    Object processArrayAssign(Assignment ast, Object context) {
        ExpressionNode value = this.processExpression(ast.getRight(), context);
        Indexing indexing = (Indexing)ast.getLeft();
        ExpressionNode target = this.processExpression(indexing.getLeft(), context);
        ExpressionNode index = this.processExpression(indexing.getRight(), context);
        if (value == null || target == null || index == null) {
            return null;
        }
        if (target.isBasicType()) {
            this.report(0, indexing.getLeft(), new Object[]{this.state.rootClass(), target.type()});
            return null;
        }
        if (target.isArrayType()) {
            ArraySymbol targetType = (ArraySymbol)target.type();
            if (!index.isBasicType() || !((BasicSymbol)index.type()).isInteger()) {
                this.report(0, indexing.getRight(), new Object[]{BasicSymbol.INT, index.type()});
                return null;
            }
            TypeSymbol base = targetType.getBase();
            value = this.processAssignable(ast.getRight(), base, value);
            if (value == null) {
                return null;
            }
            return new ArrayAssignmentNode(target, index, value);
        }
        ExpressionNode[] params = new ExpressionNode[]{index, value};
        Object[] result = this.tryFindMethod(ast, (ObjectSymbol)target.type(), "set", new ExpressionNode[]{index, value});
        if (result[1] == null) {
            this.report(5, ast, new Object[]{target.type(), "set", this.types(params)});
            return null;
        }
        return new MethodCallNode(target, (MethodSymbol)result[1], params);
    }

    Object processFieldOrMethodAssign(Assignment ast, Object context) {
        ExpressionNode right = this.processExpression(ast.getRight(), context);
        this.report(24, ast, new Object[0]);
        return null;
    }

    public Object visit(AdditionAssignment ast, Object context) {
        ExpressionNode right = this.processExpression(ast.getRight(), context);
        this.report(24, ast, new Object[0]);
        return null;
    }

    public Object visit(SubtractionAssignment ast, Object context) {
        ExpressionNode right = this.processExpression(ast.getRight(), context);
        this.report(24, ast, new Object[0]);
        return null;
    }

    public Object visit(MultiplicationAssignment ast, Object context) {
        ExpressionNode right = this.processExpression(ast.getRight(), context);
        this.report(24, ast, new Object[0]);
        return null;
    }

    public Object visit(DivisionAssignment ast, Object context) {
        ExpressionNode right = this.processExpression(ast.getRight(), context);
        this.report(24, ast, new Object[0]);
        return null;
    }

    public Object visit(ModuloAssignment ast, Object context) {
        ExpressionNode right = this.processExpression(ast.getRight(), context);
        this.report(24, ast, new Object[0]);
        return null;
    }

    public Object visit(IDExpression ast, Object context) {
        LocalContext local = (LocalContext)context;
        ClosureLocalBinding bind = local.lookup(ast.name);
        if (bind == null) {
            this.report(2, ast, new Object[]{ast.name});
            return null;
        }
        return new LocalRefNode(bind);
    }

    private MethodSymbol findMethod(ASTNode ast, ObjectSymbol type, String name) {
        ExpressionNode[] params = new ExpressionNode[0];
        MethodSymbol[] methods = type.findMethod(name, params);
        if (methods.length == 0) {
            this.report(5, ast, new Object[]{type, name, this.types(params)});
            return null;
        }
        return methods[0];
    }

    private MethodSymbol findMethod(ASTNode ast, ObjectSymbol type, String name, ExpressionNode[] params) {
        MethodSymbol[] methods = type.findMethod(name, params);
        return methods[0];
    }

    public Object visit(CurrentInstance ast, Object context) {
        LocalContext local = (LocalContext)context;
        if (local.isStatic()) {
            return null;
        }
        ClassNode selfClass = this.state.getContextClass();
        return new SelfNode(selfClass);
    }

    boolean hasSamePackage(ClassSymbol a, ClassSymbol b) {
        String name1 = a.getName();
        String name2 = b.getName();
        int index = name1.lastIndexOf(".");
        name1 = index >= 0 ? name1.substring(0, index) : "";
        index = name2.lastIndexOf(".");
        name2 = index >= 0 ? name2.substring(0, index) : "";
        return name1.equals(name2);
    }

    boolean isAccessible(ClassSymbol target, ClassSymbol context) {
        if (this.hasSamePackage(target, context)) {
            return true;
        }
        return !Modifier.isInternal(target.getModifier());
    }

    boolean isAccessible(MemberSymbol member, ClassSymbol context) {
        ClassSymbol targetType = member.getClassType();
        if (targetType == context) {
            return true;
        }
        int modifier = member.getModifier();
        if (TypeRules.isSuperType(targetType, context)) {
            return Modifier.isProtected(modifier) || Modifier.isPublic(modifier);
        }
        return Modifier.isPublic(modifier);
    }

    private FieldSymbol findField(ObjectSymbol target, String name) {
        if (target == null) {
            return null;
        }
        FieldSymbol[] fields = target.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().equals(name)) continue;
            return fields[i];
        }
        FieldSymbol field = this.findField(target.getSuperClass(), name);
        if (field != null) {
            return field;
        }
        ClassSymbol[] interfaces = target.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            field = this.findField(interfaces[i], name);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    private boolean checkAccessible(ASTNode ast, ObjectSymbol target, ClassSymbol context) {
        if (target.isArrayType()) {
            TypeSymbol component = ((ArraySymbol)target).getComponent();
            if (!component.isBasicType() && !this.isAccessible((ClassSymbol)component, (ClassSymbol)this.state.getContextClass())) {
                this.report(15, ast, new Object[]{target, context});
                return false;
            }
        } else if (!this.isAccessible((ClassSymbol)target, context)) {
            this.report(15, ast, new Object[]{target, context});
            return false;
        }
        return true;
    }

    public Object visit(FieldOrMethodRef ast, Object context) {
        ClassNode contextClass = this.state.getContextClass();
        ExpressionNode target = this.processExpression(ast.getTarget(), context);
        if (target == null) {
            return null;
        }
        if (target.type().isBasicType() || target.type().isNullType()) {
            this.report(0, ast.getTarget(), new TypeSymbol[]{this.state.rootClass(), target.type()});
            return null;
        }
        ObjectSymbol targetType = (ObjectSymbol)target.type();
        if (!this.checkAccessible(ast, targetType, contextClass)) {
            return null;
        }
        String name = ast.getName();
        if (target.type().isArrayType()) {
            if (name.equals("length") || name.equals("size")) {
                return new ArrayLengthNode(target);
            }
            return null;
        }
        FieldSymbol field = this.findField(targetType, name);
        if (field != null && this.isAccessible(field, (ClassSymbol)this.state.getContextClass())) {
            return new FieldRefNode(target, field);
        }
        Object[] result = this.tryFindMethod(ast, targetType, name, new ExpressionNode[0]);
        if (result[1] != null) {
            return new MethodCallNode(target, (MethodSymbol)result[1], new ExpressionNode[0]);
        }
        boolean continuable = (Boolean)result[0];
        if (!continuable) {
            return null;
        }
        String getterName = this.createGetter(name);
        result = this.tryFindMethod(ast, targetType, getterName, new ExpressionNode[0]);
        if (result[1] != null) {
            return new MethodCallNode(target, (MethodSymbol)result[1], new ExpressionNode[0]);
        }
        continuable = (Boolean)result[0];
        if (!continuable) {
            return null;
        }
        getterName = this.createBooleanGetter(name);
        result = this.tryFindMethod(ast, targetType, getterName, new ExpressionNode[0]);
        if (result[1] != null) {
            return new MethodCallNode(target, (MethodSymbol)result[1], new ExpressionNode[0]);
        }
        if (field == null) {
            this.report(4, ast, new Object[]{targetType, ast.getName()});
        } else {
            this.report(14, ast, new Object[]{targetType, ast.getName(), this.state.getContextClass()});
        }
        return null;
    }

    private Object[] tryFindMethod(ASTNode ast, ObjectSymbol target, String name, ExpressionNode[] params) {
        MethodSymbol[] methods = target.findMethod(name, params);
        if (methods.length > 0) {
            if (methods.length > 1) {
                this.report(6, ast, new Object[]{new Object[]{methods[0].getClassType(), name, methods[0].getArguments()}, new Object[]{methods[1].getClassType(), name, methods[1].getArguments()}});
                return new Object[]{false, null};
            }
            if (!this.isAccessible(methods[0], (ClassSymbol)this.state.getContextClass())) {
                this.report(13, ast, new Object[]{methods[0].getClassType(), name, methods[0].getArguments(), this.state.getContextClass()});
                return new Object[]{false, null};
            }
            return new Object[]{false, methods[0]};
        }
        return new Object[]{true, null};
    }

    private String createGetter(String name) {
        return "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    private String createBooleanGetter(String name) {
        return "is" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    private String createSetter(String name) {
        return "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    public Object visit(ArgumentDeclaration ast, Object context) {
        LocalContext local = (LocalContext)context;
        String name = ast.getName();
        ClosureLocalBinding binding = local.lookupOnlyCurrentScope(name);
        if (binding != null) {
            this.report(7, ast, new Object[]{name});
            return null;
        }
        TypeSymbol type = this.resolve(ast.getType(), this.state.getCurrentResolver());
        if (type == null) {
            return null;
        }
        local.addEntry(name, type);
        return type;
    }

    public Object visit(ArrayCreation ast, Object context) {
        TypeSymbol type = this.resolve(ast.getType(), this.state.getCurrentResolver());
        ExpressionNode[] parameters = this.processExpressions(ast.getArguments(), context);
        if (type == null || parameters == null) {
            return null;
        }
        ArraySymbol resultType = this.state.loadArray(type, parameters.length);
        return new NewArrayNode(resultType, parameters);
    }

    public Object visit(Cast ast, Object context) {
        ExpressionNode node = this.processExpression(ast.getTarget(), context);
        if (node == null) {
            return null;
        }
        TypeSymbol conversion = this.resolve(ast.getConvertType(), this.state.getCurrentResolver());
        if (conversion == null) {
            return null;
        }
        node = new CastNode(node, conversion);
        return node;
    }

    public boolean equals(TypeSymbol[] types1, TypeSymbol[] types2) {
        if (types1.length != types2.length) {
            return false;
        }
        for (int i = 0; i < types1.length; ++i) {
            if (types1[i] == types2[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visit(ClosureExpression ast, Object context) {
        LocalContext local = (LocalContext)context;
        ClassSymbol type = (ClassSymbol)this.state.resolve(ast.getType());
        ArgumentDeclaration[] args = ast.getArguments();
        TypeSymbol[] argTypes = new TypeSymbol[args.length];
        String name = ast.getName();
        try {
            local.openFrame();
            boolean error = false;
            for (int i = 0; i < args.length; ++i) {
                argTypes[i] = (TypeSymbol)this.accept(args[i], context);
                if (argTypes[i] != null) continue;
                error = true;
            }
            if (type == null) {
                Object i = null;
                return i;
            }
            if (!type.isInterface()) {
                this.report(23, ast.getType(), new Object[]{type});
                Object i = null;
                return i;
            }
            if (error) {
                Object i = null;
                return i;
            }
            MethodSymbol[] methods = type.getMethods();
            MethodSymbol method = null;
            for (int i = 0; i < methods.length; ++i) {
                TypeSymbol[] types = methods[i].getArguments();
                if (!name.equals(methods[i].getName()) || !this.equals(argTypes, types)) continue;
                method = methods[i];
                break;
            }
            if (method == null) {
                this.report(5, ast, new Object[]{type, name, argTypes});
                Object i = null;
                return i;
            }
            local.setMethod(method);
            local.getContextFrame().getParent().setAllClosed(true);
            StatementNode block = this.processStatement(ast.getBlock(), context);
            block = this.addReturnNode(block, method.getReturnType());
            ClosureNode node = new ClosureNode(type, method, block);
            node.setFrame(local.getContextFrame());
            ClosureNode closureNode = node;
            return closureNode;
        }
        finally {
            local.closeFrame();
        }
    }

    public Object visit(Indexing ast, Object context) {
        ExpressionNode target = this.processExpression(ast.getLeft(), context);
        ExpressionNode index = this.processExpression(ast.getRight(), context);
        if (target == null || index == null) {
            return null;
        }
        if (target.isArrayType()) {
            if (!index.isBasicType() || !((BasicSymbol)index.type()).isInteger()) {
                this.report(0, ast, new Object[]{BasicSymbol.INT, index.type()});
                return null;
            }
            return new ArrayRefNode(target, index);
        }
        if (target.isBasicType()) {
            this.report(0, ast.getLeft(), new Object[]{this.state.rootClass(), target.type()});
            return null;
        }
        if (target.isArrayType()) {
            if (!index.isBasicType() || !((BasicSymbol)index.type()).isInteger()) {
                this.report(0, ast.getRight(), new Object[]{BasicSymbol.INT, index.type()});
                return null;
            }
            return new ArrayRefNode(target, index);
        }
        ExpressionNode[] params = new ExpressionNode[]{index};
        Object[] result = this.tryFindMethod(ast, (ObjectSymbol)target.type(), "get", new ExpressionNode[]{index});
        if (result[1] == null) {
            this.report(5, ast, new Object[]{target.type(), "get", this.types(params)});
            return null;
        }
        return new MethodCallNode(target, (MethodSymbol)result[1], params);
    }

    public Object visit(SelfFieldReference ast, Object context) {
        LocalContext local = (LocalContext)context;
        ClassNode selfClass = null;
        if (local.isStatic()) {
            return null;
        }
        selfClass = this.state.getContextClass();
        FieldSymbol field = this.findField(selfClass, ast.getName());
        if (field == null) {
            this.report(4, ast, new Object[]{selfClass, ast.getName()});
            return null;
        }
        if (!this.isAccessible(field, (ClassSymbol)selfClass)) {
            this.report(14, ast, new Object[]{field.getClassType(), ast.getName(), selfClass});
            return null;
        }
        return new FieldRefNode(new SelfNode(selfClass), field);
    }

    public Object visit(InstanceCreation ast, Object context) {
        ClassSymbol type = (ClassSymbol)this.state.resolve(ast.getType());
        ExpressionNode[] parameters = this.processExpressions(ast.getArguments(), context);
        if (parameters == null || type == null) {
            return null;
        }
        ConstructorSymbol[] constructors = type.findConstructor(parameters);
        if (constructors.length == 0) {
            this.report(21, ast, new Object[]{type, this.types(parameters)});
            return null;
        }
        if (constructors.length > 1) {
            this.report(22, ast, new Object[]{new Object[]{constructors[0].getClassType(), constructors[0].getArguments()}, new Object[]{constructors[1].getClassType(), constructors[1].getArguments()}});
            return null;
        }
        return new NewNode(constructors[0], parameters);
    }

    public Object visit(IsInstance ast, Object context) {
        ExpressionNode target = this.processExpression(ast.target, context);
        TypeSymbol checkType = this.resolve(ast.type, this.state.getCurrentResolver());
        if (target == null || checkType == null) {
            return null;
        }
        return new IsInstanceNode(target, checkType);
    }

    private TypeSymbol[] types(ExpressionNode[] parameters) {
        TypeSymbol[] types = new TypeSymbol[parameters.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = parameters[i].type();
        }
        return types;
    }

    public Object visit(SelfMethodCall ast, Object context) {
        ExpressionNode[] params = this.processExpressions(ast.getArguments(), context);
        if (params == null) {
            return null;
        }
        ClassNode targetType = this.state.getContextClass();
        String name = ast.getName();
        MethodSymbol[] methods = targetType.findMethod(ast.getName(), params);
        if (methods.length == 0) {
            this.report(5, ast, new Object[]{targetType, name, this.types(params)});
            return null;
        }
        if (methods.length > 1) {
            this.report(6, ast, new Object[]{new Object[]{methods[0].getClassType(), name, methods[0].getArguments()}, new Object[]{methods[1].getClassType(), name, methods[1].getArguments()}});
            return null;
        }
        params = this.convert(methods[0].getArguments(), params);
        if ((methods[0].getModifier() & 0x20) != 0) {
            return new StaticMethodCallNode(targetType, methods[0], params);
        }
        return new MethodCallNode(new SelfNode(targetType), methods[0], params);
    }

    private ExpressionNode[] convert(TypeSymbol[] arguments, ExpressionNode[] params) {
        for (int i = 0; i < params.length; ++i) {
            if (arguments[i] == params[i].type()) continue;
            params[i] = new CastNode(params[i], arguments[i]);
        }
        return params;
    }

    public Object visit(MethodCall ast, Object context) {
        String name;
        ExpressionNode target = this.processExpression(ast.getTarget(), context);
        if (target == null) {
            return null;
        }
        ExpressionNode[] params = this.processExpressions(ast.getArguments(), context);
        if (params == null) {
            return null;
        }
        ObjectSymbol targetType = (ObjectSymbol)target.type();
        MethodSymbol[] methods = targetType.findMethod(name = ast.getName(), params);
        if (methods.length == 0) {
            this.report(5, ast, new Object[]{targetType, name, this.types(params)});
            return null;
        }
        if (methods.length > 1) {
            this.report(6, ast, new Object[]{new Object[]{methods[0].getClassType(), name, methods[0].getArguments()}, new Object[]{methods[1].getClassType(), name, methods[1].getArguments()}});
            return null;
        }
        if ((methods[0].getModifier() & 0x20) != 0) {
            this.report(19, ast, new Object[]{methods[0].getClassType(), name, methods[0].getArguments()});
            return null;
        }
        params = this.convert(methods[0].getArguments(), params);
        return new MethodCallNode(target, methods[0], params);
    }

    public Object visit(StaticIDExpression ast, Object context) {
        ClassSymbol type = (ClassSymbol)this.state.resolve(ast.classType);
        if (type == null) {
            return null;
        }
        FieldSymbol field = this.findField(type, ast.fieldName);
        if (field == null) {
            this.report(4, ast, new Object[]{type, ast.fieldName});
            return null;
        }
        return new StaticFieldRefNode(type, field);
    }

    public Object visit(StaticMethodCall ast, Object context) {
        ClassSymbol type = (ClassSymbol)this.state.resolve(ast.getTarget());
        ExpressionNode[] params = this.processExpressions(ast.getArguments(), context);
        if (params == null) {
            return null;
        }
        MethodSymbol[] methods = type.findMethod(ast.getMethodName(), params);
        if (methods.length == 0) {
            this.report(5, ast, new Object[]{type, ast.getMethodName(), this.types(params)});
            return null;
        }
        if (methods.length > 1) {
            this.report(6, ast, new Object[]{ast.getMethodName(), this.typeNames(methods[0].getArguments()), this.typeNames(methods[1].getArguments())});
            return null;
        }
        params = this.convert(methods[0].getArguments(), params);
        return new StaticMethodCallNode(type, methods[0], params);
    }

    private String[] typeNames(TypeSymbol[] types) {
        String[] names = new String[types.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = types[i].getName();
        }
        return names;
    }

    private String[] parameterTypeNames(ExpressionNode[] parameters) {
        String[] names = new String[parameters.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = parameters[i].type().getName();
        }
        return names;
    }

    private ExpressionNode[] processExpressions(Expression[] ast, Object context) {
        ExpressionNode[] expressions = new ExpressionNode[ast.length];
        boolean success = true;
        for (int i = 0; i < ast.length; ++i) {
            expressions[i] = this.processExpression(ast[i], context);
            if (expressions[i] != null) continue;
            success = false;
        }
        if (success) {
            return expressions;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visit(ForeachStatement ast, Object context) {
        Expression collectionAST = ast.getCollection();
        LocalContext local = (LocalContext)context;
        try {
            local.openScope();
            ExpressionNode collection = this.processExpression(collectionAST, context);
            ArgumentDeclaration arg = ast.getDeclaration();
            this.accept(arg, context);
            ClosureLocalBinding bind = local.lookupOnlyCurrentScope(arg.getName());
            StatementNode block = this.processStatement(ast.getStatement(), context);
            if (collection.isBasicType()) {
                this.report(0, collectionAST, new Object[]{this.state.load("java.util.Collection"), collection.type()});
                Object var9_9 = null;
                return var9_9;
            }
            ClosureLocalBinding bind2 = new ClosureLocalBinding(0, local.addEntry(local.generateName(), collection.type()), collection.type());
            StatementNode init = new ExpressionStatementNode(new LocalAssignmentNode(bind2, collection));
            if (collection.isArrayType()) {
                ClosureLocalBinding bind3 = new ClosureLocalBinding(0, local.addEntry(local.generateName(), BasicSymbol.INT), BasicSymbol.INT);
                init = new BlockNode(new StatementNode[]{init, new ExpressionStatementNode(new LocalAssignmentNode(bind3, new IntegerNode(0)))});
                block = new LoopNode(new BinaryExpressionNode(13, BasicSymbol.BOOLEAN, this.ref(bind3), new ArrayLengthNode(this.ref(bind2))), new BlockNode(new StatementNode[]{this.assign(bind, this.indexref(bind2, this.ref(bind3))), block, this.assign(bind3, new BinaryExpressionNode(0, BasicSymbol.INT, this.ref(bind3), new IntegerNode(1)))}));
                BlockNode blockNode = new BlockNode(new StatementNode[]{init, block});
                return blockNode;
            }
            ClassSymbol iterator = this.state.load("java.util.Iterator");
            ClosureLocalBinding bind3 = new ClosureLocalBinding(0, local.addEntry(local.generateName(), iterator), iterator);
            MethodSymbol getIterator = this.findMethod(collectionAST, (ObjectSymbol)collection.type(), "iterator");
            MethodSymbol getNext = this.findMethod(ast.getCollection(), iterator, "next");
            MethodSymbol hasNext = this.findMethod(ast.getCollection(), iterator, "hasNext");
            init = new BlockNode(new StatementNode[]{init, this.assign(bind3, new MethodCallNode(this.ref(bind2), getIterator, new ExpressionNode[0]))});
            ExpressionNode callGetNext = new MethodCallNode(this.ref(bind3), getNext, new ExpressionNode[0]);
            if (bind.getType() != this.state.rootClass()) {
                callGetNext = new CastNode(callGetNext, bind.getType());
            }
            block = new LoopNode(new MethodCallNode(this.ref(bind3), hasNext, new ExpressionNode[0]), new BlockNode(new StatementNode[]{this.assign(bind, callGetNext), block}));
            BlockNode blockNode = new BlockNode(new StatementNode[]{init, block});
            return blockNode;
        }
        finally {
            local.closeScope();
        }
    }

    private ExpressionNode indexref(ClosureLocalBinding bind, ExpressionNode value) {
        return new ArrayRefNode(new LocalRefNode(bind), value);
    }

    private StatementNode assign(ClosureLocalBinding bind, ExpressionNode value) {
        return new ExpressionStatementNode(new LocalAssignmentNode(bind, value));
    }

    private ExpressionNode ref(ClosureLocalBinding bind) {
        return new LocalRefNode(bind);
    }

    public Object visit(ExpressionStatement ast, Object context) {
        ExpressionNode expression = this.processExpression(ast.expression, context);
        return new ExpressionStatementNode(expression);
    }

    public Object visit(CondStatement ast, Object context) {
        LocalContext local = (LocalContext)context;
        local.openScope();
        IfNode node = this.processCond(ast, 0, context);
        local.closeScope();
        return node;
    }

    IfNode processCond(CondStatement ast, int index, Object context) {
        Expression astCondition = ast.getCondition(index);
        ExpressionNode condition = this.processExpression(astCondition, context);
        if (condition != null && condition.type() != BasicSymbol.BOOLEAN) {
            BasicSymbol expected = BasicSymbol.BOOLEAN;
            TypeSymbol appeared = condition.type();
            this.report(0, astCondition, new Object[]{expected, appeared});
        }
        StatementNode thenBlock = this.processStatement(ast.getBlock(index), context);
        StatementNode elseBlock = index >= ast.size() - 1 ? (ast.getElseBlock() != null ? this.processStatement(ast.getElseBlock(), context) : null) : this.processCond(ast, index + 1, context);
        return new IfNode(condition, thenBlock, elseBlock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visit(ForStatement ast, Object context) {
        LocalContext local = (LocalContext)context;
        try {
            ExpressionNode condition;
            local.openScope();
            StatementNode init = null;
            init = ast.getInitializer() != null ? this.processStatement(ast.getInitializer(), context) : new EmptyNode();
            Expression astCondition = ast.getCondition();
            if (astCondition != null) {
                condition = this.processExpression(ast.getCondition(), context);
                BasicSymbol expected = BasicSymbol.BOOLEAN;
                if (condition != null && condition.type() != expected) {
                    TypeSymbol appeared = condition.type();
                    this.report(0, astCondition, new Object[]{expected, appeared});
                }
            } else {
                condition = new BooleanNode(true);
            }
            ExpressionNode update = null;
            if (ast.getIncrement() != null) {
                update = this.processExpression(ast.getIncrement(), context);
            }
            StatementNode loop = this.processStatement(ast.getBlock(), context);
            if (update != null) {
                loop = new BlockNode(new StatementNode[]{loop, new ExpressionStatementNode(update)});
            }
            StatementNode result = new LoopNode(condition, loop);
            StatementNode statementNode = result = new BlockNode(new StatementNode[]{init, result});
            return statementNode;
        }
        finally {
            local.closeScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visit(BlockStatement ast, Object context) {
        Statement[] astStatements = ast.getStatements();
        StatementNode[] statements = new StatementNode[astStatements.length];
        LocalContext local = (LocalContext)context;
        try {
            local.openScope();
            for (int i = 0; i < astStatements.length; ++i) {
                statements[i] = this.processStatement(astStatements[i], context);
            }
            BlockNode blockNode = new BlockNode(statements);
            return blockNode;
        }
        finally {
            local.closeScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visit(IfStatement ast, Object context) {
        LocalContext local = (LocalContext)context;
        try {
            local.openScope();
            ExpressionNode condition = this.processExpression(ast.condition, context);
            BasicSymbol expected = BasicSymbol.BOOLEAN;
            if (condition != null && condition.type() != expected) {
                TypeSymbol appeared = condition.type();
                this.report(0, ast.condition, new Object[]{expected, appeared});
            }
            StatementNode thenBlock = this.processStatement(ast.thenBlock, context);
            StatementNode elseBlock = null;
            if (ast.elseBlock != null) {
                elseBlock = this.processStatement(ast.elseBlock, context);
            }
            IfNode ifNode = new IfNode(condition, thenBlock, elseBlock);
            return ifNode;
        }
        finally {
            local.closeScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visit(WhileStatement ast, Object context) {
        LocalContext local = (LocalContext)context;
        try {
            local.openScope();
            ExpressionNode condition = this.processExpression(ast.condition, context);
            BasicSymbol expected = BasicSymbol.BOOLEAN;
            if (condition != null && condition.type() != expected) {
                TypeSymbol appeared = condition.type();
                this.report(0, ast, new Object[]{expected, appeared});
            }
            StatementNode thenBlock = this.processStatement(ast.thenBlock, context);
            LoopNode loopNode = new LoopNode(condition, thenBlock);
            return loopNode;
        }
        finally {
            local.closeScope();
        }
    }

    public Object visit(ReturnStatement ast, Object context) {
        TypeSymbol returnType = ((LocalContext)context).getReturnType();
        if (ast.returned == null) {
            BasicSymbol expected = BasicSymbol.VOID;
            if (returnType != expected) {
                this.report(20, ast, new Object[0]);
            }
            return new ReturnNode(null);
        }
        ExpressionNode returned = this.processExpression(ast.returned, context);
        if (returned == null) {
            return new ReturnNode(null);
        }
        if (returned.type() == BasicSymbol.VOID) {
            this.report(20, ast, new Object[0]);
        } else if ((returned = this.processAssignable(ast.returned, returnType, returned)) == null) {
            return new ReturnNode(null);
        }
        return new ReturnNode(returned);
    }

    ExpressionNode processAssignable(ASTNode ast, TypeSymbol a, ExpressionNode b) {
        if (b == null) {
            return null;
        }
        if (a == b.type()) {
            return b;
        }
        if (!TypeRules.isAssignable(a, b.type())) {
            this.report(0, ast, new Object[]{a, b.type()});
            return null;
        }
        b = new CastNode(b, a);
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visit(SelectStatement ast, Object context) {
        LocalContext local = (LocalContext)context;
        try {
            BlockNode block;
            local.openScope();
            ExpressionNode condition = this.processExpression(ast.getCondition(), context);
            if (condition == null) {
                EmptyNode emptyNode = new EmptyNode();
                return emptyNode;
            }
            String name = local.generateName();
            int index = local.addEntry(name, condition.type());
            StatementNode statement = ast.getCases().length == 0 ? (ast.getElseBlock() != null ? this.processStatement(ast.getElseBlock(), context) : new EmptyNode()) : this.processCases(ast, condition, name, (LocalContext)context);
            BlockNode blockNode = block = new BlockNode(new ExpressionStatementNode(new LocalAssignmentNode(0, index, condition.type(), condition)), statement);
            return blockNode;
        }
        finally {
            local.closeScope();
        }
    }

    private StatementNode processCases(SelectStatement ast, ExpressionNode cond, String var, LocalContext context) {
        CaseBranch[] cases = ast.getCases();
        ArrayList<ExpressionNode> nodes = new ArrayList<ExpressionNode>();
        ArrayList<StatementNode> thens = new ArrayList<StatementNode>();
        for (int i = 0; i < cases.length; ++i) {
            Expression[] astExpressions = cases[i].getExpressions();
            ClosureLocalBinding bind = context.lookup(var);
            nodes.add(this.processNodes(astExpressions, cond.type(), bind, context));
            thens.add(this.processStatement(cases[i].getBlock(), context));
        }
        StatementNode statement = ast.getElseBlock() != null ? this.processStatement(ast.getElseBlock(), context) : null;
        for (int i = cases.length - 1; i >= 0; --i) {
            ExpressionNode value = (ExpressionNode)nodes.get(i);
            StatementNode then = (StatementNode)thens.get(i);
            statement = new IfNode(value, then, statement);
        }
        return statement;
    }

    ExpressionNode processNodes(Expression[] asts, TypeSymbol type, ClosureLocalBinding bind, Object context) {
        ExpressionNode[] nodes = new ExpressionNode[asts.length];
        boolean error = false;
        for (int i = 0; i < asts.length; ++i) {
            nodes[i] = this.processExpression(asts[i], context);
            if (nodes[i] == null) {
                error = true;
                continue;
            }
            if (!TypeRules.isAssignable(type, nodes[i].type())) {
                this.report(0, asts[i], new TypeSymbol[]{type, nodes[i].type()});
                error = true;
                continue;
            }
            if (nodes[i].isBasicType() && nodes[i].type() != type) {
                nodes[i] = new CastNode(nodes[i], type);
            }
            if (!nodes[i].isReferenceType() || nodes[i].type() == this.state.rootClass()) continue;
            nodes[i] = new CastNode(nodes[i], this.state.rootClass());
        }
        if (!error) {
            BinaryExpressionNode node = new BinaryExpressionNode(17, BasicSymbol.BOOLEAN, new LocalRefNode(bind), nodes[0]);
            for (int i = 1; i < nodes.length; ++i) {
                node = new BinaryExpressionNode(6, BasicSymbol.BOOLEAN, node, new BinaryExpressionNode(17, BasicSymbol.BOOLEAN, new LocalRefNode(bind), nodes[i]));
            }
            return node;
        }
        return null;
    }

    public Object visit(ThrowStatement ast, Object context) {
        TypeSymbol detected;
        ClassSymbol expected;
        ExpressionNode expression = this.processExpression(ast.expression, context);
        if (expression != null && !TypeRules.isSuperType(expected = this.state.load("java.lang.Throwable"), detected = expression.type())) {
            this.report(0, ast.expression, new Object[]{expected, detected});
        }
        return new ThrowNode(expression);
    }

    public Object visit(LocalVariableDeclaration ast, Object context) {
        LocalAssignmentNode node;
        Expression initializer = ast.getInitializer();
        LocalContext localContext = (LocalContext)context;
        ClosureLocalBinding binding = localContext.lookupOnlyCurrentScope(ast.getName());
        if (binding != null) {
            this.report(7, ast, new Object[]{ast.getName()});
            return new EmptyNode();
        }
        TypeSymbol leftType = this.state.resolve(ast.getType());
        if (leftType == null) {
            return new EmptyNode();
        }
        int index = localContext.addEntry(ast.getName(), leftType);
        if (initializer != null) {
            ExpressionNode valueNode = this.processExpression(initializer, context);
            if (valueNode == null) {
                return new EmptyNode();
            }
            if ((valueNode = this.processAssignable(initializer, leftType, valueNode)) == null) {
                return new EmptyNode();
            }
            node = new LocalAssignmentNode(0, index, leftType, valueNode);
        } else {
            node = new LocalAssignmentNode(0, index, leftType, TypeChecker.defaultValue(leftType));
        }
        return new ExpressionStatementNode(node);
    }

    public static ExpressionNode defaultValue(TypeSymbol type) {
        return ExpressionNode.defaultValue(type);
    }

    public Object visit(EmptyStatement ast, Object context) {
        return new EmptyNode();
    }

    public Object visit(TryStatement ast, Object context) {
        LocalContext local = (LocalContext)context;
        StatementNode tryStatement = this.processStatement(ast.tryBlock, context);
        ClosureLocalBinding[] binds = new ClosureLocalBinding[ast.arguments.length];
        StatementNode[] catchBlocks = new StatementNode[ast.arguments.length];
        for (int i = 0; i < ast.arguments.length; ++i) {
            local.openScope();
            TypeSymbol arg = (TypeSymbol)this.accept(ast.arguments[i], context);
            ClassSymbol expected = this.state.load("java.lang.Throwable");
            if (!TypeRules.isSuperType(expected, arg)) {
                this.report(0, ast.arguments[i], new Object[]{expected, arg});
            }
            binds[i] = local.lookupOnlyCurrentScope(ast.arguments[i].getName());
            catchBlocks[i] = this.processStatement(ast.recBlocks[i], context);
            local.closeScope();
        }
        return new TryNode(tryStatement, binds, catchBlocks);
    }

    public Object visit(SynchronizedStatement ast, Object context) {
        ExpressionNode lock = this.processExpression(ast.target, context);
        StatementNode block = this.processStatement(ast.block, context);
        this.report(24, ast, new Object[0]);
        return new SynchronizedNode(lock, block);
    }

    public Object visit(BreakStatement ast, Object context) {
        this.report(24, ast, new Object[0]);
        return new BreakNode();
    }

    public Object visit(ContinueStatement ast, Object context) {
        this.report(24, ast, new Object[0]);
        return new ContinueNode();
    }

    public Object visit(FunctionDeclaration ast, Object context) {
        MethodNode function = (MethodNode)this.state.lookupKernelNode(ast);
        if (function == null) {
            return null;
        }
        LocalContext local = new LocalContext();
        if (Modifier.isStatic(function.getModifier())) {
            local.setStatic(true);
        }
        local.setMethod(function);
        TypeSymbol[] arguments = function.getArguments();
        for (int i = 0; i < arguments.length; ++i) {
            local.addEntry(ast.getArguments()[i].getName(), arguments[i]);
        }
        BlockNode block = (BlockNode)this.accept(ast.getBlock(), local);
        block = this.addReturnNode(block, function.getReturnType());
        function.setBlock(block);
        function.setFrame(local.getContextFrame());
        return null;
    }

    public BlockNode addReturnNode(StatementNode node, TypeSymbol returnType) {
        return new BlockNode(node, new ReturnNode(TypeChecker.defaultValue(returnType)));
    }

    public Object visit(GlobalVariableDeclaration ast, Object context) {
        return null;
    }

    public Object visit(FieldDeclaration ast, Object context) {
        return null;
    }

    public Object visit(DelegationDeclaration ast, Object context) {
        return null;
    }

    public Object visit(InterfaceMethodDeclaration ast, Object context) {
        return null;
    }

    public Object visit(MethodDeclaration ast, Object context) {
        MethodNode method = (MethodNode)this.state.lookupKernelNode(ast);
        if (method == null) {
            return null;
        }
        LocalContext local = new LocalContext();
        if (Modifier.isStatic(method.getModifier())) {
            local.setStatic(true);
        }
        local.setMethod(method);
        TypeSymbol[] arguments = method.getArguments();
        for (int i = 0; i < arguments.length; ++i) {
            local.addEntry(ast.getArguments()[i].getName(), arguments[i]);
        }
        BlockNode block = (BlockNode)this.accept(ast.getBlock(), local);
        block = this.addReturnNode(block, method.getReturnType());
        method.setBlock(block);
        method.setFrame(local.getContextFrame());
        return null;
    }

    public Object visit(ConstructorDeclaration ast, Object context) {
        ConstructorNode constructor = (ConstructorNode)this.state.lookupKernelNode(ast);
        if (constructor == null) {
            return null;
        }
        LocalContext local = new LocalContext();
        local.setConstructor(constructor);
        TypeSymbol[] arguments = constructor.getArguments();
        for (int i = 0; i < arguments.length; ++i) {
            local.addEntry(ast.getArguments()[i].getName(), arguments[i]);
        }
        ExpressionNode[] params = this.processExpressions(ast.getInitializers(), context);
        BlockNode block = (BlockNode)this.accept(ast.getBlock(), local);
        ClassNode currentClass = this.state.getContextClass();
        ClassSymbol superClass = currentClass.getSuperClass();
        ConstructorSymbol[] matched = superClass.findConstructor(params);
        if (matched.length == 0) {
            this.report(21, ast, new Object[]{superClass, this.types(params)});
            return null;
        }
        if (matched.length > 1) {
            this.report(22, ast, new Object[]{new Object[]{superClass, this.types(params)}, new Object[]{superClass, this.types(params)}});
            return null;
        }
        SuperInitNode init = new SuperInitNode(superClass, matched[0].getArguments(), params);
        constructor.setSuperInitializer(init);
        block = this.addReturnNode(block, BasicSymbol.VOID);
        constructor.setBlock(block);
        constructor.setFrame(local.getContextFrame());
        return null;
    }

    public TypeSymbol resolve(TypeSpecifier type, NameResolution resolver) {
        TypeSymbol resolvedType = resolver.resolve(type);
        if (resolvedType == null) {
            this.report(3, type, new Object[]{type.getComponentName()});
        }
        return resolvedType;
    }

    public void report(int error, ASTNode node, Object[] items) {
        this.state.report(error, node, items);
    }

    public static TypeSymbol promoteNumericTypes(TypeSymbol left, TypeSymbol right) {
        if (!TypeChecker.numeric(left) || !TypeChecker.numeric(right)) {
            return null;
        }
        if (left == BasicSymbol.DOUBLE || right == BasicSymbol.DOUBLE) {
            return BasicSymbol.DOUBLE;
        }
        if (left == BasicSymbol.FLOAT || right == BasicSymbol.FLOAT) {
            return BasicSymbol.FLOAT;
        }
        if (left == BasicSymbol.LONG || right == BasicSymbol.LONG) {
            return BasicSymbol.LONG;
        }
        return BasicSymbol.INT;
    }

    public static boolean hasNumericType(ExpressionNode expression) {
        return TypeChecker.numeric(expression.type());
    }

    private static boolean numeric(TypeSymbol symbol) {
        return symbol.isBasicType() && (symbol == BasicSymbol.BYTE || symbol == BasicSymbol.SHORT || symbol == BasicSymbol.CHAR || symbol == BasicSymbol.INT || symbol == BasicSymbol.LONG || symbol == BasicSymbol.FLOAT || symbol == BasicSymbol.DOUBLE);
    }

    ExpressionNode processExpression(Expression expression, Object context) {
        return (ExpressionNode)expression.accept(this, context);
    }

    StatementNode processStatement(Statement statement, Object context) {
        return (StatementNode)statement.accept(this, context);
    }
}

