module PjcApplyingFrameworkToTaskHelper
    # 新規作成画面へのボタンを返す。
  def td_button_new
    if @display.button_new? && @product.modifiable?
      b = link_to_view_motion(h(s_("button|New")),
                              @sub_view, "create",
                              {"_" => "&suffix;"},
                              {:action => "new"},
                              :class => "button reloadable_link")
    else
      b = "&nbsp;"
    end
    content_tag(:td, b, :class => "button_new")
  end

  # (指定されていれば)CSV出力画面へのリンクを返す。
  def td_to_csv
    return "" unless @display.csv?
    link = link_to_view_motion(h(s_("link_to|CSV")),
                               "view_output",
                               "output",
                               {:controller => "output", :action => "edit", :id => @display.id},
                               {:controller => "output", :action => "edit", :id => @display.id},
                               {:id => "output", :class => "button"})
    content_tag(:td, link, :class => "right")
  end

  # 権限で許可されていないカラムの部品を返す。
  def not_permitted_column
      filtered_message = s_("not_permitted_column|[FILTERED]")
      return "<td class=\"not_permitted_column\">#{filtered_message}</td>"
  end

  # 詳細画面および編集画面で詳細情報を表示するための table を返す。
  def with_table(&block)
    row_nums = @items.map(&:coordinate_number).compact.max
    content = []
    return "" unless row_nums
    (1..row_nums).each do |i|
      pair = [
        @items.find {|item| item.coordinates == "A#{i}"},
        @items.find {|item| item.coordinates == "B#{i}"},
      ]
      row = pair.map do |item|
        if item.is_a?(Item)
          yield item
        else
          content_tag(:th, "", :class => "blank") + content_tag(:td, "", :class => "blank")
        end
      end.join
      content.push(content_tag(:tr, row))
    end
    return content_tag(:table, content.join, :class => "detail hoverable")
  end

  # 項目の一覧を含む table を返す。
  def items_to_table
    with_table {|item| content_tag(:th, h(item.human_name)) + item_to_td(item, @it)}
  end

  # 項目の一覧に対応する input の table を返す。
  def items_to_table_input
    table = with_table do |item|
      options = {}
      options[:class] = "required" if item.required?
      label = content_tag(:label, h(item.human_name), :for => "it_#{item.column_name}")
      content_tag(:th, label, options) + item_to_td_input(item, :it)
    end
    table + hidden_field(:it, "lock_version")
  end

  # 項目 <em>i</em> からヘッダを返す。
  def item_to_th(i)
    content_tag(:th, h(i.human_name), {:style => i.style})
  end

  # 項目から td を返す。
  def item_to_td(i, it,idx)
    return not_permitted_column unless i.readable?
    begin
      data = i.to_data(it)  
    rescue NoMethodError
      logger.error("ERROR: not found column: #{@model_class}\##{i.column_name}")
      return "<td class=\"formError\">#{s_("formError|column not found")}</td>"
    end

    # input_type is not available in display_to_show and display_to_list
=begin
    case i.input_type
    when "text"
    when "textarea"
    when "radio", "select"
      data = data.to_s
      i.input_parameter.split(/,/).map do |pair|
        value, text = pair.split(/:/, 2)
        if value == data
          data = text
          break
        end
      end
    when "checkbox"
      data = i.input_parameter.to_s if data
    else
      logger.warn("WARN: invalid input type: #{i.input_type} (#{@model_class}\##{i.column_name})")
    end
=end

    case i.decorator
    when "front"
      content = h("#{i.decorator_parameter}#{data}")
    when "back"
      content = h("#{data}#{i.decorator_parameter}")
    when "currency"
      content = number_to_currency(data, :unit => "&yen;", :precision => 0)
    when "size" # for test
      content = h(number_to_human_size(data))
    when "nl2br"
      content = h(data).gsub(/\r?\n/) { "<br />" }
    else
      content = h(data)
    end

    if url = i.link_url(it)
      content = link_to(content, url)
    end

    options = {
      :align => i.align,
      :class => "item",
    }
    options[:style] = i.style
    content = content_tag(:div, content)
    content += hidden_field("applying_schedule_#{idx}",i.column_name)
    return content_tag(:td, content, options)
  end

  # 項目から td にラップされた input を返す。
  def item_to_td_input(i, object_name)
    it = instance_variable_get("@#{object_name}")
    return item_to_td(i, it) if i.is_a?(ItemPseudo)
    begin
      data = it.__send__(i.column_name)
    rescue NoMethodError
      logger.error("ERROR: column not found: #{@model_class}\##{i.column_name}")
      return "<td class=\"formError\">#{s_("formError|column not found")}</td>"
    end

    field_options = {}
    field_options[:readonly] = "readonly" unless i.writable?
    text_options = {
      :size  => i.size_for_input_field,
      :style => i.style_for_input_field,
    }
    text_options.update(field_options)
    case i.input_type
    when "picker"
      e = picker_tags(i, object_name, it)
    when "text"
      e = text_field object_name, i.column_name, text_options
    when "textarea"
      e = text_area object_name, i.column_name, text_options
    when "radio"
      choices = i.split_into_input_options do |name, value|
        radio_button_with_label(object_name, i.column_name, value, h(name), field_options)
      end
      unless i.required?
        choices.unshift(radio_button_with_label(object_name, i.column_name, "", h(s_("InputOption|(blank)")), field_options))
      end
      e = choices.join
    when "checkbox"
      e = check_box(object_name, i.column_name, field_options) + i.input_parameter.to_s
    when "select"
      choices = i.split_into_input_options do |name, value|
        [h(name), value]
      end
      unless i.required?
        choices.unshift([h(s_("InputOption|(blank)")), ""])
      end
      e = select(object_name, i.column_name, choices, field_options)
    else
      logger.error("ERROR: invalid input type: #{i.input_type} (#{@model_class}\##{i.column_name})")
      return "<td class=\"formError\">#{s_("formError|invalid input type")}</td>"
    end

    return content_tag(:td, e, {:class => "input_item", :style => i.style})
  end

  #
  def detail_to_tr(d, script=nil, options={}, &block)
    tds = @detail_items.map {|i| yield(i, d)}
    tds.unshift(content_tag(:td, "&nbsp;", :class => "handle"))
    if script
      link = link_to_function(h(s_("button|Destroy")), script, :class => "button")
      tds.push(content_tag(:td, link))
    end
    options.update({:class => cycle("even", "odd", :name => "details_to_table")})
    content_tag(:tr, tds, options)
  end

  #
  def with_details(tail=nil, &block)
    ths = @detail_items.map {|i| item_to_th(i)}
    ths.unshift(content_tag(:th, "&nbsp;"))
    ths.push(content_tag(:th, "&nbsp")) if tail
    head = content_tag(:thead, content_tag(:tr, ths))
    foot = content_tag(:tfoot, "")
    body = content_tag(:tbody, yield, {:id => "details_table_body"})
    table = content_tag(:table, [head, foot, body],{:id => "details_table", :class => "detail hoverable"})
    return table + (tail || "")
  end

  # 
  def details_to_table
    return "" unless @product.is_a?(ProductMultiple) || @product.is_a?(ProductDetailed)
    with_details do
      @details.map {|d| detail_to_tr(d) {|i,d| item_to_td(i,d)}}
    end
  end

  #
  def details_to_table_input
    return "" unless @product.is_a?(ProductMultiple) || @product.is_a?(ProductDetailed)
    tail = sortable_details
    tail += hidden_field_tag("new_details", @new_details.to_json)
    tail += hidden_field_tag("old_details", @old_details.to_json)
    tail += hidden_field_tag("order_details", @details.map {|detail| "details_#{detail.id}"}.to_json)
    d = @product.detail_class.new
    @detail_items.each do |i|
      i.initialize_column_of(d)
    end
    temp = "new_details_#{rand(65536)}#{Time.now.to_i}"
    instance_variable_set("@#{temp}", d)
    tr = detail_to_tr(d, "remove_new_details(this,\#{n});", :id => temp) {|i,d| item_to_td_input(i, temp)}
    tr = tr.gsub(temp, "new_details_\#{n}")
    link = link_to_remote(h(s_("button|New")), {
                            :before => "add_new_details('#{escape_javascript(tr)}');",
                            :update => "space_details",
                            :url => {:action => "add_detail"},
                          }, {
                            :class => "button",
                          })
    tail += content_tag(:div, link, :class => "right")
    tail += content_tag(:div, "", :id => "space_details")
    with_details(tail) do
      rows = []
      @details.each do |d|
        unless @old_details.include?(d.id)
          html_id = "details_#{d.id}"
          rows << detail_to_tr(d, "remove_old_details(this,#{d.id});", :id => html_id) {|i,d| item_to_td_input(i, html_id)}
        end
      end
      rows += @new_details.map do |n|
        d = instance_variable_get("@new_details_#{n}")
        html_id = "new_details_#{n}"
        detail_to_tr(d, "remove_new_details(this,#{n});", :id => html_id) {|i,d| item_to_td_input(i, html_id)}
      end
      rows
    end
  end

  def sortable_details
    sortable_element("details_table_body",
                     :format => "/^(details_[0-9]+|new_details_[0-9]+)$/",
                     :complete => visual_effect(:highlight, "details_table"),
                     :url => {:action => "order_details"},
                     :constraint => false,
                     :ghosting => true,
                     :handle => "handle",
                     :tag => "tr")    
  end

  # カレンダー選択部品による入力部品を返す。
  def calendar_picker_tags(i, object_name, it)
    picker_field = i.picker_field(it, object_name)
    rfw_picker([{
                  :type => "text",
                  :name => rfw_name_for(object_name, i.column_name),
                  :value => i.to_data(it),
                  :key => "return_value",
                  :html => { :size => i.size_for_input_field }
                }],
               {
                 :controller => 'pick/calendar',
                 :action => "search",
                 :return_format => i.calendar_format,
                 :alert_holiday => i.calendar_alert_holiday?,
                 :escape => false,
               },
               s_('rfw|submit_tag|Pick Date'))
  end

  # 選択部品による入力部品を返す。
  def picker_tags(i, object_name, it)
    return rfw_calendar_tags(i, object_name, it) if i.calendar?
    case i
    when ItemProper
      options = i.rfw_picker_options(it, object_name)
      id = rfw_value_for(object_name, i.column_name)
      if id.blank?
        id = initialize_id_with_narrowing(i)
      end
      unless id.blank?
        found = i.picked_atom.classify.constantize.find_by_id(id)
        name = rfw_picked_name(found) if found
      end
      rfw_picker([{
                    :type => 'text',
                    :name => "#{rfw_name_for(object_name, i.column_name)}_name",
                    :value => name,
                    :key => options[:return_field_name],
                    :html => { :readonly => true, :size => i.size_for_input_field }
                  },
                  {
                    :type => 'hidden',
                    :name => rfw_name_for(object_name, i.column_name),
                    :value => id,
                    :key => options[:return_field_id]
                  },
                  '<br />',
                 ],
                 { :controller => options[:controller], :action => 'search' },
                 s_(options[:submit_text])) do |x_id|
        # * プロジェクト
        # * 業務
        # * 案件
        # に関する選択部品の場合には選択が完了した時点で変化があれば一度サーバに送信して編集画面を再描画する。
        if i.input_parameter =~ /\A(?:matter|project)/
          "function() {new Form.Element.Observer($('#{x_id}').previous('input'), 0.3, function(element, value) {element.form.onsubmit();});}"
        elsif i.picking_record?
          # rfw[record_model_name] を動的に指定する。
          "Rfw.embedHiddenParameters.bindAsEventListener($('#{x_id}'), {record_model_name: '#{i.picked_atom.classify}'})"
        else
          ''
        end
      end
    when ItemPolymorphic
      picker_field = i.picker_field(it, object_name)
      id = rfw_value_for(object_name, "#{i.column_name}_id")
      model_class = rfw_value_for(object_name, "#{i.column_name}_type")
      value = nil
      unless id.blank? || model_class.blank?
        found = model_class.constantize.find_by_id(id)
        value = rfw_picked_name(found) if found
      end
      rfw_picker([{
                    :type => 'text',
                    :name => "picker_#{picker_field}",
                    :value => value,
                    :key => 'model_value',
                    :html => { :readonly => true, :size => i.size_for_input_field }
                  },
                  {
                    :type => 'hidden',
                    :name => rfw_name_for(object_name, "#{i.column_name}_type"),
                    :value => model_class,
                    :key => 'model_name'
                  },
                  {
                    :type => 'hidden',
                    :name => rfw_name_for(object_name, "#{i.column_name}_id"),
                    :value => id,
                    :key => 'model_id'
                  },
                  '<br />',
                 ],
                 { :controller => 'pick/lump', :action => 'search', :mode => 'company' },
                 s_('rfw|submit_tag|Pick'))
    when ItemPlural
      picker_field = i.picker_field(it, object_name)
      ids = rfw_value_for(object_name, i.column_name)
      values = Person.joints(ids).map(&:name)
      rfw_picker([{
                    :type => 'text',
                    :name => "picker_#{picker_field}",
                    :value => values.join(','),
                    :key => 'people_names',
                    :html => { :readonly => true, :size => i.size_for_input_field  } },
                  {
                    :type => 'hidden',
                    :name => rfw_name_for(object_name, i.column_name),
                    :value => ids,
                    :key => 'people_ids'
                  },
                  '<br />',
                 ],
                 { :controller => 'pick/lump_people', :action => 'search', :mode => 'company' },
                 s_('rfw|submit_tag|Pick'))
    else
      raise ArgumentError, "invalid item type: #{i.class}"
    end
  end

  # メール送信部品による選択の情報を返す。
  def mailto_info
    mail = params[:mail] || {}
    if mail[:recipients]
      if mail[:recipients].is_a?(String)
        mail[:recipients] = mail[:recipients].split(/,/).map(&:to_i)
      end
      recipients = Person.find(mail[:recipients])
      info = select_tag "_mail_info", options_from_collection_for_select(recipients, "id", "name_with_in", 0)
      mail[:recipients] = mail[:recipients].join(",")
    else
      recipients = []
      info = ""
    end
    num = text_field_tag "_mail_num", recipients.size, :readonly => true, :size => 2, :class => "mail_num", :id => nil
    info << ns_("mailto_info|%{num} person", "%{num} people", recipients.size) % { :num => num }
    mail.keys.each do |key|
      info << hidden_field_tag("mail[#{key}]", mail[key], :id => nil)
    end
    return info
  end

  # 詳細画面へのリンクを返す。
  def display_aspect(controller, view)
    url = {:controller => controller, :action => "show", :id => @it.id, :type => @model_class, :product_id => @product.id}
    if request.xhr?
      javascript_tag(remote_function(:update => view, :url => url))
    else
      link = link_to_view_motion(s_(controller), view, "show", {}, url, :class => "autoload button")
      content_tag(:div, link, :class => "left_buttons")
    end
  end

  # サマリへのリンクを返す。
  def summary_aspect(controller)
    url = {:controller => controller, :action => "summary", :id => @it.id, :type => @model_class, :product_id => @product.id}
    javascript_tag(remote_function(:update => "summary_#{controller.pluralize}", :url => url))
  end

  # 関連文書を選択するためのリンクを返す。
  def link_to_select_document(it)
    return "" if @relatable && (it == @relatable || @product.document_nodes_for(@relatable).include?(it))
    link_to_remote(tree_icon_open,
                   :update => "document_table_base",
                   :complete => visual_effect(:highlight, "document_table", :queue => {:scope => "document", :limit => 2, :position => "end"}),
                   :url => {:controller => "document", :action => "select", :id => params[:id], :type => params[:type], :product_id => params[:relatable_product_id], :target_id => it.id, :target_type => it.class.to_s, :target_product_id => @product.id})
  end

  # 一覧検索(汎用検索)の設定画面へのリンクを返す。
  def link_to_search
    return "" unless @product.search?
    link_to_remote(h(s_("Search")),
                   { :update => "view_search",
                     :url => {:controller => "search", :action => "index"},
                     :with => "'display_id=' + $F('list')",
                   },
                   {:class => "button"})
  end

  # 一覧の設定画面へのリンクを返す。
  def link_to_list
    link_to_view_motion(h(s_("List")), "view_list", @product.id,
                        {},
                        {:controller => "list", :action => "index", :id => @product.id},
                        {:class => "button reloadable_link"})
  end

  # 画面上下に配置されるボタン群を返す。
  def button_box(suffix)
    buttons = {}
    if params[:id] && @display.button_back?
      buttons[:left] = link_to_view_motion(h(s_("button|Back")),
                                           @current_view, "show",
                                           {:id => params[:id], "_" => suffix},
                                           {:action => "show", :id => params[:id]},
                                           :class => "button reloadable_link")
    elsif @display.button_close?
      buttons[:left] = link_to_close({:id => nil, "_" => suffix}, {:action => "list", :id => nil}, :class => "button")
    end
    buttons[:center] = ""
    if @display.button_edit? && @product.modifiable?
      buttons[:center] += link_to_view_motion(h(s_("button|Edit")),
                                              @current_view, "edit",
                                              {:id => @it.id, "_" => suffix},
                                              {:action => "edit", :id => @it },
                                              :class => "button reloadable_link")
    end
    if @display.button_copy? && @product.modifiable?
      buttons[:center] += link_to_view_motion(h(s_("button|Copy")),
                                              @current_view, "copy",
                                              {:id => @it.id, "_" => suffix},
                                              {:action => "new", :id => @it },
                                              :class => "button reloadable_link")
    end
    if @submit_tag
      buttons[:center] += @submit_tag
    end
    if @display.button_delete? && @product.modifiable?
      buttons[:right] = link_to_view_motion(h(s_("button|Destroy")),
                                            @current_view, "destroy",
                                            {:id => @it.id, "_" => suffix},
                                            {:action => "destroy", :id => @it },
                                            :confirm => s_('confirm|Are you sure?'),
                                            :method => :post,
                                            :class => "button reloadable_link")
    end
    return lcr_button_box(buttons)
  end


#EIS T.Takada add methods  
  def candidate_frameworks_seach_button(ctr_n)
    link_to_remote(h(s_("#{ctr_n}|search")),
                     {
                      :submit => "framework_conditions",
                      :update => "candidate_frameworks_list",   
                      :url => { :controller => "pjc_applying_framework_to_task", :action => "candidate_frameworks_list"}
                     },
                     {
                      :class => "button",
                     })
    
  end
  
  def candidate_frameworks_select_button(it)
    script = "document.getElementsByName('selected_framework[id]')[0].value = '#{it.id}';"
    script += "document.getElementsByName('selected_framework[name]')[0].value = '#{it.name}';"
    script += "document.getElementsByName('selected_project_segment[projcet_id]')[0].value = '';"
    script += "document.getElementsByName('selected_project_segment[projcet_name]')[0].value = '';"
    script += "document.getElementsByName('selected_project_segment[segment_id]')[0].value = '';"
    script += "document.getElementsByName('selected_project_segment[segment_name]')[0].value = '';"
    content_tag(:a , "◆", :href => "#" ,:onclick=> script,:style=>"text-decoration:none;")
  end
  
  def applying_logging_onclick
    script = "if( this.checked ){ document.getElementsByName('selected_framework[logging_result]')[0].value = '1' }"
    script += " else { document.getElementsByName('selected_framework[logging_result]')[0].value = '0' }"
  end
  
  def recycling_schedule_plan_onclick
    script =  " if(document.getElementById('recycling_schedule_plan').checked == true ) { "
    script += " document.getElementsByName('selected_project_segment[recycling_schedule]')[0].value = 'plan' ; "
    script += " } else { "
    script += " document.getElementsByName('selected_project_segment[recycling_schedule]')[0].value = 'result' ; "
    script += " } "
  end
  
  def recycling_schedule_result_onclick
    script =  " if(document.getElementById('recycling_schedule_result').checked == true ) { "
    script += " document.getElementsByName('selected_project_segment[recycling_schedule]')[0].value = 'result' ; "
    script += " } else { "
    script += " document.getElementsByName('selected_project_segment[recycling_schedule]')[0].value = 'plan' ; "
    script += " } "
  end 
  
  def work_user_onclick
    
    script = "if( document.getElementById('is_work_user').checked == true ){ "
    script += "document.getElementsByName('selected_project_segment[work_user_result]')[0].value = '1' }"
    script += " else { document.getElementsByName('selected_project_segment[work_user_result]')[0].value = '0' }"
  end 
  
  def applying_logging_checked(value)
    if value == "1"
      return true
    else
      return false
    end
  end
 
  def recycling_schedule_checked(value)
    if value == "plan"
      return "checked"
    else
      return ""
    end   
  end
   
  def work_user_checked(value)
    if value == "1"
      return true
    else
      return false
    end
  end
  def candidate_segments_seach_button(ctr_n)
    link_to_remote(h(s_("#{ctr_n}|search")),
                     {
                      :submit => "segment_conditions",
                      :update => "candidate_segments_list",   
                      :url => { :controller => "pjc_applying_framework_to_task", :action => "candidate_segments_list"}
                     },
                     {
                      :class => "button",
                     })
    
  end
 

  def candidate_segments_select_button(it)
    script = "document.getElementsByName('selected_framework[id]')[0].value = '';"
    script += "document.getElementsByName('selected_framework[name]')[0].value = '';"
    script += "document.getElementsByName('selected_project_segment[projcet_id]')[0].value = '#{it.project_id}';"
    script += "document.getElementsByName('selected_project_segment[projcet_name]')[0].value = '#{it.project_name}';"
    script += "document.getElementsByName('selected_project_segment[segment_id]')[0].value = '#{it.segment_id}';"
    script += "document.getElementsByName('selected_project_segment[segment_name]')[0].value = '#{it.segment_name}';"
    content_tag(:a , "◆", :href => "#" ,:onclick=> script ,:style=>"text-decoration:none;")
  end
  
  def applying_schedule_list_td(it,dt,idx)
    grp_name = "applying_schedule_#{idx}"
    case it.column_name
    when "code"
      item_to_td(it,dt,idx)
    when "name"
      hierarchy = ""
#      (dt.task_level - 1).times{|i|hierarchy += "&nbsp;&nbsp;&nbsp;&nbsp;"}
      (dt.task_level+1).times{|i|hierarchy += "&nbsp;&nbsp;&nbsp;&nbsp;"}
      content = content_tag(:div, hierarchy + h(dt.name))
      content += hidden_field(grp_name,"id")
      content += hidden_field(grp_name,"default_id")
      content += hidden_field(grp_name,"default_parent_id")
      content += hidden_field(grp_name,"lft_id")
      content += hidden_field(grp_name,"rgt_id")
      content += hidden_field(grp_name,"default_tree")
      content += hidden_field(grp_name,"parent_id")
      content += hidden_field(grp_name,"task_level")
      content += hidden_field(grp_name,"task_weight")
      content += hidden_field(grp_name,it.column_name)
      content += hidden_field(grp_name,"lock_version")
      content_tag(:td, content)
    when "planned_start_date"
      if dt.default_tree && dt.default_tree != "" && dt.task_weight.to_i > 0
        item_to_td_input(it,grp_name)
      else
        item_to_td(it,dt,idx)
      end
    when "planned_finish_date"
      if dt.default_tree && dt.default_tree != "" && dt.task_weight.to_i > 0
        item_to_td_input(it,grp_name)
      else
        item_to_td(it,dt,idx)
      end
    when "person_in_charge_of_work_id"
      if dt.default_tree && dt.default_tree != "" && dt.task_weight.to_i > 0
        item_to_td_input(it,grp_name)
      else
        item_to_td(it,dt,idx)
      end
    else
      item_to_td(it,dt,idx)
    end
  end  
  
  def check_selected_script(message1,message2)
    script = "if(document.getElementsByName('selected_framework[id]')[0].value == '' "
    script += "&& document.getElementsByName('selected_project_segment[segment_id]')[0].value == '')"
    script += "{alert('#{message1}'); return false; } else {if(confirm('#{message2}')==false){return false;}}"
  end
  
  def selected_object_add_child(it ,idx,ctr_n)
    unless it
      link_to_remote("◆",
                       {
                        :before => check_selected_script(s_("#{ctr_n}|select framework or segments"),s_("#{ctr_n}|May I really add it under root ?")),
                        :submit => "applying_schedule_list",
                        :update => "applying_schedule_list",   
                        :url => { :controller => "pjc_applying_framework_to_task", :action => "selected_object_add_child", :row_no => idx ,:root => "1"}
                       },
                       {
                        :style=>"text-decoration:none;"
                       })      
    else
      if it.task_weight.to_i > 0 && it.person_in_charge_of_work_id.to_i == 0
        link_to_remote("◆",
                         {
                          :before => check_selected_script(s_("#{ctr_n}|select framework or segments"),
                                                              h(s_("#{ctr_n}|May I really add it under %{task_name} ?")) % {:task_name => it.name}),
                          :submit => "applying_schedule_list",
                          :update => "applying_schedule_list",   
                          :url => { :controller => "pjc_applying_framework_to_task", :action => "selected_object_add_child", :row_no => idx ,:root => "0"}
                         },
                         {
                          :style=>"text-decoration:none;"
                         })
      else
        "&nbsp;"
      end
    end
  end
   
  def selected_object_add_left(it ,idx,ctr_n)
    link_to_remote("▲",
                     {
                      :before => check_selected_script(s_("#{ctr_n}|select framework or segments"),
                                                          h(s_("#{ctr_n}|May I really add it before %{task_name} ?")) % {:task_name => it.name}),
                      :submit => "applying_schedule_list",
                      :update => "applying_schedule_list",   
                      :url => { :controller => "pjc_applying_framework_to_task", :action => "selected_object_add_left", :row_no => idx}
                     },
                     {
                      :style=>"text-decoration:none;"
                     })
   end
   
   def selected_object_add_right(it ,idx,ctr_n)
    link_to_remote("▼",
                     {
                      :before => check_selected_script(s_("#{ctr_n}|select framework or segments"),
                                                          h(s_("#{ctr_n}|May I really add it after %{task_name} ?")) % {:task_name => it.name}),
                      :submit => "applying_schedule_list",
                      :update => "applying_schedule_list",   
                      :url => { :controller => "pjc_applying_framework_to_task", :action => "selected_object_add_right", :row_no => idx}
                     },
                     {
                      :style=>"text-decoration:none;"
                     })
   end

   
   def applying_bool(value)
     if value == "true"
       return true
     else
       return false
     end
   end
   def applying_checked_onclick(idx)
     script = "document.getElementById('remote_applying_schedule_#{idx}_applying_check').onclick();"
     return script 
   end
  
  def check_applying_script(message1,message2)
    script = "if(document.getElementById('applying_schedule_1_applying_check').checked == true) { if(confirm('#{message1}')==false){return false;} }"
    script += "else{if(confirm('#{message2}')==false){return false;}}"
  end
   
   def remote_applying_checked(it,idx,ctr_n)
      link_to_remote("delete",
                     {
                      :before => check_applying_script(s_("#{ctr_n}|do you remove really？"),s_("#{ctr_n}|do you apply?")),
                      :submit => "applying_schedule_list",
                      :update => "applying_schedule_list",   
                      :url => { :controller => "pjc_applying_framework_to_task", :action => "change_applying_checked", :row_no => idx}
                     },
                     {:id => "remote_applying_schedule_#{idx}_applying_check" ,:style=>"display:none"})   
   end
end
