module PjcTaskHelper
  
  # EVMのカラム名
  EVM_UNIT_OF_MONEY = %w(budget_at_completion planed_value earned_value actual_cost schedule_variance cost_variance)
  
  # 編集画面で担当者が未入力の場合、更新させないカラム名
  TASK_OPERATION_COLUMN = %w(operation_start_date operation_finish_date actual_result_scale actual_result_man_hour 
                            plan_progress_rate progress_rate planed_value actual_cost)
  # 編集画面で中間タスクの場合、更新できるカラム名
  TASK_PLAN_COLUMN = %(name precede_task_id results_object notes)

  # validation のエラーが存在する場合にエラーメッセージの窓を返す。
  def error_window
    if @product.is_a?(ProductDetailed)
      task_error_messages_for :it, *(symbols_for(@details.map(&:id) - @old_details, "details") + symbols_for(@new_details, "new_details"))
    else
      task_error_messages_for :it
    end
  end
  # 新規作成画面へのボタンを返す。　
  def td_button_new
    if @display.button_new? && @product.modifiable?
      b = link_to_view_motion(h(s_("rfw|button|New")),
                              @sub_view, "create",
                              {"_" => "&suffix;"},
                              {:action => "new", 
                               :product_id => @menu_select_product_id},
                               :class => "button reloadable_link")
    else
      b = "&nbsp;"
    end
    content_tag(:td, b, :class => "button_new")
  end

  # (指定されていれば)CSV出力画面へのリンクを返す。
  def td_to_csv
    return "" unless @display.csv?
    return "" if (@display.code =="PERSON_LIST" or @display.code =="PERSON_CHART_LIST")
    display_id =@display.id
    if @display.code =="CHART_LIST"
      display_id =Display.find(:first,:conditions=>["product_id =? and code =?",@display.product_id.to_i,"LIST"]).id
    end
    link = link_to_view_motion(h(s_("rfw|link_to|CSV")),
                               "view_output",
                               "output",
                               {:controller => "output", :action => "edit", :id => display_id},
                               {:controller => "output", :action => "edit", :id => display_id},
                               {:id => "output", :class => "button"})
    content_tag(:td, link, :class => "right")
  end

  # (指定されていれば)絞り込みの窓を返す。
  def td_to_narrow
    return "" unless @display.narrowing?
    inputs = @display.narrowing_value_keys.map do |key|
      {:type => "hidden", :name => "narrowing_value_#{key}", :value => session[key], :key => key}
    end
    inputs.unshift({:type => "hidden", :name => "display_id", :value => @display.id, :key => "display_id"})
    inputs.unshift({
                     :type => "hidden",
                     :name => "display_narrowing_id",
                     :value => @display.active_display_narrowing(session).id,
                     :key => "display_narrowing_id"
                   })
    inputs.push({
                  :type => "text",
                  :name => "narrowing_text",
                  :value => narrowing_text,
                  :key => "narrowing_text",
                  :html => {:readonly => true,:size =>45},
                })
    title = s_("rfw|submit_tag|Pick #{@display.active_display_narrowing(session).name}")
    picker = rfw_picker(inputs, {:controller => @display.narrowing_controller_path(session), :action => @display.narrowing_action_name(session)}, title) do |id|
      "function() {new Form.Element.Observer($('#{id}').previous(), 0.3, function(element, value) {element.form.onsubmit();});}"
    end
    content_tag(:td, picker)
  end

  # 権限で許可されていないカラムの部品を返す。
  def not_permitted_column
      filtered_message = s_("rfw|not_permitted_column|[FILTERED]")
      return "<td class=\"not_permitted_column\">#{filtered_message}</td>"
  end

  # 詳細画面および編集画面で詳細情報を表示するための table を返す。
  def with_table
    row_nums = @items.map(&:coordinate_number).compact.max
    content = []
    return "" unless row_nums
    (1..row_nums).each do |i|

          pair = [
            @items.find {|item| item.coordinates == "A#{i}"},
            @items.find {|item| item.coordinates == "B#{i}"},
          ] 
      row = pair.map do |item|
        if item.is_a?(Item)
          yield item
        else
          content_tag(:th, "", :class => "blank") + content_tag(:td, "", :class => "blank")
        end
      end.join
      content.push(content_tag(:tr, row))
    end
    return content_tag(:table, content.join, :class => "header w_detail")
  end
  
  # タスクのプロジェクトと業務の情報を表示する
  # タスクの上位タスクの情報を表示する
  def task_column_titles(type)
      content = []
      options_td ={}
      options_td[:colspan] ="2"
      options_td[:size] ="108"
      options_td[:readonly] ="true"
      if type !="new" # 詳細、編集画面
        if @it
          if @it.ancestors[0]
            task_project = PjcProject.find(@it.ancestors[0].project_id)
            task_segment = PjcProjectSegment.find(@it.ancestors[0].segment_id)
          else
            task_project = PjcProject.find(@it.project_id)
            task_segment = PjcProjectSegment.find(@it.segment_id)
          end
          if @it.parent && @it.parent.data_type == "task"
            row_parent_td = content_tag(:td, text_field_tag("high_rank_name", @it.parent.name, options_td),:colspan =>"2")
          else
            row_parent_td = content_tag(:td, text_field_tag("","", options_td),:colspan =>"2")
          end
        end
      elsif type == "new" # 新規登録画面
        if @task_title
          if @task_title.ancestors[0]
              task_project = PjcProject.find(@task_title.ancestors[0].project_id)
              task_segment = PjcProjectSegment.find(@task_title.ancestors[0].segment_id)
          else
              task_project = PjcProject.find(@task_title.project_id)
              task_segment = PjcProjectSegment.find(@task_title.segment_id)
          end
        end
        if @task_title && @task_title.data_type =="task"
          row_parent_td = content_tag(:td, text_field_tag("high_rank_name", @task_title.name, options_td),:colspan =>"2")
        else
          row_parent_td = content_tag(:td, text_field_tag("","", options_td),:colspan =>"2")
        end
      else
        row_parent_td = content_tag(:td, text_field_tag("","", options_td),:colspan =>"2")
      end
      options ={}
      options[:readonly] ="true"
      options[:size] ="25"
      option_project_name ={}
      option_project_name[:size] ="75"
      option_project_name[:readonly] ="true"
      row_project = content_tag(:th, s_("PjcTask|Task_column_title|task_project"),:width =>"220") +
                    content_tag(:td, text_field_tag("project_code", task_project.code,options),:width =>"18%") +
                    content_tag(:td, text_field_tag("project_name", task_project.name,option_project_name),:width =>"56%") 
      row_segment = content_tag(:th, s_("PjcTask|Task_column_title|task_segment"),:width =>"220") +
                    content_tag(:td, text_field_tag("segment_code", task_segment.code,options),:width =>"18%") +
                    content_tag(:td, text_field_tag("segment_name", task_segment.name,option_project_name),:width =>"56%")
      row_parent  = content_tag(:th, s_("PjcTask|Task_column_title|task_high_rank")) + row_parent_td
      content.push(content_tag(:tr, row_project))
      content.push(content_tag(:tr, row_segment))
      content.push(content_tag(:tr, row_parent))
      return content_tag(:table, content, :class => "header w_detail")
  end

  # 項目の一覧を含む table を返す。
  def items_to_table
    with_table {|item| content_tag(:th, h(item.human_name)) + item_to_td(item, @it)}
  end
  
  # タスク用詳細画面項目表示(10月26日追加)
  def task_item_to_td_show
      task_with_td("show"){|item| content_tag(:th, h(item.human_name)) + item_to_td(item, @it)}
  end
  # タスク用登録画面項目表示(10月28日追加)
  def task_item_to_td_new(type)
      task_with_td(type){|item| content_tag(:th, h(item.human_name), task_options(item)) + item_to_td_input_new(item, :it, type)}
  end

  def task_options(item)
    options ={}
    options[:class] = "w_detail"
    options[:class] += " required" if item.required?
    options[:width] = "20%"
    return options
  end
  
  def task_with_td(type)
    if type == "new"
        row_nums = @items.map(&:coordinate_number).compact.max #コメント情報を登録画面の上で非表示のため
    elsif type == "show"
        row_nums = @items.map(&:coordinate_number).compact.max-6 #下のEVM情報を詳細画面の上で非表示のため
    elsif type == "edit" 
        row_nums = @items.map(&:coordinate_number).compact.max
    end      
    dummy_tag  = '<th class="dummy w_label"></th>'
    dummy_tag += '<th class="dummy w_span1"></th>'
    dummy_tag += '<th class="dummy w_label"></th>'
    dummy_tag += '<th class="dummy w_span1"></th>'
    content = [ content_tag(:tr, dummy_tag, :class=>"dummy") ]
    options ={}
    return "" unless row_nums
        (1..row_nums).each do |i| #1 -> 2 タスク名は非表示にする
         if i==1 || i==row_nums 
           pair = [@items.find {|item| item.coordinates == "A#{i}"},]           
         else  
           pair = [@items.find {|item| item.coordinates == "A#{i}"},
                   @items.find {|item| item.coordinates == "B#{i}"},] 
         end      
          row = pair.map do |item|
            if item.is_a?(Item)
              yield item
            else
              content_tag(:th, "", :class => "blank") + content_tag(:td, "", :class => "blank")
            end
          end.join
          content.push(content_tag(:tr, row, options))
        end
    return content.join
  end

  # 項目の一覧に対応する input の table を返す。
  def items_to_table_input
    table = with_table do |item|
      options = {}
      options[:class] = "required" if item.required?
      label = content_tag(:label, h(item.human_name), :for => "it_#{item.column_name}")
      content_tag(:th, label, options) + item_to_td_input(item, :it)
    end
    table + hidden_field(:it, "lock_version")
  end

  # 項目 <em>i</em> からヘッダを返す。
  def item_to_th(i)
    options = {}
    options[:style] = i.style if i.style
    options[:class] = "required" if i.required?
    MergeableTag.new(:th, h(i.human_name), options)
  end
  
  def item_to_td(i, it)
    return not_permitted_column unless i.readable?
#    it.auth_token = form_authenticity_token
    begin
      data = i.to_data(it)  
    rescue NoMethodError
      logger.error("ERROR: not found column: #{@model_class}\##{i.column_name}")
      return "<td class=\"formError\">#{s_("rfw|formError|column not found")}</td>"
    end

    # input_type is not available in display_to_show and display_to_list
=begin
    case i.input_type
    when "text"
    when "textarea"
    when "radio", "select"
      data = data.to_s
      i.input_parameter.split(/,/).map do |pair|
        value, text = pair.split(/:/, 2)
        if value == data
          data = text
          break
        end
      end
    when "checkbox"
      data = i.input_parameter.to_s if data
    else
      logger.warn("WARN: invalid input type: #{i.input_type} (#{@model_class}\##{i.column_name})")
    end
=end

    case i.decorator
    when "front"
      content = h("#{i.decorator_parameter}#{data}")
    when "back"
      content = h("#{data}#{i.decorator_parameter}")
    when "currency"
      content = number_to_currency(data, :unit => "&yen;", :precision => 0)
    when "size" # for test
      content = h(number_to_human_size(data))
    when "nl2br"
      content = h(data).gsub(/\r?\n/) { "<br />" }
    else
      content = h(data)
    end
    
    if i.column_name == "person_in_charge_of_work_id"
       if it.person_in_charge_of_work_id && it.person_in_charge_of_work_id !=""
          person =Person.find(:first,:conditions =>["id =?",it.person_in_charge_of_work_id])
          content =person.name.to_s if person
       end
    end

    if url = i.link_url(it)
      content = link_to(content, url)
    end

    options = {
      :align => i.align,
      :class => "item",
    }
    options[:style] = i.style
    if i.column_name == "precede_task_id" 
       content = content.gsub("__new_line", ", ")
    end
    unless EVM_UNIT_OF_MONEY.index(i.column_name) == nil
       content = task_select_unit(session[:select_unit], content)
    end
    if (i.column_name =="name"&&i.model_name=="PjcTask")||i.column_name =="notes"
       options[:colspan] ="3"
    end

    if @display.code =="PJ_LIST"
      if i.column_name =="name"
        if it.project_name !=""&&it.segment_name !=""
          content ="#{it.project_code}/#{it.project_name}/#{it.segment_name}"
        else
          content =" "
        end
      elsif i.column_name =="delayed_days_before_start"   # 開始遅れと終了遅れが赤文字になる
        if it.delayed_days_before_start && it.delayed_days_before_start.to_i>0
          options[:style] ||=""
          options[:style] +=" color:red;"
        end
      elsif i.column_name =="delayed_days_until_finish"
        if it.delayed_days_until_finish && it.delayed_days_until_finish.to_i>0
          options[:style] ||=""
          options[:style] +=" color:red;"
        end
      elsif i.column_name =="progress_rate"
        if it.plan_progress_rate.to_i > it.progress_rate.to_i
          options[:style] ||=""
          options[:style] +=" color:red;"
        end
      end
    end
    content = content_tag(:div, content)
    return content_tag(:td, content, options)
  end
  
  # 項目から td を返す。
  def item_to_td_list(i, it,row)
    return not_permitted_column unless i.readable?
    begin
      data = i.to_data(it)
      if data.is_a? Proc
        data = data.call(binding())
      end
    rescue Item::Error => e
      logger.error("ERROR: Item::Error: #{e.inspect}")
      return MergeableTag.new(:td, h(e.to_s), :class => "formError")
    rescue NoMethodError => e
      logger.error("ERROR: column not found: #{@model_class}\##{i.column_name} #{e.inspect}\n#{e.backtrace.join("\n")}")
      message = s_("rfw|formError|column not found")
      return MergeableTag.new(:td, h(message), :class => "formError")
    end
    case i.decorator
    when "front"
      content = h("#{i.decorator_parameter}#{data}")
    when "back"
      content = h("#{data}#{i.decorator_parameter}")
    when "currency"
      content = number_to_currency(data, :unit => "&yen;", :precision => 0)
    when "size" # for test
      content = h(number_to_human_size(data))
    when "nl2br"
      content = h(data).gsub(/\r?\n/) { "<br />" }
    else
      content = h(data)
    end
     
    if url = i.link_url(it)
      content = link_to(content, url)
    end
    
    options = {
      :align => i.align,
      :class => "item",
    }
    options[:style] = i.style
    if i.column_name =="name" && @display.code !="PERSON_CHART_LIST" && @display.code !="PERSON_LIST" # タスクの開閉情報
       task_data_type = it.data_type.to_s
       if task_data_type =="project"
          if it.project
            content = it.project.code.to_s + it.project.name.to_s
          end
       elsif task_data_type =="segment"
          if it.segment
            content = it.segment.code.to_s + it.segment.name.to_s
          end
       end
       content = open_shut(content, it)
       person_completion = it.person_in_charge_of_work_id
       # タスク追加ボタンがあるかどうかを判断する
       it.task_level=-1 if task_data_type =="project"  
       if person_completion == nil && task_data_type != "project"  
          content = content_tag(:div, ("&nbsp;" * 5 * (it.task_level.to_f+1)) + content +
                            link_to_view_motion(image_tag("pen.png",:alt => s_("PjcTask|Task_operation|task_addition")),
                                                  @sub_view, "create", 
                                                  {"_" =>"_#{it.id}"},
                                                  {:action => "new",
                                                   :task_addition =>true,
                                                   :id => it.id}, 
                                                   :class => "reloadable_link",
                                                   :style =>"text-decoration:none;"))
       else                                               
          content = content_tag(:div, ("&nbsp;" * 5 * (it.task_level.to_i+1)) + content)
       end
       if task_data_type =="task"
          content = content + ("&nbsp;" * 5 * (it.task_level.to_i+1) + "&nbsp;" * 3) + 
                                               link_to_remote(image_tag("copy.png",:alt => s_("PjcTask|Task_operation|task_copy")),          #コピー
                                                                    {:update =>"selected_column",
                                                                    :url =>{:action => :task_date_edit,
                                                                    :selected_task_id =>it.id,
                                                                    :selected_task_name =>it.name, 
                                                                    :selected_task_code =>it.code,                                                                     
                                                                    :task_date_type =>"copy"}},
                                                                    :style =>"text-decoration:none;") +"  "+
                                               link_to_remote(image_tag("cut.png",:alt => s_("PjcTask|Task_operation|task_cut")),           #カット
                                                                    {:update =>"selected_column",
                                                                    :url =>{:action => :task_date_edit,
                                                                    :selected_task_id =>it.id,
                                                                    :selected_task_name =>it.name,
                                                                    :selected_task_code =>it.code, 
                                                                    :task_date_type =>"cut"}},
                                                                    :style =>"text-decoration:none;")
                                                         
         if person_completion ==nil
            content = content + "  " + link_to_remote(image_tag("paste.png",:alt =>s_("PjcTask|Task_operation|task_paste")),                #ペースト
                                                     {:url =>{:action => :task_copy_and_paste_validate,:id => it.id}},
                                                      :style =>"text-decoration:none;")
            content << link_to_view_motion("",  
                                             @sub_view, "record",{"_" => "#{it.id}"},
                                             {:controller => "pjc_task",
                                              :action => "task_copy_and_paste_picker",
                                              :id => it.id},
                                             {:class => "reloadable_link"})
         end
       elsif task_data_type =="segment"                                                                  # ペースト
            content = content + ("&nbsp;" * 10 * (it.task_level.to_i+1) + "&nbsp;" * 3) +
                                     link_to_remote(image_tag("paste.png",:alt =>s_("PjcTask|Task_operation|task_paste")), 
                                                     {:url =>{:action => :task_copy_and_paste_validate,:id => it.id}},
                                                      :style =>"text-decoration:none;")
            content << link_to_view_motion("",  
                                             @sub_view, "record",{"_" => "#{it.id}"},
                                             {:controller => "pjc_task",
                                              :action => "task_copy_and_paste_picker",
                                              :id => it.id},
                                             {:class => "reloadable_link"})
       end   
    end
    # 進捗率が100％の場合
    if it.progress_rate.to_f == 100
       options[:style] ||=""
       options[:style] += "background-color:0FF;"
    end
    if row =="two_rows"
      options[:height] ="20"
    else # 二行表示或いは一行表示
      options[:rowspan] = "2"
      if @evm_unit_of_money.index(i.column_name) != nil # 金額単位の計算
        session[:select_unit] = @select_unit
        content = task_select_unit(session[:select_unit], content)
      end
    end
    options[:nowrap] =true      
    if i.column_name == "precede_task_id" # 先行タスクの改行処理
      content = content.gsub(/__new_line/,"<br>")  # __new_lineの文字があったら、改行する
    # 開始遅れと終了遅れが赤文字になる
    elsif i.column_name =="delayed_days_before_start"
      if it.delayed_days_before_start && it.delayed_days_before_start.to_i>0
        options[:style] ||=""
        options[:style] +=" color:red;"
      end
    elsif i.column_name =="delayed_days_until_finish"
      if it.delayed_days_until_finish && it.delayed_days_until_finish.to_i>0
        options[:style] ||=""
        options[:style] +=" color:red;"
      end
    elsif i.column_name == "attachment"
      if Attachment.find(:first,:conditions =>["attachable_type =? and attachable_id =?","PjcTask",it.id])
        options[:align] ="center"
        content =link_to_task_edit(it)
      end
    end
    return content_tag(:td, content.to_s, options, :valign => "top")
  end
  
  def task_select_unit(select_unit, content)
      if select_unit.to_i == 1 # 単位が万円
          content = sprintf("%.2f", content.to_f/10000)
      elsif select_unit.to_i == 2  # 単位が百万円
          content = sprintf("%.2f", content.to_f/1000000)
      else                          # 単位が円
          content = sprintf("%.0f", content.to_f)   
      end
      return content
  end

  # 項目から td にラップされた input を返す。
  def item_to_td_input(i, object_name)

    it = instance_variable_get("@#{object_name}")
    return item_to_td(i, it) if i.is_a?(ItemPseudo)
    begin
      data = it.__send__(i.column_name)
    rescue NoMethodError
      logger.error("ERROR: column not found: #{@model_class}\##{i.column_name}")
      return "<td class=\"formError\">#{s_("rfw|formError|column not found")}</td>"
    end
    if i.input_type == "picker"
       return content_tag(:td, picker_tags(i, object_name, it), {:class => "input_item", :style => i.style})
    end
    field_options = {}
#    field_options[:readonly] = "readonly" unless i.writable?
    
    text_options = {
      :size  => i.size_for_input_field,
      :style => i.style_for_input_field,
    }
    text_options.update(field_options)
    case i.input_type
    when "picker"
      e = picker_tags(i, object_name, it)
    when "text"
      e = text_field object_name, i.column_name, text_options
    when "textarea"
      e = text_area object_name, i.column_name, text_options
    when "radio"
      choices = i.split_into_input_options do |name, value|
        radio_button_with_label(object_name, i.column_name, value, h(name), field_options)
      end
      unless i.required?
        choices.unshift(radio_button_with_label(object_name, i.column_name, "", h(s_("rfw|InputOption|(blank)")), field_options))
      end
      e = choices.join
    when "checkbox"
      e = check_box(object_name, i.column_name, field_options) + i.input_parameter.to_s
    when "select"
      choices = i.split_into_input_options do |name, value|
        [h(name), value]
      end
      unless i.required?
        choices.unshift([h(s_("rfw|InputOption|(blank)")), ""])
      end
      e = select(object_name, i.column_name, choices, field_options)
    else
      logger.error("ERROR: invalid input type: #{i.input_type} (#{@model_class}\##{i.column_name})")
      return "<td class=\"formError\">#{s_("rfw|formError|invalid input type")}</td>"
    end
    options ={}
    options[:class] ="input_item"
    options[:style] =i.style 
    
    if (i.column_name == "name" && i.model_name =="PjcTask") || i.column_name == "notes"
       options[:colspan] ="3"
    end
    return content_tag(:td, e, options, :id => i.column_name )
  end
  
  # new 画面のため（先行タスク選択用）10月31日追加
  def item_to_td_input_new(i, object_name, type)
    it = instance_variable_get("@#{object_name}")
    if i.column_name == "precede_task_id"
       task_e = precede_task_picker_tags(i, object_name, it, type)
       return content_tag(:td, task_e, {:class => "input_item", :style => i.style}, :id => i.column_name )
    end
    
    if type == "edit"
    # 編集画面で担当者が未入力の場合  
        if (it.person_in_charge_of_work_id == nil && TASK_OPERATION_COLUMN.index(i.column_name) != nil)||i.column_name =="plan_progress_rate"||i.column_name =="planed_value"
           return item_to_td(i, it)
        end
    # 編集画面で中間タスクの場合
        if it.children !=[] && it.person_in_charge_of_work_id == nil && TASK_PLAN_COLUMN.index(i.column_name) == nil
           return item_to_td(i, it)
        end
    end     
    begin
      data = it.__send__(i.column_name)
    rescue NoMethodError
      logger.error("ERROR: column not found: #{@model_class}\##{i.column_name}")
      return "<td class=\"formError\">#{s_("rfw|formError|column not found")}</td>"
    end
    if i.input_type == "picker"
       e = picker_tags(i, object_name, it)
       return content_tag(:td, e, {:class => "input_item", :style => i.style})
    end
    
    
    field_options = {}
    
    text_options = {
      :size  => i.size_for_input_field,
      :style => i.style_for_input_field,
    }
    text_options.update(field_options)
    case i.input_type
    when "picker"
      e = picker_tags(i, object_name, it)
    when "text"
      e = field_with_errors(i, object_name) do
        val = if i.date?
                fit_into_external_date_format(data)
              elsif i.year_month?
                fit_into_external_year_month_format(data)
              elsif it.respond_to?("#{i.column_name}_before_type_cast")
                it.__send__("#{i.column_name}_before_type_cast")
              else
                data
              end
        if i.column_name =="budget_at_completion" || i.column_name =="actual_cost"
          val = val.to_f.to_i unless val==nil
        end
        text_field_tag(rfw_name_for(object_name, i.column_name), val, text_options)
      end
    when "textarea"
      e = text_area object_name, i.column_name, text_options
    when "radio"
      choices = i.split_into_input_options do |name, value|
        radio_button_with_label(object_name, i.column_name, value, h(name), field_options)
      end
      unless i.required?
        choices.unshift(radio_button_with_label(object_name, i.column_name, "", h(s_("rfw|InputOption|(blank)")), field_options))
      end
      e = choices.join
    when "checkbox"
      e = check_box(object_name, i.column_name, field_options) + i.input_parameter.to_s
    when "select"
      choices = i.split_into_input_options do |name, value|
        [h(name), value]
      end
      unless i.required?
        choices.unshift([h(s_("rfw|InputOption|(blank)")), ""])
      end
      e = select(object_name, i.column_name, choices, field_options)
    else
      logger.error("ERROR: invalid input type: #{i.input_type} (#{@model_class}\##{i.column_name})")
      return "<td class=\"formError\">#{s_("rfw|formError|invalid input type")}</td>"
    end
    if error_message_on(object_name, i.column_name).blank? ==false      
    else
       case i.column_name
          when "budget_at_completion"
             if @budget_at_completion_presence_error
               e =content_tag(:div, e, :class => "fieldWithErrors")
               e +=content_tag(:div, s_("PjcTask|Task_error_message|presence_error%{date}") % {:date=>@budget_at_completion_presence_error}, :class => "formError")
             end
          when "progress_rate"  
             if @progress_rate_presence_error
               e =content_tag(:div, e, :class => "fieldWithErrors")
               e +=content_tag(:div, s_("PjcTask|Task_error_message|presence_error%{date}") % {:date=>@progress_rate_presence_error}, :class => "formError")
             elsif @progress_rate_comparison_error || @progress_rate_unequal100_error
               e =content_tag(:div, e, :class => "fieldWithErrors")
               e +=content_tag(:div, s_("PjcTask|Task_error_message|right_error%{date}") % {:date=>s_("PjcTask|Progress rate")}, :class => "formError")
             end 
       end
    end  

    #   登録画面のコメント
    if (i.column_name =="name"&&i.model_name=="PjcTask")||i.column_name =="notes"
       return content_tag(:td, e, {:class => "input_item", :style => i.style, :colspan => "3"}, :id => i.column_name )
    end
    return content_tag(:td, e, {:class => "input_item", :style => i.style}, :id => i.column_name )
  end

  #
  def detail_to_tr(d, script=nil, options={}, &block)
    tds = @detail_items.map {|i| yield(i, d)}
    if script
      tds.unshift(content_tag(:td, '<img src="/images/drag_handle.png" width=22 height=22 class="iepngfix" />', :class => "handle"))
      #button = button_to_function(h(s_("rfw|button|Destroy")), script, :class => "button")
      #tds.push(content_tag(:td, button))
      if script
        img = '<img src="/images/delete.png" width=16 height=16 class="iepngfix" alt="' + h(s_("rfw|button|Destroy")) + '" />'
        link = link_to_function(img, script)
        tds.push(content_tag(:td, link))
      end
    end
    options.update({:class => cycle("even", "odd", :name => "details_to_table")})
    content_tag(:tr, tds, options)
  end

  def with_details(seed = random_id(), tail=nil, &block)
    col_width_dragg = 24                # column width dragg_handle icon
    col_width_delete = 18               # column width delete icon

    ths = @detail_items.map {|i| item_to_th(i)}
    ths.unshift(content_tag(:th, "&nbsp;", :width => col_width_dragg)) unless tail.blank?
    ths.push(content_tag(:th, "&nbsp;", :width => col_width_delete)) if tail
    head = content_tag(:thead, content_tag(:tr, ths))
    foot = content_tag(:tfoot, "")
    body = content_tag(:tbody, yield, {:id => "details_table_body_#{seed}"})

    table_width = 0
    @detail_items.each do |i|
      if i.layout > 0 && !(i.width.blank?)
        table_width = table_width + i.width.to_i
      end
    end

    if table_width > 0 then
      table_width = table_width + col_width_dragg + col_width_delete
      table = content_tag(:table, [head, foot, body],{:id => "details_table_#{seed}", :class => "details hoverable", :width => table_width})
    else
      table = content_tag(:table, [head, foot, body],{:id => "details_table_#{seed}", :class => "details hoverable"})
    end

    return table + (tail || "")
  end

  # 
  def details_to_table
    return "" unless @product.is_a?(ProductDetailed)
    with_details do
      @details.map {|d| detail_to_tr(d) {|i,d| item_to_td(i,d)}}
    end
  end

  #
  def details_to_table_input
    return "" unless @product.is_a?(ProductDetailed)
    seed = random_id()
    space_details = "space_details_#{seed}"
    tail = sortable_details(seed)
    tail += hidden_field_tag("new_details", @new_details.to_json, :id => "new_details_#{seed}")
    tail += hidden_field_tag("old_details", @old_details.to_json, :id => "old_details_#{seed}")
    tail += hidden_field_tag("order_details",
                             @details.map {|detail| "details_#{detail.id}"}.to_json,
                             :id => "order_details_#{seed}")
    d = @product.detail_class.new
    @detail_items.each do |i|
      i.initialize_column_of(d)
    end
    temp = "new_details_#{rand(65536)}#{Time.now.to_i}"
    instance_variable_set("@#{temp}", d)
    tr = detail_to_tr(d, "App.remove_new_details(this,\#{n},'#{seed}');", :id => temp) {|i,d| item_to_td_input(i, temp)}
    tr = tr.gsub(temp, "new_details_\#{n}")
    tr = tr.gsub(/(rfw_button_to_submit)_(\d+)/, '\1_\2_#{random}')
    button = button_to_function(h(s_("rfw|button|New")), remote_function({
                            :before => "App.add_new_details('#{escape_javascript(tr)}', '#{seed}');",
                            :update => space_details,
                            :url => {:action => "add_detail", :seed => seed},
                          }), {
                            :class => "button",
                          })
    tail += content_tag(:div, "", :id => space_details)
    html_tag = with_details(seed, tail) do
      rows = []
      @details.each do |d|
        unless @old_details.include?(d.id)
          html_id = "details_#{d.id}"
          rows << detail_to_tr(d, "App.remove_old_details(this,#{d.id},'#{seed}');", :id => html_id) {|i,d| item_to_td_input(i, html_id)}
        end
      end
      rows += @new_details.map do |n|
        d = instance_variable_get("@new_details_#{n}")
        html_id = "new_details_#{n}"
        detail_to_tr(d, "App.remove_new_details(this,#{n},'#{seed}');", :id => html_id) {|i,d| item_to_td_input(i, html_id)}
      end
      #rows
    end

    rows  = content_tag(:div, html_tag, :class => "detail_scroll_base w_detail")
    rows += content_tag(:div, button, :class => "right")
  end

  def sortable_details(seed)
    sortable_element("details_table_body_#{seed}",
                     :format => "/^(details_[0-9]+|new_details_[0-9]+)$/",
                     :complete => visual_effect(:highlight, "details_table_#{seed}"),
                     :url => {:action => "order_details"},
                     :constraint => false,
                     :ghosting => true,
                     :handle => "handle",
                     :tag => "tr")
  end

  # カレンダー選択部品による入力部品を返す。
  def calendar_picker_tags(i, object_name, it)
    picker_field = i.picker_field(it, object_name)
 
    if flash[:pick] && picker_field === flash[:pick][:field] && flash[:pick][:return_value]
      it[i.column_name] = flash[:pick][:return_value]
    end

    e = text_field object_name, i.column_name, :size => i.size_for_input_field
    e << " "
    if error_message_on(object_name, i.column_name).blank? ==false   
    else 
      case i.column_name
          when "planned_start_date"
            # 終了予定日入力した場合、開始予定日入力必須
            if @planned_start_date_presence_error
               e =content_tag(:div, e, :class => "fieldWithErrors")
               e +=content_tag(:div, s_("PjcTask|Task_error_message|date_presence_error_1%{date}") % {:date=>@planned_start_date_presence_error}, :class => "formError")
            # 終了予定日＜開始予定日の場合
            elsif @planned_start_date_comparison_error
                  e =content_tag(:div, e, :class => "fieldWithErrors")
                  e +=content_tag(:div, s_("PjcTask|Task_error_message|date_comparison_error%{start_date}-%{finish_date}") % {:start_date=>s_("PjcTask|Plan start date"),:finish_date=>s_("PjcTask|Plan finish date")}, :class =>"formError")
            end
          when "operation_start_date"
            # 終了日入力した場合、開始日入力必須
            if @operation_start_date_presence_error_1
               e =content_tag(:div, e, :class => "fieldWithErrors")
               e +=content_tag(:div, s_("PjcTask|Task_error_message|date_presence_error_1%{date}") % {:date=>@operation_start_date_presence_error_1}, :class => "formError")
            # 終了予定日＜開始予定日の場合
            elsif @operation_start_date_presence_error_2
                  e =content_tag(:div, e, :class => "fieldWithErrors")
                  e +=content_tag(:div, s_("PjcTask|Task_error_message|presence_error%{date}") % {:date=>@operation_start_date_presence_error_2}, :class => "formError")
            elsif @operation_start_date_comparison_error
                  e =content_tag(:div, e, :class => "fieldWithErrors")
                  e +=content_tag(:div, s_("PjcTask|Task_error_message|date_comparison_error%{start_date}-%{finish_date}") % {:start_date=>s_("PjcTask|Operation start date"),:finish_date=>s_("PjcTask|Operation finish date")}, :class =>"formError")
            end
          when "operation_finish_date"
            # 進捗率が100%の場合、開始日と終了日両方必須入力
            if @operation_finish_date_presence_error
               e =content_tag(:div, e, :class => "fieldWithErrors")
               e +=content_tag(:div, s_("PjcTask|Task_error_message|date_presence_error_2%{date}") % {:date=>@operation_finish_date_presence_error}, :class => "formError")
            end
      end
    end
    e << submit_tag(s_("rfw|submit_tag|Pick Date"), 
                          :name => "picker[#{picker_field}]", 
                          :onclick => "$('#{object_name}_#{i.column_name}').addClassName('selected')", 
                          :disabled => !i.writable?)
    # hidden link for ajax
    e << link_to_view_motion("",
      @sub_view, picker_field, {},
      {
        :controller => "calendar",
        :action => "calendar",
        :return_field => picker_field,
        :task_id => it.id,
        :view => @sub_view,
      }, :style => "display:none")
    return e
  end
  
  # 先行タスク選択部品による入力部品を返す　11月4日追加
  def precede_task_picker_tags(i, object_name, it, type)

      #picker_field = i.picker_field(it, object_name)
      picker_field = "precede_task#{i.id}"
      picker_checked = "checked"
      v = [] #選択した先行タスクのコード
      d = [] #選択した先行タスクのid
     if flash[:pick] && picker_checked == flash[:pick][:checked]
       task_checked = flash[:pick][:field]
       task_checked.each do |t|
          v << t[:task_name]
          d << t[:task_id]
       end
       session[:v] = [v,d] #選択した先行タスクを保存する
     elsif session[:v]
       v = session[:v][0]
       d = session[:v][1]
     # 編集画面の先行タスクを表示する     
     elsif type == "edit"
       it.pjc_precede_tasks.sort_by{|t| t.id}.each do |p|
          v << p.pjc_precede_task.name
          d << p.pjc_precede_task.id
       end
       session[:old_precede_task_id] = d
     end

     task_e = text_field_tag("it_precede_task", v.join(" "), :readonly => true, :size =>"40")
     task_e << hidden_field_tag("it_precede_task_id", d.join(","))
      
     if type == "edit"
       session[:task_type] ="edit"
       task_e << hidden_field_tag("old_precede_task_id", session[:old_precede_task_id].join(","))
       task_id =it.id
     else
       task_id =@task_title.id
     end
     task_e << " "
     task_e << submit_tag(s_("PjcTask|Task_title|precede_task_choice"), :name => "picker[#{picker_field}]",
                                             :onclick => "$('#{object_name}_#{i.column_name}').addClassName('selected')",
                                             :disabled => (i.readonly? || !i.writable?))
     task_e << link_to_view_motion("",
                                    @sub_view, picker_field, {},
                                    {:controller => "pjc_task_picker",
                                     :action => "precede_task",
                                     :return_field => picker_field,
                                     :checked_task => d.join(",").to_s,
                                     :task_id =>task_id,
                                     :view       => @sub_view,
                                  }, :style => "display:none")
     return task_e
  end

  # <em>method</em> に関するエラーをまとめて返す。
  def error_messages_on(object, method)
    if (obj = (object.respond_to?(:errors) ? object : instance_variable_get("@#{object}"))) &&
        (errors = obj.errors.on(method))
      content_tag("div", errors.is_a?(Array) ? errors.join('<br />') : errors, :class => "formError")
    else
      ''
    end
  end

  # エラーメッセージがある場合には fieldWithErrors という class を持つ div でくるんで返す。
  def field_with_errors(i, object_name, &block)
    tags = block.call
    em = error_messages_on(object_name, i.column_name)
    unless em.blank?
      tags = content_tag(:div, tags, :class => "fieldWithErrors") + em
    end
    tags
  end

  def picker_tags(i, object_name, it)
    case App::PICKER_MODE
    when :ajax
      ajax_picker_tags(i, object_name, it)
    when :dom
      field_with_errors(i, object_name) do
        rfw_picker_tags(i, object_name, it)
      end
    else
      raise "unknown picker mode: #{App::PICKER_MODE}"
    end
  end

    # カレンダー選択部品による入力部品を返す。
  def ajax_calendar_picker_tags(i, object_name, it)
    picker_field = i.picker_field(it, object_name)

    if flash[:pick] && picker_field === flash[:pick][:field] && flash[:pick][:return_value]
      it[i.column_name] = flash[:pick][:return_value]
    end

    e = text_field object_name, i.column_name, :size => i.size_for_input_field
    e << " "
    if error_message_on(object_name, i.column_name).blank? ==false
    else
          case i.column_name
              when "planned_start_date"
                # 終了予定日入力した場合、開始予定日入力必須
                if @planned_start_date_presence_error
                   e =content_tag(:div, e, :class => "fieldWithErrors")
                   e +=content_tag(:div, s_("PjcTask|Task_error_message|date_presence_error_1%{date}") % {:date=>@planned_start_date_presence_error}, :class => "formError")
                # 終了予定日＜開始予定日の場合
                elsif @planned_start_date_comparison_error
                      e =content_tag(:div, e, :class => "fieldWithErrors")
                      e +=content_tag(:div, s_("PjcTask|Task_error_message|date_comparison_error%{start_date}-%{finish_date}") % {:start_date=>"Plan_start_date",:finish_date=>"Plan_finish_date"}, :class =>"formError")
                end
              when "operation_start_date"
                # 終了日入力した場合、開始日入力必須
                if @operation_start_date_presence_error_1
                   e =content_tag(:div, e, :class => "fieldWithErrors")
                   e +=content_tag(:div, s_("PjcTask|Task_error_message|date_presence_error_1%{date}") % {:date=>@operation_start_date_presence_error_1}, :class => "formError")
                # 終了予定日＜開始予定日の場合
                elsif @operation_start_date_presence_error_2
                      e =content_tag(:div, e, :class => "fieldWithErrors")
                      e +=content_tag(:div, s_("PjcTask|Task_error_message|presence_error%{date}") % {:date=>@operation_start_date_presence_error_2}, :class => "formError")
                elsif @operation_start_date_comparison_error
                      e =content_tag(:div, e, :class => "fieldWithErrors")
                      e +=content_tag(:div, s_("PjcTask|Task_error_message|date_comparison_error%{start_date}-%{finish_date}") % {:start_date=>"Operation_start_date",:finish_date=>"Operation_finish_date"}, :class =>"formError")
                end
              when "operation_finish_date"
                # 進捗率が100%の場合、開始日と終了日両方必須入力
                if @operation_finish_date_presence_error
                   e =content_tag(:div, e, :class => "fieldWithErrors")
                   e +=content_tag(:div, s_("PjcTask|Task_error_message|date_presence_error_2%{date}") % {:date=>@operation_finish_date_presence_error}, :class => "formError")
                end
          end
    end
    e << submit_tag(s_("rfw|submit_tag|Pick Date"),
                          :name => "picker[#{picker_field}]",
                          :onclick => "$('#{object_name}_#{i.column_name}').addClassName('selected')",
                          :disabled => !i.writable?)
    # hidden link for ajax
    e << link_to_view_motion("",
      @sub_view, picker_field, {},
      {
        :controller => "calendar",
        :action => "calendar",
        :return_field => picker_field,
        :task_id => it.id,
        :view => @sub_view,
      }, :style => "display:none")
    return e
  end

  # 選択部品による入力部品を返す。
  def ajax_picker_tags(i, object_name, it)
#    return ajax_calendar_picker_tags(i, object_name, it) if i.calendar?
    return rfw_calendar_tags(i, object_name, it) if i.calendar?
    case i
    when ItemProper
      case i.picked_atom
      when "company"
        submit_text = s_("rfw|submit_tag|Pick Company")
      when "organization"
        submit_text = s_("rfw|submit_tag|Pick Organization")
      when "person"
        submit_text = s_("rfw|submit_tag|Pick Person")
      when "post"
        submit_text = s_("rfw|submit_tag|Pick Post")
      when "group"
        submit_text = s_("rfw|submit_tag|Pick Group")
      else
        raise ArgumentError, "invalid picked atom: #{i.picked_atom}"
      end
      picker_field = i.picker_field(it, object_name)
      picked_class = i.picked_atom.classify.constantize
      if flash[:pick] && picker_field == flash[:pick][:field]
        values = i.picked_values(flash[:pick])
        v = values.find {|x| x.is_a?(picked_class)}
        it[i.column_name] = v.id
      elsif v = picked_class.find_by_id(it[i.column_name])
        values = i.picked_references(v)
      else
        values = i.picked_keys.map {|k| k.classify.constantize.new}
      end
      e = ""
      i.picked_keys.each_with_index do |k,n|
        e << text_field_tag("picker_#{picker_field}_#{k}", values[n].name, :readonly => true, :size => i.size_for_input_field)
        e << " "
      end
      onclick = i.picked_keys.map do |k|
        "$('picker_#{picker_field}_#{k}').addClassName('selected');"
      end.join("")
      e << submit_tag(submit_text, :name => "picker[#{picker_field}]", :onclick => onclick, :disabled => (i.readonly? || !i.writable?))
      unless error_message_on(object_name, i.column_name).blank?
        e = content_tag(:div, e, :class => "fieldWithErrors")
      end
      # hidden link for ajax
      e << link_to_view_motion("",
                               @sub_view, picker_field, {},
                               {
                                 :controller   => "picker",
                                 :action       => i.picked_atom,
                                 :return_field => picker_field,
                                 :view         => @sub_view,
                               }, :style       => "display:none")
      e << hidden_field(object_name, i.column_name)
      return e
    when ItemPolymorphic
      picker_field = i.picker_field(it, object_name)
      if flash[:pick] && picker_field == flash[:pick][:field]
        if ( k = flash[:pick][:lump_pick] ) && ( v = k.classify.constantize.find_by_id(flash[:pick][k.to_sym]) )
          it.__send__("#{i.column_name}=", v)
        end
      elsif v = it.__send__(i.column_name)
      else
        v = nil
      end
      e = ""
      e << text_field_tag("picker_#{picker_field}", v ? v.name : "", :readonly => true, :size => i.size_for_input_field)
      onclick = "$('picker_#{picker_field}').addClassName('selected');"
      e << submit_tag(s_("rfw|submit_tag|Pick"), :name => "picker[#{picker_field}]", :onclick => onclick, :disabled => (i.readonly? || !i.writable?))
      unless error_message_on(object_name, i.column_name).blank?
        e = content_tag(:div, e, :class => "fieldWithErrors")
      end
      # hidden link for ajax
      e << link_to_view_motion("",
                               @sub_view, picker_field, {},
                               {
                                 :controller   => "picker",
                                 :action       => "lump",
                                 :return_field => picker_field,
                                 :view         => @sub_view,
                               }, :style       => "display:none")
      e << hidden_field(object_name, "#{i.column_name}_id")
      e << hidden_field(object_name, "#{i.column_name}_type")
      return e
    when ItemPlural
      picker_field = i.picker_field(it, object_name)
      if flash[:pick] && picker_field == flash[:pick][:field]
        if ( k = flash[:pick][:lump_pick] ) && ( picked_one = k.classify.constantize.find_by_id(flash[:pick][k.to_sym]) )
          values = picked_one.__send__(i.data_method_name)
          it[i.column_name] = values.map(&:id).join(",")
        else
          values = []
        end
      else
        v = it.__send__(i.column_name)
        values = i.datum_class.joints(v)
      end
      e = ""
      e << text_field_tag("picker_#{picker_field}", values.map(&:name).join(","), :readonly => true, :size => i.size_for_input_field)
      onclick = "$('picker_#{picker_field}').addClassName('selected');"
      e << submit_tag(s_("rfw|submit_tag|Pick"), :name => "picker[#{picker_field}]", :onclick => onclick, :disabled => (i.readonly? || !i.writable?))
      unless error_message_on(object_name, i.column_name).blank?
        e = content_tag(:div, e, :class => "fieldWithErrors")
      end
      # hidden link for ajax
      e << link_to_view_motion("",
                               @sub_view, picker_field, {},
                               {
                                 :controller   => "picker",
                                 :action       => "lump",
                                 :return_field => picker_field,
                                 :view         => @sub_view,
                               }, :style       => "display:none")
      e << hidden_field(object_name, i.column_name)
      return e
    else
      raise ArgumentError, "invalid item type: #{i.class}"
    end
  end

  def rfw_calendar_tags(i, object_name, it)
    picker_field = i.picker_field(it, object_name)
    tags=rfw_picker([{
                  :type => "text",
                  :name => rfw_name_for(object_name, i.column_name),
                  :value => i.to_data(it),
                  :key => "return_value",
                  :html => { :size => i.size_for_input_field }
                }],
               {
                 :controller => 'pick/calendar',
                 :action => "search",
                 :return_format => i.calendar_format,
                 :alert_holiday => i.calendar_alert_holiday?,
                 :escape => false,
               },
               s_('rfw|submit_tag|Pick Date'))
    # 終了予定日入力した場合、開始予定日入力必須
    if @planned_start_date_presence_error && i.column_name =="planned_start_date"
      em =content_tag(:div, s_("PjcTask|Task_error_message|date_presence_error_1%{date}") % {:date=>s_("PjcTask|Planned start date")}, :class => "formError")
    # 実績終了日入力した場合、実績開始日入力必須
    elsif @operation_start_date_presence_error_1 && i.column_name =="operation_start_date"
      em =content_tag(:div, s_("PjcTask|Task_error_message|date_presence_error_1%{date}") % {:date=>s_("PjcTask|Operation start date")}, :class => "formError")
    # 進捗率が入力する場合、作業開始日が入力必須
    elsif @operation_start_date_presence_error_2 && i.column_name =="operation_start_date"
      em =content_tag(:div, s_("PjcTask|Task_error_message|presence_error%{date}") % {:date=>s_("PjcTask|Operation start date")}, :class => "formError")
    # 進捗率が100%の場合、開始日と終了日両方必須入力
    elsif @operation_finish_date_presence_error && i.column_name =="operation_finish_date"
      em =content_tag(:div, s_("PjcTask|Task_error_message|presence_error%{date}") % {:date=>s_("PjcTask|Operation finish date")}, :class => "formError")
    end
    unless em.blank?
      tags = content_tag(:div, tags, :class => "fieldWithErrors") + em
    end
    tags
  end

  # 選択部品によって選択された内容を表示する際の名前は picked_name が優先される。
  def rfw_picked_name(picked_one)
    return picked_one.picked_name if picked_one.respond_to?(:picked_name)
    picked_one.name
  end

  def rfw_picker_tags(i, object_name, it)
    return rfw_calendar_tags(i, object_name, it) if i.calendar?
    case i
    when ItemProper
      options = i.rfw_picker_options(it, object_name)
      id = rfw_value_for(object_name, i.column_name)
      unless id.blank?
        found = i.picked_atom.classify.constantize.find_by_id(id)
        name = rfw_picked_name(found) if found
        name = found.to_text if i.input_parameter =~ /\A(?:project)/ && found
      end
      rfw_picker([{
                    :type => 'text',
                    :name => "#{rfw_name_for(object_name, i.column_name)}_name",
                    :value => name,
                    :key => options[:return_field_name],
                    :html => { :readonly => true, :size => i.size_for_input_field }
                  },
                  {
                    :type => 'hidden',
                    :name => rfw_name_for(object_name, i.column_name),
                    :value => id,
                    :key => options[:return_field_id]
                  },
                  '<br />',
                 ],
                 { :controller => options[:controller], :action => 'search' },
                 s_(options[:submit_text])) do |x_id|
        # * プロジェクト
        # * 業務
        # * 案件
        # に関する選択部品の場合には選択が完了した時点で変化があれば一度サーバに送信して編集画面を再描画する。
        if i.input_parameter =~ /\A(?:matter|project)/
          "function() {new Form.Element.Observer($('#{x_id}').previous('input'), 0.3, function(element, value) {element.form.onsubmit();});}"
        elsif i.picking_record?
          # rfw[record_model_name] を動的に指定する。
          "Rfw.embedHiddenParameters.bindAsEventListener($('#{x_id}'), {record_model_name: '#{i.picked_atom.classify}', record_setting_id: '#{i.id}'})"
        else
          ''
        end
      end
    when ItemPolymorphic
      picker_field = i.picker_field(it, object_name)
      id = rfw_value_for(object_name, "#{i.column_name}_id")
      model_class = rfw_value_for(object_name, "#{i.column_name}_type")
      value = nil
      unless id.blank? || model_class.blank?
        found = model_class.constantize.find_by_id(id)
        value = rfw_picked_name(found) if found
      end
      rfw_picker([{
                    :type => 'text',
                    :name => "picker_#{picker_field}",
                    :value => value,
                    :key => 'model_value',
                    :html => { :readonly => true, :size => i.size_for_input_field }
                  },
                  {
                    :type => 'hidden',
                    :name => rfw_name_for(object_name, "#{i.column_name}_type"),
                    :value => model_class,
                    :key => 'model_name'
                  },
                  {
                    :type => 'hidden',
                    :name => rfw_name_for(object_name, "#{i.column_name}_id"),
                    :value => id,
                    :key => 'model_id'
                  },
                  '<br />',
                 ],
                 { :controller => 'pick/lump', :action => 'search', :mode => 'company' },
                 s_('rfw|submit_tag|Pick'))
    when ItemPlural
      picker_field = i.picker_field(it, object_name)
      ids = rfw_value_for(object_name, i.column_name)
      values = Person.joints(ids).map(&:name)
      rfw_picker([{
                    :type => 'text',
                    :name => "picker_#{picker_field}",
                    :value => values.join(','),
                    :key => 'people_names',
                    :html => { :readonly => true, :size => i.size_for_input_field  } },
                  {
                    :type => 'hidden',
                    :name => rfw_name_for(object_name, i.column_name),
                    :value => ids,
                    :key => 'people_ids'
                  },
                  '<br />',
                 ],
                 { :controller => 'pick/lump_people', :action => 'search', :mode => 'company' },
                 s_('rfw|submit_tag|Pick'))
    else
      raise ArgumentError, "invalid item type: #{i.class}"
    end
  end

  # pjc3用拡張選択部品による入力部品を返す。
  def rfw_exstra_picker_tags(i, object_name, it)
    case i.input_parameter
    when "destination"
      return rfw_destination_picker_tags(i, object_name, it)

    when "bizcardcompany", "bizcardorganization", "bizcardbranch", "bizcardperson"
      action = i.input_parameter.sub("bizcard","")
      return rfw_bizcard_picker_tags(i, object_name, it, action)
    end

    raise ArgumentError, "invalid extra picked name: #{i.input_parameter}"
    return false
  end

  # メール送信部品による選択の情報を返す。
  def mailto_info
    mail = params[:mail] || {}
    recipients = Person.joints(mail[:recipients])
    if recipients.size > 0
      info = select_tag "_mail_info", options_from_collection_for_select(recipients, "id", "name_with_in", 0)
    else
      info = ""
    end
    num = text_field_tag "_mail_num", recipients.size, :readonly => true, :size => 2, :class => "mail_num", :id => nil
    info << ns_("rfw|mailto_info|%{num} person", "%{num} people", recipients.size) % { :num => num }
    mail.keys.each do |key|
      info << hidden_field_tag("mail[#{key}]", mail[key], :id => nil)
    end
    return info
  end

  # DOM ベースの picker
  def rfw_mail_form(picker_id, mode)
    seed = picker_id
    tags = ''
    tags << '<img src="/images/mail.png" width=32 height=32 class="iepngfix" alt="'+s_("rfw|image|alt|mail")+'" />'
    tags << select_tag('_mail_info', '', :id => "mail_info_#{seed}", :style => 'display:none')
    tags << text_field_tag('_mail_num', 0, :readonly => true, :size => 2, :class => 'mail_num', :id => "mail_num_#{seed}")
    case mode
    when :show
      tags << submit_tag(h(s_("rfw|submit_tag|mail|Send")),
                         :id => "mail_send_#{seed}",
                         :name => "mailsend",
                         :confirm => s_('rfw|submit_tag|mail|Are you sure?'),
                         :disabled => true)
    when :edit
      # do nothing
    else
      raise "must not happen! mode:#{mode}"
    end
    if params[:mail]
      names      = params[:mail][:names]
      recipients = params[:mail][:recipients]
      field_type = params[:mail][:field_type]
      comment    = params[:mail][:comment]
      attachment = params[:mail][:attachment]
    end
    tags << rfw_picker([{
                          :type  => 'hidden',
                          :name  => 'mail[names]',
                          :value => names,
                          :key   => 'mailto_names'
                        },
                        {
                          :type  => 'hidden',
                          :name  => 'mail[recipients]',
                          :value => recipients,
                          :key   => 'mailto_ids'
                        },
                        {
                          :type  => 'hidden',
                          :name  => 'mail[field_type]',
                          :value => field_type,
                          :key   => 'mailto_type'
                        },
                        {
                          :type  => 'hidden',
                          :name  => 'mail[comment]',
                          :value => comment,
                          :key   => 'mail_comment'
                        },
                        {
                          :type  => 'hidden',
                          :name  => 'mail[attachment]',
                          :value => attachment,
                          :key   => 'mail_attachment'
                        }],
                       { :controller => 'pick/mailto', :action => 'search', :mode => 'company'},
                       h(s_('rfw|submit_tag|mail|To'))) do |link_id|
      javascript_tag(<<-JS)
        Rfw.showMailInfo.defer('#{seed}');
        $('#{link_id}').observe('click', function(e1){
          setTimeout(function(){
            $$('div.rfw_tabs_detail_#{seed}').first().observe('click', Rfw.showMailInfo.curry('#{seed}'));
          }, 1000);
        });
      JS
    end
    tags
  end

  # 詳細画面へのリンクを返す。
  def display_aspect(controller, view)
    url = {:controller => controller, :action => "show", :id => @it.id, :type => @model_class, :product_id => @product.id}
    if /\Ashow/ =~ params[:action] || request.xhr?
      javascript_tag(remote_function(:update => view, :url => url))
    else
      link = link_to_view_motion(s_(controller), view, "show", {}, url, :class => "autoload button")
      content_tag(:div, link, :class => "left_buttons")
    end
  end

  # サマリへのリンクを返す。
  def summary_aspect(controller)
    url = {:controller => controller, :action => "summary", :id => @it.id, :type => @model_class, :product_id => @product.id}
    javascript_tag(remote_function(:update => "summary_#{controller.pluralize}", :url => url))
  end

  # 関連文書を選択するためのリンクを返す。
  def link_to_select_document(it)
    return "" if @relatable && (it == @relatable || @product.document_nodes_for(@relatable).include?(it))
    link_to_remote(tree_icon_open,
                   :update => "document_table_base",
                   :complete => visual_effect(:highlight, "document_table", :queue => {:scope => "document", :limit => 2, :position => "end"}),
                   :url => {:controller => "document", :action => "select", :id => params[:id], :type => params[:type], :product_id => params[:relatable_product_id], :target_id => it.id, :target_type => it.class.to_s, :target_product_id => @product.id})
  end

  # 一覧検索(汎用検索)の設定画面へのリンクを返す。
  def link_to_search
    return "" unless @product.search?
    if @display.searching? then
      caption = h(s_("rfw|Product|Looking for"))
      serching =" searching"
    else
      caption = h(s_("rfw|Product|Search"))
      serching =""
    end
     link_to_remote(caption,
                   { :update => "view_search",
                     :url => {:controller => "search", :action => "index"},
                     :with => "'display_id=' + $F('list')",
                   },
                   {:class => "button#{serching}"})
  end

  # 一覧の設定画面へのリンクを返す。
  def link_to_list
    link_to_view_motion(h(s_("rfw|List")), "view_list", @product.id,
                        {},
                        {:controller => "list", :action => "index", :id => @product.id},
                        {:class => "button reloadable_link"})
  end

  # 画面上下に配置されるボタン群を返す。
  def button_box(suffix,*type)
    buttons = {}
    if type[0]=="new"
      buttons[:left] = link_to_close({:id => nil, "_" => suffix}, {:action => "schedule_list", :id => nil, :product_id => @menu_select_product_id}, :class => "button")
    else  
      if params[:id] && @display.button_back?
        buttons[:left] = link_to_view_motion(h(s_("rfw|button|Back")),
                                             @current_view, "show",
                                             {:id => params[:id], "_" => suffix},
                                             {:action => "show",
                                              :id => params[:id],
                                              :precede_session =>true,
                                              :product_id => @menu_select_product_id},
                                              :class => "button reloadable_link")
      elsif @display.button_close?
        buttons[:left] = link_to_close({:id => nil, "_" => suffix}, {:action => "schedule_list", :id => nil, :product_id => @menu_select_product_id}, :class => "button")
      end
    end
    buttons[:center] = ""
    if @display.button_edit? && @product.modifiable?
      buttons[:center] += link_to_view_motion(h(s_("rfw|button|Edit")),
                                              @current_view, "edit",
                                              {:id => @it.id, "_" => suffix},
                                              {:action => "edit", :id => @it,
                                               :precede_session =>true,
                                               :product_id => @menu_select_product_id },
                                               :class => "button reloadable_link")
    end
    if @display.button_copy? && @product.modifiable?
      buttons[:center] += link_to_view_motion(h(s_("rfw|button|Copy")),
                                              @current_view, "copy",
                                              {:id => @it.id, "_" => suffix},
                                              {:action => "new", :id => @it, :product_id => @menu_select_product_id },
                                              :class => "button reloadable_link")
    end
    if @submit_tag
      buttons[:center] += @submit_tag

    end
    if @display.button_delete? && @product.modifiable?
      buttons[:right] = link_to_view_motion(h(s_("rfw|button|Destroy")),
                                            @current_view, "destroy",
                                            {:id => @it.id, "_" => suffix},
                                            {:action => "destroy", :id => @it, :product_id => @menu_select_product_id },
                                            :confirm => s_('rfw|confirm|Are you sure?'),
                                            :method => :post,
                                            :class => "button reloadable_link")
    end
    return lcr_button_box(buttons)
  end
  
  # タスクの開閉操作
  def open_shut(content, it)
      display_id =@display.id
      person_id =@login_user.person_id
      unless it.children ==[]
       if it.data_type == "task"
         if it.task_open_and_shut(person_id,display_id) =="1"
            content = link_to_view_motion(image_tag("open.gif"),
                                           @current_view, @menu_id,
                                          {"_" =>"_plus_#{it.id}"},
                                          {:controller => "pjc_task",
                                           :action => "schedule_list",
                                           :product_id => @menu_select_product_id,
                                           :task_memory => @task_memories,
                                           :evm_list => @select_evm_list,
                                           :unit => @select_unit,
                                           :task_id => it.id,
                                           :task_open_and_shut => "0"},
                                           :class => "reloadable_link") + content
         else
            content = link_to_view_motion(image_tag("close.gif"),
                                           @current_view, @menu_id,
                                          {"_" =>"_minus_#{it.id}"},
                                          {:controller => "pjc_task",
                                           :action => "schedule_list",
                                           :product_id => @menu_select_product_id,
                                           :task_memory => @task_memories,
                                           :evm_list => @select_evm_list,
                                           :unit => @select_unit,
                                           :task_id => it.id ,
                                           :task_open_and_shut => "1"},
                                           :class => "reloadable_link") + content
         end
       end
      else  
          content = "&nbsp;&nbsp;&nbsp;" + content
      end    
      return content
  end
  
  # 記憶ボタン
  def link_to_memory
      link_to_view_motion(h(s_("PjcTask|Task_botton|memory")),
                                            @current_view, @menu_id,
                                            {"_"=>"memory"},
                                            {:controller => "pjc_task",
                                             :action => "schedule_list",
                                             :task_memory => @task_memories,
                                             :product_id => @menu_select_product_id,
                                             :task_memories_botton => 1},
                                             :class => "button reloadable_link")
  end
  # EVM一覧へ
  def link_to_evm_list(list,d)
     link_to_view_motion(h(s_(d)),
                          @current_view, @menu_id,
                          {},
                          {:controller => "pjc_task",
                           :action => "schedule_list",
                           :task_memory => @task_memories,
                           :product_id => @menu_select_product_id,
                           :unit => @select_unit,
                           :level => @select_level,
                           :evm_list => list},
                           :class => "button reloadable_link")
  end
  
  def link_to_framework_list(project_id,segment_id,name)
      framework_prd_id = Product.find(:first,:conditions =>["model_name =?","PjcApplyingFrameworkToTask"]).id   
       link_to_remote(h(s_(name)),
                     { :update => "view_list",
                       :url => { :controller => "pjc_applying_framework_to_task",
                                 :action => "entry_info",
                                 :product_id => framework_prd_id,
                                 :applying_project_id => project_id,
                                 :applying_segment_id => segment_id,
                                 :return_display_id => @display.id,
                                 :return_product_id => @product.id
                                 },
                     },
                     {:class => "button"})
  end
  
  
  # 日程別チャート一覧の重みと実績の切り替え
  def link_to_rate_chart_switch(list,d)
      link_to_view_motion(h(s_(d)),
                                            @current_view, @menu_id,
                                            {""=>"&switch"},
                                            {:controller => "pjc_task",
                                             :action => "schedule_list",
                                             :task_memory => @task_memories,
                                             :product_id => @menu_select_product_id,
                                             :unit => @select_unit,
                                             :level => @select_level,
                                             :rate_chart_switch => list},
                                             :class => "button reloadable_link") 
  end
  
  #日程別チャート一覧の切り替え
  def link_to_chart_switch(list,d)
      link_to_view_motion(h(s_(d)),
                                            @current_view, @menu_id,
                                            {},
                                            {:controller => "pjc_task",
                                             :action => "schedule_list",
                                             :task_memory => @task_memories,
                                             :product_id => @menu_select_product_id,
                                             :unit => @select_unit,
                                             :level => @select_level,
                                             :chart_switch => list},
                                             :class => "button reloadable_link") 
  end

  # 担当者別チャート一覧の重みと実績の切り替え
  def link_to_rate_person_chart_switch(list,d)
      link_to_view_motion(h(s_(d)),
                                            @current_view, @menu_id,
                                            {""=>"&switch"},
                                            {:controller => "pjc_task",
                                             :action => "schedule_list",
                                             :task_memory => @task_memories,
                                             :product_id => @menu_select_product_id,
                                             :unit => @select_unit,
                                             :level => @select_level,
                                             :person_rate_chart_switch => list},
                                             :class => "button reloadable_link") 
  end
  
  #担当者別チャート一覧の切り替え
  def link_to_person_chart_switch(list,d)
      link_to_view_motion(h(s_(d)),
                                            @current_view, @menu_id,
                                            {},
                                            {:controller => "pjc_task",
                                             :action => "schedule_list",
                                             :task_memory => @task_memories,
                                             :product_id => @menu_select_product_id,
                                             :unit => @select_unit,
                                             :level => @select_level,
                                             :person_chart_switch => list},
                                             :class => "button reloadable_link") 
  end  
  # 詳細画面遷移
  def link_to_task_show(it)
    link_to_view_motion image_tag("memo.png",
                                       :alt => s_("rfw|image|alt|Show")), @sub_view, "show",
                                      {:id => it.id},
                                      {:action => "show",
                                       :id => it,
                                       :precede_session =>true,
                                       :product_id => @menu_select_product_id},
                                       :class => "reloadable_link"
  end

  # 編集画面遷移
  def link_to_task_edit(it)
    link_to_view_motion "○",
                          @sub_view, "edit",
                          {:id => it.id},
                          {:action => "edit",
                           :id => it,
                           :precede_session =>true,
                           :product_id => @menu_select_product_id},
                           :style =>"text-decoration:none;"
  end
  # 履歴詳細画面遷移
  def link_to_task_record(it)
      product =Product.find(:first,:conditions =>["model_name=?","PjcTaskRecord"])
      if product 
        task_record_product_id =product.id
      else
        task_record_product_id =nil
      end
        link_to_view_motion(image_tag("memo.png", :alt => _(s_("PjcTask|Task_title|record"))), 
                                @sub_view, "record_task_#{it.id}",
                                {},
                                {:controller => "pjc_task_record",
                                 :action => "record_picker",
                                 :product_id =>task_record_product_id,
                                 :unit => @select_unit,
                                 :level => @select_level,
                                 :evm_list => @select_evm_list,
                                 :task_memory => @task_memories,
                                 :task_id => it.id},
                                 :class => "reloadable_link")                            
  end
  
  def link_to_pj_task_list(it,task_display)
      link_to_view_motion(image_tag("memo.png", :alt => _(s_("PjcTask|Task_title|show"))), 
                              @current_view, @menu_id,
                              {"_"=>"_#{it.id}"},
                              {:controller => "pjc_task",
                               :action => "schedule_list",
                               :product_id => @menu_select_product_id,
                               :pj_segment_id => it.segment_id,
                               :task_id => it.id , 
                               :list => task_display.id},
                               :class => "reloadable_link")
  end

  def task_copy_and_paste_button_box(suffix)
    buttons = {}
    buttons[:left] =link_to_task_paste_close
    buttons[:center] =link_to_task_paste
    return lcr_button_box(buttons)
  end
  
  def link_to_task_paste
      submit_tag(s_("PjcTask|Task_operation|task_paste"), :class => "button reloadable_link", :name => "paste")
  end
  
  def link_to_task_paste_close
    session[:selected_task_id] =nil
    link_to_close({:id => nil, "_" => "_paste"}, {:action => "schedule_list", :id => nil, :task_record =>false}, :class => "button reloadable_link")
  end
  # 担当者別一覧の個人情報を返す
  def task_person_data(person_id)
      task_person = Person.find(:first,:conditions =>["id =?",person_id])
      if task_person
         if organzations = task_person.organizations[0]
            return "#{organzations.company.name}/#{organzations.name}/#{task_person.name}"
         else
            return "#{task_person.name}"
         end
      end
      return "person_id is not found"
  end
  
  def task_chart_title_line
      appointed_day = Date.today
      @task_chart_colspan = 0
      if @appointed_day 
         appointed_day = @appointed_day
      else
         @appointed_day = appointed_day        
      end
      task_day = appointed_day.day
      first_day_of_this_month = appointed_day.beginning_of_month
      last_day_of_this_month = appointed_day.end_of_month
      first_day_of_next_month = appointed_day.next_month.beginning_of_month
      options = {}
      html_above = ""
      if @selected_period
         case @selected_period
         when "two_weeks"
             # 二週間が同じ月の場合
             if (last_day_of_this_month - appointed_day + 1).to_i >=14
                options[:colspan] ="14"
                content = appointed_day.month.to_s
                html_above += content_tag(:th,content,options)
                @html_follow +=days_of_follow_line(task_day.to_i, (task_day.to_i + 13), appointed_day)
             # 二週間が違う月の場合   
             else
                this_month_days = (last_day_of_this_month - appointed_day + 1)
                html_above +=content_tag(:th, appointed_day.month.to_s, :colspan => this_month_days.to_s)
                @html_follow +=days_of_follow_line(task_day.to_i, last_day_of_this_month.day.to_i, appointed_day)
                next_month_days = ((appointed_day + 14) - first_day_of_next_month) 
                html_above +=content_tag(:th ,appointed_day.next_month.month.to_s, :colspan => next_month_days.to_s)
                @html_follow +=days_of_follow_line(1, next_month_days.to_i, appointed_day.next_month)
             end
             @task_chart_colspan =14
         when "one_month"
             this_month_days = (last_day_of_this_month - appointed_day + 1)
             html_above +=content_tag(:th, appointed_day.month.to_s, :colspan => this_month_days.to_s)
             @task_chart_colspan +=this_month_days.to_i
             @html_follow +=days_of_follow_line(task_day.to_i, last_day_of_this_month.day.to_i, appointed_day)
             next_month_days = (appointed_day.next_month - first_day_of_next_month)
             if appointed_day != first_day_of_this_month 
                html_above += content_tag(:th ,appointed_day.next_month.month.to_s, :colspan => next_month_days.to_s)
                @task_chart_colspan +=next_month_days.to_i
                @html_follow +=days_of_follow_line(1, next_month_days.to_i, appointed_day.next_month)                
             end
         when "three_months"
             first_day_of_this_week = appointed_day.beginning_of_week
             first_month_weeks = how_many_mondays_in_one_month(first_day_of_this_week,first_day_of_this_week.end_of_month)
             html_above += content_tag(:th, first_day_of_this_week.month.to_s, :colspan => first_month_weeks)
             @task_chart_colspan +=first_month_weeks.to_i
             second_month_first_week = first_day_of_this_week.end_of_month.next_week            
             second_month_weeks = how_many_mondays_in_one_month(second_month_first_week,second_month_first_week.end_of_month)
             html_above += content_tag(:th, second_month_first_week.month.to_s, :colspan => second_month_weeks)
             @task_chart_colspan +=second_month_weeks.to_i
             third_month_first_week = second_month_first_week.end_of_month.next_week 
             third_month_weeks = how_many_mondays_in_one_month(third_month_first_week,third_month_first_week.end_of_month)
             html_above += content_tag(:th, third_month_first_week.month.to_s, :colspan => third_month_weeks)
             @task_chart_colspan +=third_month_weeks.to_i
             fourth_month_first_week = third_month_first_week.end_of_month.next_week                     
             fourth_month_weeks = how_many_mondays_in_one_month(fourth_month_first_week,appointed_day.months_since(3))
             html_above += content_tag(:th, fourth_month_first_week.month.to_s, :colspan => fourth_month_weeks) unless fourth_month_weeks == 0
             @task_chart_colspan +=fourth_month_weeks.to_i
             @count_of_weeks_in_three_months = first_month_weeks + second_month_weeks + third_month_weeks + fourth_month_weeks
         when "six_months"
             options_first_month ={}
             options_last_month ={}
             if appointed_day.day <=10
                  options_first_month[:colspan] ="3"
                  n = 1
             elsif appointed_day.day>10 && appointed_day.day<=20
                  options_first_month[:colspan] ="2"
                  options_last_month[:colspan] ="1"
                  n = 11
             elsif appointed_day.day >20 
                  options_first_month[:colspan] ="1"
                  options_last_month[:colspan] ="2"
                  n = 21
             end
                 # 第1月
                 html_above +=content_tag(:th, appointed_day.month.to_s, options_first_month)
                 # 第2月～第6月
             for x in [1,2,3,4,5]
                 html_above +=content_tag(:th, appointed_day.months_since(x).month.to_s,:colspan =>3)
             end
                 #第7月
             if options_last_month !={}    
                 html_above +=content_tag(:th, appointed_day.months_since(6).month.to_s,options_last_month)
             end
             #line_of_follow_line
             m = 0
             options ={}
             options[:width] = "12"
             today = Date.today
             while m < 18
                 if appointed_day.year == today.year && appointed_day.month == today.month && ((today.day-n) >=0) && ((today.day-n)<=9) 
                    options[:style] = "background-color:#28FF28;"
                 else
                    options[:style] = ""                
                 end
                 @html_follow += content_tag(:th,n,options)
                 m +=1
                 n +=10
                 if n ==31
                    n =1
                    appointed_day = appointed_day.next_month                    
                 end
             end
             @task_chart_colspan =18
         when "one_year"
              html_above = year_has_months(appointed_day, 1)
              n = appointed_day.month.to_i 
              @html_follow +=months_of_follow_line(12,n,appointed_day)
              @task_chart_colspan =12
         when "two_years"
              html_above = year_has_months(appointed_day,2)
              @task_chart_colspan =24
              n = appointed_day.month.to_i 
              @html_follow +=months_of_follow_line(24,n,appointed_day)
         when "three_years"
              n = appointed_day.month.to_i 
              @html_follow +=months_of_follow_line(36,n,appointed_day)
              html_above = year_has_months(appointed_day, 3)
              @task_chart_colspan =36
         end         
      end
      return html_above
  end
  
  def chart_of_task_list(it,type)
      html = ""
      if it      
        if type =="plan" #予定開始終了日
            if it.planned_start_date!=nil && it.planned_start_date!=""
               start_date = it.planned_start_date.to_date
            end
            if it.planned_finish_date!=nil && it.planned_finish_date!=""
               finish_date = it.planned_finish_date.to_date
            end
        elsif type =="operate" #実績開始終了日
            if it.operation_start_date!=nil && it.operation_start_date!=""
               start_date = it.operation_start_date.to_date
            end
            if it.operation_finish_date!=nil && it.operation_finish_date!=""                
               finish_date = it.operation_finish_date.to_date
            else
               finish_date = Date.today             
            end       
        end
      end     
      if @selected_period
            case @selected_period
            when "two_weeks"
                 html +=task_line_days(14,start_date,finish_date,type)
            when "one_month"
                 html +=task_line_days((@appointed_day.next_month-@appointed_day).to_i,start_date,finish_date,type)
           when "three_months"
                 @count_of_weeks_in_three_months = 14 unless @count_of_weeks_in_three_months
                 html +=task_line_weeks((@count_of_weeks_in_three_months),start_date,finish_date,type)                 
           when "six_months"
                 html +=task_line_ten_days(18,start_date,finish_date,type)
           when "one_year"
                 html +=task_line_months(12,start_date,finish_date,type)
           when "two_years"
                html +=task_line_months(24,start_date,finish_date,type)
           when "three_years" 
                html +=task_line_months(36,start_date,finish_date,type)             
           end 
      end     
      return html
  end
  
  def task_line_days(n,start_date,finish_date,type)
      html = ""
      options = {}
      m = 0
      todays_day = Date.today
      finish_date = todays_day if finish_date == nil || finish_date =="" 
      n.times do
        if start_date && (@appointed_day + m)>=start_date && (@appointed_day + m)<=finish_date
           if type =="plan"
              options[:class] ="ChartPlan"
           elsif type =="operate"
              options[:class] ="ChartResult"
           end  
        else 
           options[:class] =""
        end
        html +=content_tag(:td,"",options)
        m +=1        
      end 
      return html
  end
  
  def task_line_ten_days(n,start_date,finish_date,type)
      html = ""
      options = {}
      m = 0
      todays_day = Date.today
      finish_date = todays_day if finish_date == nil || finish_date =="" 
      # 日付変更
      if start_date
         start_date = ten_days_change(start_date)
      end
      if finish_date
         if finish_date.day <= 10
            finish_date = (finish_date.beginning_of_month + 9)
         elsif finish_date.day >10 && finish_date.day <=20
            finish_date = (finish_date.beginning_of_month + 19)
         else
            finish_date = finish_date.end_of_month
         end
      end
      d = @appointed_day
      if d
         d = ten_days_change(d) 
      end
      n.times do
        if start_date && (d + m)>=start_date && (d + m)<=finish_date
           if type =="plan"
              options[:class] ="ChartPlan"
           elsif type =="operate"
              options[:class] ="ChartResult"
           end  
        else 
           options[:class] =""
        end
        html +=content_tag(:td,"",options)
        m +=10
        if m == 30
           m = 0
           d = d.next_month
        end        
      end 
      return html
  end
  
  def task_line_weeks(n,start_date,finish_date,type)
      html = ""
      options = {}
      m = 0
      todays_day = Date.today
      finish_date = todays_day if finish_date == nil || finish_date ==""
      n.times do
        if start_date && (@appointed_day + m)>=start_date.beginning_of_week && (@appointed_day + m)<=finish_date.beginning_of_week.next_week
           if type =="plan"
              options[:class] ="ChartPlan"
           elsif type =="operate"
              options[:class] ="ChartResult"
           end  
        else 
           options[:class] =""
        end
        html +=content_tag(:td,"",options)
        m +=7        
      end
      return html
  end
  
  def task_line_months(n,start_date,finish_date,type)
      html = ""
      options = {}
      m = 0
      todays_day = Date.today
      finish_date = todays_day if finish_date == nil || finish_date ==""
      a = @appointed_day 
      n.times do
        if start_date && (@appointed_day + m)>=start_date.beginning_of_month && (@appointed_day + m)<=finish_date.end_of_month
           if type =="plan"
              options[:class] ="ChartPlan"
           elsif type =="operate"
              options[:class] ="ChartResult"
           end  
        else 
           options[:class] =""
        end
        html +=content_tag(:td,"",options)
        month_days = (a.next_month - a).to_i
        m +=month_days
        a = a.next_month
      end
      return html
  end
  
  def year_has_months(appointed_day, x)
      m = ((12 - appointed_day.month) +1).to_i
      html_above =""
      n = 0
      if m == 12
         while n < x
           html_above +=content_tag(:th, appointed_day.years_since(n).to_s,:colspan =>12)
           n +=1
         end
      else
         years = appointed_day.years_since(n).year.to_s
         years = "" if m<=3     #年の非表示     
         html_above +=content_tag(:th, years,:colspan =>m)
         while x-1 >n
           n +=1
           html_above +=content_tag(:th, appointed_day.years_since(n).year.to_s,:colspan =>12) 
         end
         years = appointed_day.years_since(x).year.to_s
         years = "" if m >=9    #年の非表示     
         html_above +=content_tag(:th, years,:colspan =>(12-m))
      end
      return html_above
  end
  
  def how_many_mondays_in_one_month(first_monday, end_day)
      mondays = 0
      options ={}
      options[:width] = "12"
      today = Date.today      
      while first_monday <=end_day 
           mondays +=1
           if first_monday.year == today.year && first_monday.month == today.month && (today.day-first_monday.day>=0) && (today.day-first_monday.day<=6)
              options[:style] = "background-color:#28FF28;"
           else
              options[:style] = ""             
           end
           @html_follow += content_tag(:th,first_monday.day,options)
           first_monday +=7
      end
      return mondays       
  end
  
  def days_of_follow_line(n, last_day, appointed_day)
      html_follow = ""
      options = {}
      options[:width] = "12"
      today = Date.today      
      while n <=last_day
         if appointed_day.year == today.year && appointed_day.month == today.month && today.day == n
            options[:style] = "background-color:#28FF28;" # 今日の色
         else 
            options[:style] = ""        
         end
         if h = Holiday.find(:first, :conditions =>["year =? and month =? and day =?",appointed_day.year,appointed_day.month,n])
            if appointed_day.year == today.year && appointed_day.month == today.month && today.day == n
              options[:style] = "color:red;background-color:#28FF28;" # 休日の色
            else
              options[:style] = "color:red;" # 休日の色              
            end
         else 
            options[:style] = "" unless options[:style]          
         end
         html_follow += content_tag(:th,n,options)
         n +=1
      end
      return html_follow      
  end
  
  def months_of_follow_line(x,n,appointed_day)
      html_follow = ""
      m = 0
      options = {}
      options[:width] = "30"
      today = Date.today   
      while m < x
         if appointed_day.year == today.year && today.month == n
            options[:style] = "background-color:#28FF28;" #今日の色
         else
            options[:style] = ""           
         end
         html_follow += content_tag(:th,n,options)
         m +=1
         n +=1
         if n >12
            n =1
            appointed_day = appointed_day.next_year
         end
      end
      return html_follow            
  end
  
  def task_date_move
      link = ""
      @appointed_day = Date.today unless @appointed_day
      @center_day = Date.today unless @center_day
      appointed_day = @appointed_day.to_date.strftime("%Y/%m/%d") 
      link +=appointed_day
      link +=link_to_date_move("<<", @appointed_day.last_month, @center_day.last_month)
      link +=link_to_date_move_center(s_("PjcTask|Task_button|starting_point_of_today"), Date.today,"start")
      link +=link_to_date_move("<", @appointed_day.yesterday,@center_day.yesterday)
      link +=s_("PjcTask|Task_button|day")
      link +=link_to_date_move(">", @appointed_day.tomorrow, @center_day.tomorrow)
      task_day = Date.today
      if @selected_period
         case @selected_period
         when "two_weeks"
              unit_of_center = task_day -7
         when "one_month"
              unit_of_center = task_day -15
         when "three_months"
              unit_of_center = task_day -46
         when "six_months"
              unit_of_center = task_day -92
         when "one_year"
              unit_of_center = task_day -183
         when "two_years"
              unit_of_center = task_day -365
         when "three_years"
              unit_of_center = task_day -548
         end
      else
         unit_of_center = task_day -7 
      end
      link +=link_to_date_move_center(s_("PjcTask|Task_button|center_point_of_today"),unit_of_center,"center")
      link +=link_to_date_move(">>", @appointed_day.next_month, @center_day.next_month)
      return  link 
  end

  def task_date_title
    link = ""
    @appointed_day = Date.today unless @appointed_day
    @center_day = Date.today unless @center_day
    appointed_day = @appointed_day.to_date.strftime("%Y/%m/%d")
    link +=appointed_day
    return link
  end

  def link_to_date_move(name, move_date ,center_day)
      link_to_view_motion(name,
                             @current_view, @menu_id,
                             {"_"=>"_#{name}"},
                             {:controller => "pjc_task",
                             :action => "schedule_list",
                             :task_memory => @task_memories,
                             :product_id => @menu_select_product_id,
                             :unit => @select_unit,
                             :level => @select_level,
                             :appointed_day => move_date,
                             :center_day => center_day},
                             :class => "button reloadable_link")  
  end
  
  def link_to_date_move_center(name, move_date,type)
      link_to_view_motion(name,
                             @current_view, @menu_id,
                             {"_"=>"_#{name}"},
                             {:controller => "pjc_task",
                             :action => "schedule_list",
                             :task_memory => @task_memories,
                             :product_id => @menu_select_product_id,
                             :unit => @select_unit,
                             :level => @select_level,
                             :appointed_day => move_date,
                             :chart_move_type =>type},
                             :class => "button reloadable_link")  
  end
  
  def ten_days_change(start_date)
      if start_date.day <= 10
         start_date = start_date.beginning_of_month
      elsif start_date.day >10 && start_date.day <=20
         start_date = (start_date.beginning_of_month + 10)
      else
         start_date = (start_date.beginning_of_month + 20)
      end
      return start_date    
  end
  
  def task_evm_data_totals
      task_evm_totals_1 = []
      task_evm_totals_2 = []
      options = []
      a ="(#{s_("PjcTask|Task_select_tag|unit_yen")})"
      # rowspan = 2 の行
      task_totals_single = [s_("PjcTask|Task_evm_data_totals|task_BAC"), s_("PjcTask|Task_evm_data_totals|task_PV"), s_("PjcTask|Task_evm_data_totals|task_EV"), s_("PjcTask|Task_evm_data_totals|task_AC")]
      # rowspan = 1 の行
      task_totals_top = [s_("PjcTask|Task_evm_data_totals|task_progress_difference"), s_("PjcTask|Task_evm_data_totals|task_cost_difference"), s_("PjcTask|Task_evm_data_totals|task_cost_prediction")]
      task_totals_bottom = ["SV", "SPI", "CV", "CPI", "ETC", "EAC", "VAC"] 
      task_totals_single.each do |s|
           task_evm_totals_1 << content_tag(:th, s_(s)+"<br>#{a}", :rowspan => "2",:align =>"center", :width =>"110")
      end
      task_totals_top.each do |t|
           if t ==s_("PjcTask|Task_evm_data_totals|task_cost_prediction") 
              options = {:colspan =>3,:align =>"center"}
           else
              options = {:colspan =>2,:align =>"center"}
           end 
           task_evm_totals_1 << content_tag(:th, s_(t), options)           
      end
      task_totals_bottom.each do |b|
           task_evm_totals_2 << content_tag(:th, b,:align =>"center")
      end
      return content_tag(:tr, task_evm_totals_1) + content_tag(:tr, task_evm_totals_2)
  end
  
  # タスク登録画面の追加ボタン
  def link_to_create_buttom
     create_buttom =submit_tag(s_("PjcTask|Submit_tag|Create"), :class => "button", :name => "create_new_task")
     return create_buttom
  end
  
  def link_to_new_list_clear
     content_tag(:input,"",{:value =>s_("PjcTask|Task_button|clear"),:type => "button",
       :onclick=>"document.getElementsByName('it[name]')[0].value =''; 
                  document.getElementsByName('it[planned_start_date]')[0].value ='';
                  document.getElementsByName('it[planned_finish_date]')[0].value ='';
                  document.getElementsByName('it[planned_scale]')[0].value ='';
                  document.getElementsByName('it[planned_man_hour]')[0].value ='';
                  document.getElementsByName('it[code]')[0].value ='';
                  document.getElementsByName('it[number_of_operating_days]')[0].value ='';
                  document.getElementsByName('it[task_weight]')[0].value ='';
                  document.getElementsByName('it[budget_at_completion]')[0].value ='';
                  document.getElementsByName('it[notes]')[0].value ='';",:class =>"button reloadable_link"})
  end
  
  # タスク登録画面の削除ボタン
  # kは上から何番名、tは全件数
  def link_to_delete_buttom(k,t)
      img = '<img src="/images/delete.png" width=16 height=16 class="iepngfix" alt="' + h(s_("rfw|button|Destroy")) + '" />'
      link_to_view_motion(img,
                               @current_view, "create",
                               {"_"=>"_task_delete_#{k}"},
                               {:controller =>"pjc_task",
                               :action =>"new",
                               :task_id =>@task_title.id,
                               :count =>t,
                               :count_all =>t})
  end

  def task_error_messages_for(*params)
    unless params[0] =="new"
      if @stale_object_error
        err_icon = image_tag("error.png")
        message = [ content_tag(:div, err_icon + s_("rfw|message|Attempted to update a stale object"), :class => "errorExplanation_head"),
                    content_tag(:div, s_("rfw|message|Someone has updated the object. Please go back to show the new version of it."), :class => "errorExplanation_detail")
                  ]
        return content_tag(:div, message.join, :class => "errorExplanation_base")
      end
      options = params.last.is_a?(Hash) ? params.pop.symbolize_keys : {}
      objects = params.collect {|object_name| instance_variable_get("@#{object_name}") }.compact
      object_names = params.dup
      count = objects.inject(0) {|sum, object| sum + object.errors.count}
      if @task_error_count
        count +=@task_error_count
      end
    else
      count =1
    end

    if count.zero?
      ''
    else
      return [
        '<div class="errorExplanation_base">',
        '<div class="errorExplanation_head">',
        image_tag("error.png"),
        ns_("rfw|message|%{num} error prohibited this data from being saved",
          "%{num} errors prohibited this data from being saved",
          count) % { :num => count },
        '</div>',
        '<div class="errorExplanation_detail">',
        ns_("rfw|message|There was a problem with the following field.",
          "There were problems with the following fields.",
          count),
        '</div>',
        '</div>',
      ].join("")
    end
  end

  def symbols_for(arr, prefix)
    return [] if arr.nil?
    arr.map{|v| "#{prefix}_#{v}".to_sym }
  end
end
