# 画面遷移と非同期にメールを送信するモデル
class AsyncMailer < ActionMailer::Base

  # メールの書式化を行う。
  def formatted_mail(mail_history, sent_at = Time.now)
    subject mail_history.subject
    from mail_history.from_value
    sent_on sent_at
    # headers
    queue = mail_history.mail_queue
    case queue.field_type
    when "cc"
      cc mail_history.recipient_value
    when "bcc"
      bcc mail_history.recipient_value
    else
      recipients mail_history.recipient_value
    end
    # body
    if queue.has_attachment?
      part :body => render_message("formatted_mail", :formatted_body => mail_history.body)
      queue.document.attachments.each do |a|
        attachment :content_type => a.file.mime_type, :body => a.file.content, :filename => a.file.name
      end
    else
      body :formatted_body => mail_history.body
    end
  end
end
