# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: binary_objects
#
#  id           :integer       not null, primary key
#  domain_id    :integer       not null
#  name         :string(255)
#  mime_type    :string(255)   default("application/octet-stream"), not null
#  content      :binary
#  length       :integer
#  created_at   :string(14)
#  updated_at   :string(14)
#  created_by   :integer
#  updated_by   :integer
#  created_in   :integer
#  updated_in   :integer
#  lock_version :integer       default(0), not null
#

# データベース上に保存するファイルのモデル。
class BinaryObject < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor

  has_many :attachments, :as => :file, :dependent => :destroy

  # 保存先を表す文字列を返す。
  def location
    s_("rfw|BinaryObject|Database")
  end

  # アップロードされたファイル <em>x</em> を保存する。
  def store(x)
    ConfigAttachment.current.validate_filename(self.name)
    self.content = x.read
    if x.is_a?(Tempfile)
      self.length = File::size(x.local_path)
    else
      self.length = self.content.size
    end
    ConfigAttachment.current.validate_length(self.length)
    return save
  end

  # 複写機能のためのコピーを返す。失敗した場合は <tt>false</tt> を返す。
  def copy
    copied = self.class.new
    copied.attributes = attributes
    return copied.save && copied
  end
end
