# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: holidays
#
#  id           :integer       not null, primary key
#  domain_id    :integer       not null
#  year         :integer       not null
#  month        :integer       not null
#  day          :integer       not null
#  ymd          :string(8)
#  created_at   :string(14)
#  updated_at   :string(14)
#  created_by   :integer
#  updated_by   :integer
#  created_in   :integer
#  updated_in   :integer
#  lock_version :integer       default(0), not null
#

# 休日情報のモデル。
class Holiday < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor

  belongs_to :domain

  validates_presence_of :year, :month, :day

  validates_year_of :year
  validates_inclusion_of :month, :in => 1..12
  validates_inclusion_of :day, :in => 1..31

  attr_protected :ymd
  before_save :sync_ymd

  def ymd=(ymd)
    raise "must not use Holiday#ymd=, update Holiday#ymd via Holiday\#{year,month,day}="
  end

  private

  def sync_ymd
    unless self.new_record?
      old = Holiday.find(self.id)
      unless old.ymd == self.ymd
        errors.add("must not use Holiday#ymd=, update Holiday#ymd via Holiday\#{year,month,day}=")
        return false
      end
    end
    write_attribute('ymd', '%04d%02d%02d' % [self.year, self.month, self.day])
    return true
  end
end
