# -*- coding: utf-8 -*-
class NarrowingByTemplate < Narrowing

  validates_presence_of :condition_template_name

  delegate :value_keys, :condition, :text, :to => :condition_template

  private

  def condition_template
    @condition_template ||= "NarrowingCondition::#{condition_template_name}".constantize.new(self)
  end

  def name
    condition_template_name
  end

end
