# == Schema Information
# Schema version: 20080822052847
#
# Table name: equipment_divisions
#
#  id           :integer(4)      not null, primary key
#  domain_id    :integer(4)      not null
#  code         :string(255)
#  name         :string(255)
#  created_at   :string(14)
#  updated_at   :string(14)
#  created_by   :integer(4)
#  updated_by   :integer(4)
#  created_in   :integer(4)
#  updated_in   :integer(4)
#  lock_version :integer(4)      default(0), not null
#

class PjcEquipmentDivision < ActiveRecord::Base
  set_table_name "equipment_divisions"

  untranslate_all
  timestamps_as_string
  user_monitor
  acts_as_permissible

  has_many :equipments, :class_name =>"PjcEquipment", :foreign_key => "equipment_division_id"

  validates_presence_of :name, :code

#start free line

#end free line
end
