# == Schema Information
# Schema version: 20080822052847
#
# Table name: personal_schedule_sets
#
#  id                           :integer(4)      not null, primary key
#  domain_id                    :integer(4)      not null
#  person_id                    :integer(4)
#  default_start_time           :string(255)
#  default_start_week           :string(255)
#  permission_duplication       :boolean(1)
#  def_group_of_gschedule_id    :integer(4)
#  def_group_of_gschedule_type  :string(255)
#  def_group_of_gwschedule_id   :integer(4)
#  def_group_of_gwschedule_type :string(255)
#  def_company_of_action        :integer(4)
#  def_organization_of_action   :integer(4)
#  created_at                   :string(14)
#  updated_at                   :string(14)
#  created_by                   :integer(4)
#  updated_by                   :integer(4)
#  created_in                   :integer(4)
#  updated_in                   :integer(4)
#  lock_version                 :integer(4)      default(0), not null
#

class PjcPersonalScheduleSet < ActiveRecord::Base
  set_table_name "personal_schedule_sets"
  untranslate_all
  timestamps_as_string
  user_monitor
  belongs_to :def_group_of_gschedule, :polymorphic => true
  belongs_to :def_group_of_gwschedule, :polymorphic => true

  belongs_to :person, :class_name => "PjcPerson", :foreign_key => "person_id"
  acts_as_permissible

#start free line

#end free line
end
