class CreateLoginHistories < ActiveRecord::Migration
  def self.up
    create_table :login_histories, :domain_id => false do |t|
      # allow domain_id is null
      t.column :domain_id, :integer, :null => true
      t.column :login, :string
      t.column :password, :string
      t.column :result, :integer, :null => false
      t.column :remote_address, :string
      t.column :program_type, :integer, :null => false
      t.column :user_id, :integer
    end
  end

  def self.down
    drop_table :login_histories
  end
end
