# 
# To change this template, choose Tools | Templates
# and open the template in the editor.
 

module ConfigOutput::PjcSegmentChecklistJudgmentList
  def output_rows(display_id, options, session_readonly)
    result = []
    if options[:conditions] && options[:conditions] != ""
      options[:conditions] += " and segment_checklist_id = #{session_readonly[:segment_checklist_id_for_judgment_csv]}"
    else
      options[:conditions] = " segment_checklist_id = #{session_readonly[:segment_checklist_id_for_judgment_csv]}"
    end
    options[:order] = "position"
    #項目の並び順を取得してselect句を組み立てる。
    selects = []
    config = ConfigOutput.find_by_display_to_list_id(display_id)
    output_items = config.config_output_items
    output_items.select(&:enabled?).each do |output_item|
      selects << output_item.item.column_name
    end
    options[:select] = "id, judgment, code, name, task_level"
    
    PjcSegmentChecklistTask.find(:all, :conditions => options[:conditions],
                                 :order => options[:order_by] || options[:order],
                                 :joins => options[:join] || options[:joins], :include => options[:include],
                                 :select => options[:select],:group => options[:group]).each do|row|
      judg_info = PjcSegmentChecklistJudgment.find(:first, :conditions=>{:segment_checklist_task_id=>row.id}, :order=>"judgment_of desc")
      if judg_info == nil || judg_info == {}
        judg_info = PjcSegmentChecklistJudgment.new
        judg_info.judgment_result = "1"
        judg_info.judgment_person_id = ""
        judg_info.judgment_of = ""
        judg_info.judgment_date = ""
        judg_info.judgment_comment = ""
      end
      cols = []
      selects.each do |col|
           case col
           when "judgment_code"
             cols << row.code
           when "judgment_name"
             cols << row.name  + "(" + s_("PjcSegmentChecklist|level") + ":" + row.task_level.to_s + ")"
           when "judgment_result"
             if row.judgment == true
               case judg_info.judgment_result
               when "1"
                 judg = s_("PjcSegmentChecklist|judgment NOT") 
               when "2"
                 judg = s_("PjcSegmentChecklist|judgment OK")
               when "3"
                 judg = s_("PjcSegmentChecklist|judgment NG")
               end
             else
               judg = ""
             end
             cols << judg
           when "judgment_person"
             if judg_info.judgment_person_id == "" || judg_info.judgment_person_id == nil
               p_name = ""
             else
               p_name = PjcPerson.find(judg_info.judgment_person_id).name
             end
             cols << p_name
           when "judgment_number"
             cols << judg_info.judgment_of
           when "judgment_date"
             if judg_info.judgment_date == nil || judg_info.judgment_date == ""
               date = ""
             else
               date = Date.parse(judg_info.judgment_date).strftime("%Y/%m/%d")
             end
             cols << date
           when "judgment_comment"
             cols << judg_info.judgment_comment
           end
        end
        result << cols
      end
    return result
  end
end
