# 
# To change this template, choose Tools | Templates
# and open the template in the editor.
 

module ConfigOutput::PjcSegmentChecklistTaskList
  def output_rows(display_id, options, session_readonly)
    result = []
    if options[:conditions] && options[:conditions] != ""
      options[:conditions] += " and segment_checklist_id = #{session_readonly[:segment_checklist_id_for_task_csv]}"
    else
      options[:conditions] = " segment_checklist_id = #{session_readonly[:segment_checklist_id_for_task_csv]}"
    end
    options[:order] = "position"
    #項目の並び順を取得してselect句を組み立てる。
    selects = []
    selects_for_sql = ""
    config = ConfigOutput.find_by_display_to_list_id(display_id)
    output_items = config.config_output_items
    output_items.select(&:enabled?).each do |output_item|
      selects_for_sql += " , " if selects_for_sql != ""
      case output_item.item.column_name
      when "task_code"
        selects << output_item.item.column_name
        selects_for_sql += "code"
      when "task_name"
        selects << output_item.item.column_name
        selects_for_sql += "name , task_level"
      when "task_judgment"
        selects << output_item.item.column_name
        selects_for_sql += "judgment"
      when "task_explanation"
        selects << output_item.item.column_name
        selects_for_sql += "explanation"
      end
    end
    
    options[:select] = selects_for_sql
    
    PjcSegmentChecklistTask.find(:all, :conditions => options[:conditions],
                                 :order => options[:order_by] || options[:order],
                                 :joins => options[:join] || options[:joins], :include => options[:include],
                                 :select => options[:select],:group => options[:group]).each do|row|
      cols = []
      selects.each do |col|
           case col
           when "task_code"
            cols << row.code
          when "task_name"
            cols << row.name  + "(" + s_("PjcSegmentChecklist|level") + ":" + row.task_level.to_s + ")"
          when "task_judgment"
            cols << row.judgment
          when "task_explanation"
            cols << row.explanation
          end
        end
        result << cols
      end
    return result
  end
end
