module ActiveRecord
  module Hates
    # ActiveRecord による SQL から IN 句を排除するためのモジュール。
    module IN
      def self.included(base)
        base.extend(ClassMethods)
        
        base.class_eval do
          class << self
            alias_method_chain :delete,            :hates_of_in
            alias_method_chain :find_some,         :hates_of_in
            alias_method_chain :sanitize_sql_hash, :hates_of_in
          end
        end
      end

      module ClassMethods
        # base.rb line 481 in rails 1.2.5
        def delete_with_hates_of_in(id)
          key = connection.quote_column_name(primary_key)
          if id.is_a?(Array)
            unless id.empty?
              sql = id.map {|x| "#{key} = ?"}.join(" OR ")
              id.unshift("(#{sql})")
              delete_all(id)
            end
          else
            delete_all(["#{key} = ?", id])
          end
        end

        # base.rb line 1035 in rails 1.2.5
        def find_some_with_hates_of_in(ids, options)
          conditions = " AND (#{sanitize_sql(options[:conditions])})" if options[:conditions]
          key = connection.quote_column_name(primary_key)
          pk = columns_hash[primary_key]
          if ids.empty?
            options.update :conditions => "(0 = 1)#{conditions}"
          else
            sql = ids.map {|id| "#{table_name}.#{key} = #{quote_value(id, pk)}"}.join(" OR ")
            options.update :conditions => "(#{sql})#{conditions}"
          end
          result = find_every(options)
          if result.size == ids.size
            result
          else
            raise RecordNotFound, "Couldn't find all #{name.pluralize} with IDs (#{ids_list})#{conditions}"
          end
        end

        # base.rb line 1268 in rails 1.2.5
        #def attribute_condition(argument)
        #end

        # base.rb line 1403 in rails 1.2.5
        def sanitize_sql_hash_with_hates_of_in(attrs)
          conditions = attrs.map do |attr, value|
            if value.is_a?(Array)
              if value.empty?
                "(0 = 1)"
              else
                key = connection.quote_column_name(attr)
                sql = value.map {|v| "#{table_name}.#{key} #{attribute_condition(v)}"}.join(" OR ")
                "(#{sql})"
              end
            else
              "#{table_name}.#{connection.quote_column_name(attr)} #{attribute_condition(value)}"
            end
          end.join(' AND ')
          replace_bind_variables(conditions, expand_range_bind_variables(attrs.values.flatten))
        end
      end
    end
  end
end

ActiveRecord::Base.class_eval do
  include ActiveRecord::Hates::IN
end
