# -*- coding: utf-8 -*-
module NarrowingCondition
  class Project
    include GetText

    bindtextdomain("database")

    attr_accessor :narrowing

    def initialize(narrowing)
      @narrowing = narrowing
    end

    # シンボルの配列を返す。
    def value_keys
      [:project_id, :project_segment_id]
    end

    def text(values)
      project_id = values[:project_id]
      return nil if project_id.blank?
      ::Project.find(project_id).to_text
    rescue ActiveRecord::RecordNotFound
      nil
    end

    def condition(table_name, column_name)
      project_id = Narrowing.current(narrowing, :project_id)
      project_id.blank? ? nil : "#{table_name}.#{column_name} = #{::Project.quote_value(project_id)}"
    end

  end
end
