require "action_mailer"
# see http://wiki.rubyonrails.org/rails/pages/PopBeforeSMTPForActionMailer

# usage:
#   ActionMailer::Base.delivery_method = :smtp
#   ActionMailer::Base.smtp_settings = {
#       :port => 25,
#       :domain => 'example.com',
#       :address => 'smtp.example.com',
#     :pop3_auth => {
#         :server => 'pop.example.com',
#         :user_name => 'user',
#         :password => 'password',
#         :authentication => :login,
#         :expires => 3.minutes,
#     },
#   }
#   require "pop_before_smtp"

# POP before SMTP を設定する。
if ActionMailer::Base.delivery_method == :smtp and ActionMailer::Base.smtp_settings.has_key?(:pop3_auth)
  class ActionMailer::Base

    alias_method :base_perform_delivery_smtp, :perform_delivery_smtp

    @@pop3_auth_done = Time.at(0)

    private

    def perform_delivery_smtp(mail)
      do_pop_auth if Time.now - smtp_settings[:pop3_auth][:expires] >= @@pop3_auth_done
      base_perform_delivery_smtp(mail)
    end

    def do_pop_auth
      require 'net/pop'
      pop = Net::POP3.new(smtp_settings[:pop3_auth][:server])
      pop.start(smtp_settings[:pop3_auth][:user_name], smtp_settings[:pop3_auth][:password])
      @@pop3_auth_done = Time.now
      pop.finish
    end
  end
end
