# -*- coding: utf-8 -*-

module Rfw
  module GrantData
    def self.create(login)
      raise ArgumentError, "Please specify a proper login" if login.blank?
      ActiveRecord::Base.transaction do
        u = User.find(:first, :conditions => { :login => login })
        raise ArgumentError, "user of login #{login.inspect} not found" unless u
        User.current = u
        records = GrantDataInformation.find(:all,
                                            :conditions => {
                                              :generated_product_id => nil})
        records.each do |record|
          t = record.target_product
          message = PoMessageSingular.new(:msgctxt => 'rfw|GrantData|ProductName|',
                                          :msgid   => t.name)
          message.save!
          product = ProductDetailedForGrantData.new(:code       => "GRANT_DATA_#{t.id}",
                                                    :name_po    => message.id,
                                                    :model_name => t.model_name,
                                                    :table_name => t.table_name,
                                                    :detail_model_name => 'GrantOnWithoutPeriodic',
                                                    :detail_table_name => 'grant_ons')
          product.save!
          record.update_attributes!(:generated_product_id => product.id)
          labels = Rfw::GrantData.create_or_find_labels()
          product.displays.each do |display|
            case display
            when DisplayToShow
              # detail の Item を作成
              [
               ['roleable_type', '',     1, labels[0]],
               ['roleable',      'name', 2, labels[1]],
               ['value',         '',     3, labels[2]],
               ['inception',     '',     4, labels[3]],
               ['expiry',        '',     5, labels[4]],
              ].each do |v|
                if v[0] == 'roleable'
                  item_klass = ItemPolymorphic
                else
                  item_klass = ItemProper
                end
                item_klass.create!(:code => "GRANT_DATA_SHOW_#{t.id}_#{v[2]}",
                                   :display_id => display.id,
                                   :name_po => v[3],
                                   :linked => false,
                                   :control => 'permission',
                                   :model_name => 'GrantOnWithoutPeriodic',
                                   :column_name => v[0],
                                   :method_chain => v[1],
                                   :layout => v[2],
                                   :position => v[2])
              end
              # データ権限を追加するプロダクトに擬似項目を追加
              d = record.target_display
              i = ItemPseudo.create!(:code => "GRANT_DATA_SHOW_#{t.id}_6",
                                     :display_id => d.id,
                                     :name_po => labels[5],
                                     :adapter_name => 'GrantData',
                                     :decorator => 'raw',
                                     :linked => false,
                                     :control => 'permission',
                                     :model_name => t.model_name,
                                     :column_name => '',
                                     :method_chain => '',
                                     :align => 'center',
                                     :layout => record.layout || (d.items.map(&:layout).max || 0) + 1,
                                     :position => (d.items.map(&:position).max || 0) + 1)
              record.update_attributes!(:generated_item_pseudo_id => i.id)
              display.update_attributes!(:button_copy => false, :button_delete => false)
              Rfw::GrantData.update_items(d, display)
            when DisplayToEdit
              [
               ['roleable',  'name', 2, labels[1], 'picker', 'lump', 20],
               ['value',     '',     3, labels[2], 'select', 'input_option(grant_type)', nil],
               ['inception', '',     4, labels[3], 'picker', 'calendar(yyyymmdd, true)', 10],
               ['expiry',    '',     5, labels[4], 'picker', 'calendar(yyyymmdd, true)', 10],
              ].each do |v|
                if v[0] == 'roleable'
                  item_klass = ItemPolymorphic
                else
                  item_klass = ItemProper
                end
                item_klass.create!(:code => "GRANT_DATA_EDIT_#{t.id}_#{v[2]}",
                                   :display_id => display.id,
                                   :name_po => v[3],
                                   :linked => false,
                                   :control => 'permission',
                                   :model_name => 'GrantOnWithoutPeriodic',
                                   :column_name => v[0],
                                   :method_chain => v[1],
                                   :layout => v[2],
                                   :position => v[2],
                                   :input_type => v[4],
                                   :input_parameter => v[5],
                                   :field_size => v[6])
              end
              Rfw::GrantData.update_items(record.target_display, display, true)
            end
          end
        end
      end
      'success'
    end

    def self.drop(login)
      ActiveRecord::Base.transaction do
        u = User.find(:first, :conditions => { :login => login })
        User.current = u
        records = GrantDataInformation.find(:all,
                                            :conditions => ["generated_product_id IS NOT NULL"])
        ids = records.map(&:generated_product_id)
        Product.destroy(ids)
        ids = records.map(&:generated_item_pseudo_id)
        Item.destroy(ids)
        records.each do |record|
          record.update_attributes!(:generated_product_id => nil,
                                    :generated_item_pseudo_id => nil)
        end
      end
      'success'
    end

    def self.create_or_find_labels
      m = PoMessageSingular.find(:all,
                                 :conditions => {
                                   :msgctxt => 'rfw|Grant|label|'
                                 },
                                 :order => 'id')
      if m.blank?
        [
         'Type of grant target',
         'name of grant target',
         'grant type',
         'inception',
         'expiry',
         'grant data'
        ].each do |v|
          PoMessageSingular.create!(:msgctxt => 'rfw|Grant|label|',
                                    :msgid   => v)
        end
        m = PoMessageSingular.find(:all,
                                   :conditions => {
                                     :msgctxt => 'rfw|Grant|label|'
                                   },
                                   :order => 'id')
        m.map(&:id)
      else
        m.map(&:id)
      end
    end

    # callback で自動的に作成された ItemProper を更新
    # 元となる Display と同じ項目を同じような見た目で表示するため
    def self.update_items(src_display, display, write_protected = false)
      display.items.select{|item|
        src_display.model_class == item.model_class
      }.each do |item|
        src_item = src_display.items.detect{|v| v.column_name == item.column_name }
        attributes = nil
        if src_item
          attributes = {
            :name_po             => src_item.name_po,
            :method_chain        => src_item.method_chain,
            :layout              => src_item.layout,
            :position            => src_item.position,
            :align               => src_item.align,
            :decorator           => src_item.decorator,
            :decorator_parameter => src_item.decorator_parameter,
            :control             => src_item.control,
            :input_type          => src_item.input_type,
            :field_size          => src_item.field_size,
            :input_parameter     => src_item.input_parameter,
            :write_protected     => write_protected
          }
        else
          attributes = {
            :layout => 0
          }
        end
        item.update_attributes!(attributes)
      end
    end
  end
end
