# app/controllers/binary_object_controller.rb のクラス BinaryObjectController をテストする。

require File.dirname(__FILE__) + '/../test_helper'
require 'binary_object_controller'

# Re-raise errors caught by the controller.
class BinaryObjectController; def rescue_action(e) raise e end; end

class BinaryObjectControllerTest < Test::Unit::TestCase
  def setup
    @controller = BinaryObjectController.new
    @request    = ActionController::TestRequest.new
    @response   = ActionController::TestResponse.new

    # set logged in
    @request.session[:user_id] = User.find_by_login("tesla")
  end

  # BinaryObjectController#download に不適切なパラメータが与えられた場合に、
  # 404エラーを返すことをテストする。
  def test_download_404
    get "download"
    assert_response 404
  end

  # BinaryObjectController#download に適切なパラメータが与えられた場合に、
  # 対応する content type とともに出力されることをテストする。
  def test_download_success
    get "download", :id => 1
    assert_response :success
    assert_equal "text/plain", @response.content_type
  end
end
