# -*- conding: utf-8 -*-
require File.dirname(__FILE__) + '/../test_helper'

class RetrievalDivisionControllerTest < ActionController::TestCase

  fixtures :retrieval_divisions

  def setup
    @request.session[:user_id] = User.find_by_login("tesla")
  end

  # rfw パラメータなしで list を呼ぶとエラーになる。
  def test_list__without_rfw
    assert_raise(ApplicationController::ClientError) do
      post :list, :retrieval_division => 1
    end
  end

  # retrieval_division をパラメータで与えないで呼ぶとエラーになる。
  def test_list__without_retrieval_division
    assert_raise(ApplicationController::ClientError) do
      post :list, :rfw => {:name => "xyz"}
    end
  end

  # 一覧を表示する。
  def test_list__success
    post :list, :rfw => {:name => "xyz"}, :retrieval_division => 1
    assert_response :success
    assert_template "list"
    assert_select "table.result>tr.retrieval_division", :count => 2
  end

end
