# 編集画面/更新画面の記録をテストする。

require File.dirname(__FILE__) + '/../test_helper'
require "display_monitor"

class DisplayMonitorTest < ActionController::IntegrationTest
  include Session
  self.use_transactional_fixtures = false

  def setup
    Display.current = nil
  end

  def teardown
    Display.current = nil
  end

  # 通常の権限をもつ利用者がログイン後に画面から操作によって
  # 正常にデータベースを更新できることをテストする。
  def test_successfully_created_in
    no_such = {
      :code => "no_such",
      :name => "niamod",
      :lock_version => 0,
    }
    demo = login "demo", "atest"
    demo.create_demo(no_such)
    demo.assert_equal 9993, MatterReport.find_by_code(no_such[:code]).attributes["created_in"]
  end

  # 管理者の権限をもつ利用者がログイン後に画面から操作によって
  # 正常にデータベースを更新できることをテストする。
  def test_successfully_created_but
    foo = {
      :code => "foo_bar_baz",
      :name_po => 0,
      :type => "ProductSingle",
      :model_name => "Company",
    }
    admin = login "admin", "atest"
    admin.create_product(foo)
    admin.assert_nil Product.find_by_code(foo[:code]).attributes["created_in"]
  end
end
