# -*- coding: utf-8 -*-
require 'test_helper'

class DisplayNarrowingTest < ActiveSupport::TestCase

  fixtures :display_narrowings, :narrowings

  def test_private_copy
    original = display_narrowings(:matter_for_9994)
    copied = original.private_copy(1234321)
    %w|domain_id narrowing_id column_name position|.each do |k|
      assert_equal original.__send__(k), copied.__send__(k)
    end
    assert_equal 1234321, copied.display_id
  end

  def test_name
    x = display_narrowings(:matter_for_9994)
    assert_equal "Matter", x.name
    y = display_narrowings(:retrieval_divisions_for_103)
    assert_equal "ProjectRetrievalDivision", y.name
  end
end
