# -*- coding: utf-8 -*-
# app/models/language.rb のクラス Language をテストする。

require 'test_helper'

class LanguageTest < ActiveSupport::TestCase
  fixtures :languages

  # Language.to_h が適切なハッシュを返すことをテストする。
  def test_to_h
    hash = {
      1 => 'ja',
      2 => 'zh',
      3 => 'ko',
      4 => 'en',
      5 => 'fr',
      6 => 'es',
      7 => 'ar',
      8 => 'pt',
      9 => 'de',
      10 => 'ru',
    }
    assert_equal hash, Language.to_h
  end

  # The following will succeed in 'ruby test/unit/language_test.rb'
  # however 'rake' fails.
#   # Language#name_ が言語の翻訳された名前を返すことをテストする。
#   def test_name_
#     Language.all.each do |lang|
#       if lang.code == 'ja'
#         assert_equal "日本語", languages(:one).name_('ja')
#       else
#         assert_equal "Japanese", languages(:one).name_(lang.code)
#       end
#     end
#   end

  # Language.default_code が既定の言語のコードを返すことをテストする。
  def test_default_code
    assert_equal "ja", Language.default_code
  end

  # 言語のテーブルが空になっている状態にあるときには default_code が特定のエラーで報告することをテストする。
  def test_default_code__error
    Language.destroy_all
    assert_raise(Language::LanguageNotFound) do
      Language.default_code
    end
  end
end
