# -*- coding: utf-8 -*-
# app/models/portlettable_group.rb のクラス PortlettableGroup をテストする。

require 'test_helper'

class PortlettableGroupTest < ActiveSupport::TestCase
  fixtures :portlettable_groups, :portlettable_members

  def setup
    CacheEachRequest.clear
    User.current = User.find_by_login("tesla")
  end

  def teardown
    CacheEachRequest.clear
  end

  FIT = [
    [1, "S", true],
    [2, "S", false],
    [3, "S", false],
    [4, "S", false],
    [1, "M", true],
    [2, "M", false],
    [3, "M", false],
    [4, "M", false],
    [1, "L", true],
    [2, "L", true],
    [3, "L", true],
    [4, "L", true],
  ]

  # Portalet#fit? が適切なサイズを判定することをテストする。
  def test_fit?
    FIT.each do |id, s, expected|
      assert_equal expected, PortlettableGroup.find(id).fit?(s)
    end
  end
end
