# -*- coding: utf-8 -*-
# lib/simple_cell.rb のクラス SimpleCell をテストする。

require 'test_helper'

class SimpleCellTest < ActiveSupport::TestCase

  DATA = [
    "",
    "あいうえお",
    "あいうえ\nお",
    "あいうえ\rお",
    "\r\nあいうえお",
    "あ\r\r\n\rお",
    "48\n倍速対応",
    "インクジェット\r\nプリンタ対応",
    "3\r\n\n\r\n",
    "3\r\r\r",
  ]

  TEXT = [
    "",
    "あいうえお",
    "あいうえ\nお",
    "あいうえ\nお",
    "\nあいうえお",
    "あ\n\n\nお",
    "48\n倍速対応",
    "インクジェット\nプリンタ対応",
    "3\n\n\n",
    "3\n\n\n",
  ]

  EACH_LINE = [
    [],
    ["あいうえお"],
    ["あいうえ", "お"],
    ["あいうえ", "お"],
    ["", "あいうえお"],
    ["あ", "", "", "お"],
    ["48", "倍速対応"],
    ["インクジェット", "プリンタ対応"],
    ["3", "", "", ""],
    ["3", "", "", ""],
  ]

  # SimpleCell#text がセルに格納される文字列を返すことをテストする。
  def test_text
    DATA.zip(TEXT, EACH_LINE).each do |text, expected, expected_as_array|
      cell = SimpleCell.new(text)
      assert_equal expected, cell.text
      assert_equal expected_as_array, cell.text(:array => true)
    end
  end

  def test_style
  end

  def test_link
  end

  LINE_NUM = [
    0,
    1,
    2,
    2,
    2,
    4,
    2,
    2,
    4,
    4,
  ]

  # SimpleCell#line_num がセルに格納される行数を返すことをテストする。
  def test_line_num
    DATA.zip(LINE_NUM).each do |text, expected|
      cell = SimpleCell.new(text)
      assert_equal expected, cell.line_num
    end
  end

  # SimpleCell#each_line がセルに格納される行ごとに動作することをテストする。
  def test_each_line
    DATA.zip(EACH_LINE).each do |text, expected|
      cell = SimpleCell.new(text)
      result = []
      cell.each_line {|x| result << x}
      assert_equal expected, result
    end
  end

  # SimpleCell#text= によるセルへの文字列の格納をテストする。
  def test_text=
      DATA.reverse.zip(DATA, TEXT).each do |text, another, expected|
      cell = SimpleCell.new(text)
      cell.text = another
      assert_equal expected, cell.text
    end
  end
end
