# サーバ上に保存する添付ファイルを制御する。
class StorageObjectController < ApplicationController
  # 添付ファイルをダウンロードする。
  def download
    begin
      storage_object = StorageObject.find(params[:id])
    rescue ActiveRecord::RecordNotFound
      raise NotFoundException, "storage object not found: #{params[:id]}"
    end
    begin
      send_file(storage_object.path, :type => storage_object.mime_type, :filename => filename_to_download(storage_object.name))
    rescue => e
      logger.error(e.inspect)
      render :nothing => true
    end
  end
end
