# -*- coding: utf-8 -*-
# 選択部品の helper を与える。
module BusinessCardHelper
  # 選択画面のボタン群を返す。
  def business_card_button_box
    @business_card_button_box ||= lcr_button_box({
        :left => link_to_close({"_" => "&suffix;"}, @return_to_url, :class => "button"),
        :center => link_to_view_motion(s_("rfw|button|Clear"),
          @current_view, "clear", {"_"=>"&suffix;"},
          @pass_params_link.merge({:action => "pick", :return_value => ""}), :class => "button"),
      }, "w_lcr_button_box_half")
    return @business_card_button_box
  end

  # 企業の選択肢リンク一覧を返す。
  def business_card_company_list_leaf(model_name, records, options={})
    contents = []
    contents << content_tag(:tr, content_tag(:th, s_("PjcBusinessCard|Company Name")))
    unless records.blank?
      key = "#{model_name}_id".to_sym
      contents << records.map do |record|
        li_leaf_link(model_name, record, options.merge(:action => "pick", key => record.id))
      end
    end
    return '<table class="picker_list">' + contents.join("") + '</table>'
  end

  # 一件分のリンクを返す
  def li_leaf_link(model_name, record, options)
    link_tag = link_to_view_motion(h(record.name_with_in),
        @current_view, "#{model_name}#{record.id}", {},
        @pass_params_link.merge(options), :class => "pick")
#    return content_tag(:li, link_tag)
    return content_tag(:tr, content_tag(:td, link_tag), :class=>cycle("even", "odd"))
  end

  # 企業／組織選択肢のリンク一覧をTable形式で返す。
  def business_card_organization_table_leaf(model_name, records, options={})
    tr_tags = []
    index = 1
    model_name_common = model_name.sub(/_{1}[a-z]*\Z/, "")

    unless records.blank?
      company_key = "#{model_name_common}_company_id".to_sym
      @params_base = @pass_params_link.merge(options.merge(:action => "pick"))

      records.each do |record|
        @record_params = @params_base.merge(company_key => record.id)
        unless record.pjc_business_card_orgs.blank?
          record.pjc_business_card_orgs.each do |detail|
            organization_key = "#{model_name_common}_org_id".to_sym
            @detail_params = @record_params.merge(organization_key => detail.id)
            td_tags = []

            link_tag = link_to_view_motion(h(record.name_with_in),
                @current_view, "#{model_name}#{index}__company", {},
                @detail_params, :class => "pick")
            td_tags << content_tag(:td, link_tag)

            link_tag = link_to_view_motion(h(detail.name_with_in),
                @current_view, "#{model_name}#{index}__organization", {},
                @detail_params, :class => "pick")
            td_tags << content_tag(:td, link_tag)
            tr_tags << content_tag(:tr, td_tags.join, :class=>cycle("even", "odd"))
            index += 1
          end
#        else
#          link_tag = link_to_view_motion(h(record.name_with_in),
#              @current_view, "#{model_name}#{index}__company", {},
#              @record_params, :class => "pick")
#          td_tags = []
#          td_tags << content_tag(:td, link_tag)
#          td_tags << content_tag(:td, "&nbsp;")
#          tr_tags << content_tag(:tr, td_tags.join, :class => "pick")
#          index += 1
        end
      end
    end

    tr_tags.unshift(content_tag(:tr, [s_("PjcBusinessCardCompany|Name"), s_("PjcBusinessCardOrg|Name")].map {|x| content_tag(:th, h(x))}.join))
    return content_tag(:table, tr_tags.join, :class => "picker_list", :border => 1)
  end

  # 企業／支店選択肢のリンク一覧をTable形式で返す。
  def business_card_branch_table_leaf(model_name, records, options={})
    tr_tags = []
    index = 1
    model_name_common = model_name.sub(/_{1}[a-z]*\Z/, "")
    
    unless records.blank?
      company_key = "#{model_name_common}_company_id".to_sym
      @params_base = @pass_params_link.merge(options.merge(:action => "pick"))

      records.each do |record|
        @record_params = @params_base.merge(company_key => record.id)
        unless record.details.blank?
          record.details.each do |detail|
            branch_key = "#{model_name_common}_branch_id".to_sym
            @detail_params = @record_params.merge(branch_key => detail.id)
            td_tags = []
            
            link_tag = link_to_view_motion(h(record.name_with_in),
                @current_view, "#{model_name}#{index}__company", {},
                @detail_params, :class => "pick")
            td_tags << content_tag(:td, link_tag)
            
            link_tag = link_to_view_motion(h(detail.name_with_in),
                @current_view, "#{model_name}#{index}__branch", {},
                @detail_params, :class => "pick")
            td_tags << content_tag(:td, link_tag)
            tr_tags << content_tag(:tr, td_tags.join, :class => "pick", :class=>cycle("even", "odd"))
            index += 1
          end
        else
          link_tag = link_to_view_motion(h(record.name_with_in),
              @current_view, "#{model_name}#{index}__company", {},
              @record_params, :class => "pick")
          td_tags = []
          td_tags << content_tag(:td, link_tag)
          td_tags << content_tag(:td, "&nbsp;")
          tr_tags << content_tag(:tr, td_tags.join, :class => "pick", :class=>cycle("even", "odd"))
          index += 1
        end
      end
    end

    tr_tags.unshift(content_tag(:tr, [s_("PjcBusinessCardCompany|Name"), s_("PjcBusinessCardBranch|Name")].map {|x| content_tag(:th, h(x))}.join))
    return content_tag(:table, tr_tags.join, :class => "picker_list")
  end

  # 選択肢の集合に対するリンク一覧を返す。
  def business_card_company_select_list(model_name, records)
    contents = []
    contents << content_tag(:tr, content_tag(:th, s_("PjcBusinessCard|Company Name")))
    unless records.blank?
      if params[:list_condition]
        temp = params[:list_condition].split("=")
        if temp[0] == "company_id"
          records.delete_if {|x| x.id.to_s != temp[1]}
        end
      end

      key = "#{model_name}_id".to_sym
      selected_id = params[key]
      action = params[:action]
      contents << records.map do |it|
        li_select_link(model_name, it, selected_id, :action => action, key => it.id)
      end
    end
    return '<table class="picker_list">' + contents.join("") + '</table>'
  end

  # 一件分の選択肢に対するリンクを返す。
  def li_select_link(model_name, it, selected_id, options)
    if it.id.to_s == selected_id.to_s
      css_class = "selected_company"
      name = '<span class="selected">' + h(it.name_with_in) + '</span>'
    else
      css_class = ""
      name = h(it.name_with_in)
    end
    options[:list_condition] = params[:list_condition] unless params[:list_condition].blank?
    return [
      "<tr class=\"#{cycle("even", "odd")}\">",
      "<td>",
      link_to_view_motion(name,
        @current_view, "#{model_name}#{it.id}", {},
        @pass_params_link.merge(options), :class => css_class),
     "</td>",
      "</tr>"
    ].join(" ")
  end

  # 選択肢のリンクの一覧を返す。
  def business_card_person_list_leaf(model_name, records, options={})
    contents = []
    contents << content_tag(:tr, content_tag(:th, s_("PjcBusinessCard|Person Name")))
    unless records.blank?
      key = "#{model_name}_id".to_sym
      contents << records.map do |record|
        li_person_company_leaf_link(model_name, record, options.merge(:action => "pick", key => record.id))
      end
    end
    return '<table class="picker_list">' + contents.join("") + '</table>'
  end

  # 選択肢「個人名（企業名）」のリンクを返す。
  def li_person_company_leaf_link(model_name, record, options)
    link_tag = link_to_view_motion("#{h(record.name_with_in)}（#{h(record.company.name_with_in)}）",
        @current_view, "#{model_name}#{record.id}", {},
        @pass_params_link.merge(options), :class => "pick")
    return content_tag(:tr, content_tag(:td, link_tag), :class=>cycle("even", "odd"))
  end

end
