# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: document_paths
#
#  id               :integer       not null, primary key
#  domain_id        :integer       not null
#  document_id      :integer       not null
#  document_edge_id :integer       not null
#  created_at       :string(14)
#  updated_at       :string(14)
#  created_by       :integer
#  updated_by       :integer
#  created_in       :integer
#  updated_in       :integer
#  lock_version     :integer       default(0), not null
#

# 関連文書の関連付けを管理するモデル。
class DocumentPath < ActiveRecord::Base
  untranslate_all

  belongs_to :domain
  belongs_to :document
  belongs_to :document_edge
  before_destroy 'document_edge.destroy if document_edge'
end
