# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: grant_ons
#
#  id                     :integer       not null, primary key
#  domain_id              :integer       not null
#  value                  :string(255)   not null
#  inception              :string(8)     not null
#  expiry                 :string(8)     not null
#  position               :integer
#  created_at             :string(14)
#  updated_at             :string(14)
#  created_by             :integer
#  updated_by             :integer
#  created_in             :integer
#  updated_in             :integer
#  lock_version           :integer       default(0), not null
#  grant_targettable_id   :integer
#  grant_targettable_type :string(255)
#  roleable_id            :integer
#  roleable_type          :string(255)
#

# 権限の設定のモデル
class GrantOn < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor
  acts_as_periodic
  belongs_to :roleable, :polymorphic => true
  belongs_to :grant_targettable, :polymorphic => true
  has_many :permissions

  validates_presence_of :grant_targettable_id, :grant_targettable_type

  before_save :restrict_period
  after_create PermissionObserver.new
  after_update PermissionObserver.new
  after_destroy PermissionObserver.new

  private

  def restrict_period
    if roleable.respond_to?(:inception) && roleable.respond_to?(:expiry)
      if inception < roleable.attributes["inception"]
        self.inception = roleable.attributes["inception"]
      end
      if roleable.attributes["expiry"] < expiry
        self.expiry = roleable.attributes["expiry"]
      end
    end
  end
end
