class PjcProject < ActiveRecord::Base
  set_table_name "projects"
  untranslate_all
  timestamps_as_string
  user_monitor

  has_many :segments, :class_name => "PjcProjectSegment", :foreign_key => "project_id", :dependent => :destroy
  has_many :pjc_pj_input_option_categories, :class_name =>"PjcPjInputOptionCategory",:foreign_key => "project_id",:dependent => :destroy
  has_many :pjc_project_troubles, :class_name =>"PjcProjectTrouble", :foreign_key => "project_id", :dependent => :destroy
  has_many :pjc_project_test_reports, :class_name =>"PjcProjectTestReport", :foreign_key => "project_id", :dependent => :destroy
  has_many :pjc_project_segments, :class_name =>"PjcProjectSegment", :foreign_key => "project_id", :dependent => :destroy
  has_many :pjc_project_reviews, :class_name =>"PjcProjectReview", :foreign_key => "project_id", :dependent => :destroy
  has_many :pjc_project_reports, :class_name =>"PjcProjectReport", :foreign_key => "project_id", :dependent => :destroy
  has_many :pjc_project_questions, :class_name =>"PjcProjectQuestion", :foreign_key => "project_id", :dependent => :destroy
  has_many :pjc_project_problems, :class_name =>"PjcProjectProblem", :foreign_key => "project_id", :dependent => :destroy
  has_many :pjc_project_design_changes, :class_name =>"PjcProjectDesignChange", :foreign_key => "project_id", :dependent => :destroy
  has_many :pjc_lend_expenses_details, :class_name =>"PjcLendExpensesDetail", :foreign_key => "project_id", :dependent => :nullify
  has_many :pjc_carfare_details, :class_name =>"PjcCarfareDetail", :foreign_key => "project_id", :dependent => :nullify
  has_many :pjc_tasks, :class_name =>"PjcTask", :foreign_key => "project_id", :dependent => :destroy
  has_many :details, :class_name =>"PjcProjectMember", :foreign_key => "project_id", :dependent => :destroy
  
  acts_as_permissible
  after_create :initialize_task_project_root

#start free line
  def to_text
    "#{code} #{name}"
  end

  private

  def initialize_task_project_root
    PjcTask.create(:domain_id => self.domain_id,
                   :project_id =>self.id,
                   :lft =>0,:rgt =>0,
                   :task_level =>0,
                   :data_type =>"project")
  end

#end free line
end
