# 
# To change this template, choose Tools | Templates
# and open the template in the editor.
 

class PjcSegmentApplyFramework < ActiveRecord::Base
  set_table_name "segment_apply_frameworks"
  
  belongs_to :project, :class_name => "PjcProject", :foreign_key => "project_id"
  belongs_to :segment, :class_name => "PjcProjectSegment", :foreign_key => "segment_id"
  belongs_to :apply_framework , :class_name => "PjcFramework", :foreign_key => "apply_framework_id"
  
  acts_as_permissible :parent => "segment"
  #start free line
  def project_code
    if project
      project.code
    end
  end
  
  def project_name
    if project
      project.name
    end
  end
  
  def segment_name
    if segment
      segment.name
    end
  end
  def apply_framework_names
    names = []
    PjcSegmentApplyFramework.find(:all ,
                                  :include => ["apply_framework"] ,
                                  :conditions => {:domain_id => domain_id , :segment_id => segment_id},
                                  :order=>"frameworks.code").each do |app|
                                    if app.apply_framework
                                      names << app.apply_framework.name
                                    end
                                  end
    
    return names
  end
  #end free line
end
