# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: portlets
#
#  id                :integer       not null, primary key
#  domain_id         :integer       not null
#  portal_id         :integer       not null
#  pane_id           :integer       not null
#  position          :integer
#  portlettable_id   :integer       not null
#  portlettable_type :string(255)   not null
#  created_at        :string(14)
#  updated_at        :string(14)
#  created_by        :integer
#  updated_by        :integer
#  created_in        :integer
#  updated_in        :integer
#  lock_version      :integer       default(0), not null
#

# ポートレットのモデル。
class Portlet < ActiveRecord::Base
  include PortlettableDelegator

  untranslate_all
  timestamps_as_string
  user_monitor
  belongs_to :portal
  belongs_to :pane
  acts_as_list :scope => :pane
  has_many :portlet_configs, :dependent => :destroy
  
  validates_uniqueness_of :portlettable_id, :scope => [:portlettable_type, :portal_id]

  after_create :update_cell
  after_update :update_cell

  # 対応する位置にある cell を返す。
  def cell
    @cell ||= Cell.find_or_initialize_by_pane_id_and_position(pane_id, position)
  end

  # インスタンスを破壊する。
  def destroy
    cell.destroy unless cell.new_record?
    super
  end

  private

  def update_cell
    cell.save
  end
end
