# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: storages
#
#  id           :integer       not null, primary key
#  domain_id    :integer       not null
#  root         :string(255)   not null
#  separator    :string(255)   not null
#  created_at   :string(14)
#  updated_at   :string(14)
#  created_by   :integer
#  updated_by   :integer
#  created_in   :integer
#  updated_in   :integer
#  lock_version :integer       default(0), not null
#

# 添付ファイルを保存するサーバのモデル。
class Storage < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor
  belongs_to :domain

  # 現在のユーザーに関連するインスタンスを返す。
  def self.current
    if u = User.current
      if s = u.person.domain.storage
        return s
      end
    end
    r = Pathname.new(RAILS_ROOT) + "tmp"
    return Storage.new(:root => r.to_s, :separator => "/")
  end

  # 保存場所として利用可能かどうかを判定する。
  def available?
    !root.blank? && File.exist?(root) && (File.stat(root).directory?)
  end
end
