module ActiveRecord
  module Acts
    # (このモジュールはフレームワークのモデルで常に include される。)
    # ファイルを添付できるインスタンスを持つモデルになる。
    # 添付されているファイルには <tt>attachments</tt> でアクセスできる。
    # インスタンスに対して <tt>destroy</tt> を呼ぶと、添付ファイルも <tt>destroy</tt> される。
    module Attachable
      def self.included(base)
        base.extend(ClassMethods)

        base.class_eval do
          class << self
            alias_method_chain :inherited, :attachable
          end
        end
      end

      module ClassMethods
        def inherited_with_attachable(subclass)
          inherited_without_attachable(subclass)
          subclass.class_eval do
            has_many :attachments, :as => :attachable, :dependent => :destroy
          end
        end
      end
    end
  end
end

ActiveRecord::Base.class_eval do
  include ActiveRecord::Acts::Attachable
end
