module ActiveRecord
  module Acts
    module FindLike
      def self.included(base)
        base.extend(ClassMethods)
      end
    end

    module ClassMethods
      def find_like(column, value, options = {})
        escape = '^'
        quoted = connection.quote_like(value, escape)
        default_options = {
          :conditions => ["#{column} LIKE ? ESCAPE ?", "%#{quoted}%", escape],
        }
        find(:all, default_options.merge(options))
      end

      def find_like_name(value, options = {})
        default_options = {
          :select => 'id, name',
          :order => 'name'
        }
        find_like('name', value, default_options.merge(options))
      end
    end
  end
end

ActiveRecord::Base.class_eval do
  include ActiveRecord::Acts::FindLike
end
