# -*- coding: utf-8 -*-

# このモジュールは ActiveRecord::Base のサブクラスで extend できる。
module InputOptionFactory

  def input_option_factory?
    self.included_modules.include? InputOptionFactory
  end

  def input_option_factory_category_class
    "#{self.to_s}Category".constantize
  end

  def input_option_factory_value_class
    "#{self.to_s}Value".constantize
  end

  # category に関連する選択肢を生成する。
  def generate_input_options(category, options = {}, rest = {})
    conditions = options.merge(:category => category)
    self.transaction do
      # drop records at first
      self.destroy_all(conditions)
      # find the category
      if c = input_option_factory_category_class.find(:first, :conditions => conditions)
        # find and create all the values
        values = input_option_factory_value_class.find(:all, :conditions => {:input_option_category_id => c.id}, :order => "position,id")
        values.each do |value|
          po_message = PoMessageSingular.create!(:domain_id => value.domain_id,
                                                 :msgctxt => "",
                                                 :msgid => "#{input_option_factory_value_class}|#{value.id}|#{value.value}",
                                                 :modified => true)
          Language.all.each do |lang|
            po_translation = "PoTranslation#{lang.code.capitalize}".constantize.new
            po_translation.domain_id = value.domain_id
            po_translation.po_message_id = po_message.id
            po_translation.msgstr = value.respond_to?("name#{lang.id}") ? value.__send__("name#{lang.id}") : value.__send__("name_#{lang.code}")
            po_translation.save!
          end
          conditions.update(rest)
          x = self.new(conditions)
          x.domain_id = value.domain_id
          x.name_po   = po_message.id
          x.value     = value.value
          x.save!
        end
      end
    end
  end
end
