# -*- coding: utf-8 -*-
module NarrowingHelper

  # モデル Item で利用される。
  module Item

    # <em>x</em> には <em>session</em> が期待される。
    def default_project_id_with_narrowing(x)
      # at first try to fetch segment
      unless x[:project_segment_id].blank?
        segment = ProjectSegment.find_by_id(x[:project_segment_id], :select => "project_id")
        if segment && self.class.exists?(:display_id => display_id, :input_type => 'picker', :input_parameter => 'project_segment')
          return segment.project_id
        end
      end
      return x[:project_id].to_i if Project.exists?(x[:project_id])
      return nil
    end

    # <em>x</em> には <em>session</em> が期待される。
    def default_id_with_narrowing(x)
      case input_type
      when "picker"
        case input_parameter
        when "matter", "project_segment"
          key = "#{input_parameter}_id".to_sym
          return x[key].to_i if input_parameter.classify.constantize.exists?(x[key])
        when "project"
          return default_project_id_with_narrowing(x)
        end
      end
      return nil
    end

  end

  # ヘルパーで利用される。
  module Helper

    # 現在の絞り込みから初期値を設定する。
    def initialize_id_with_narrowing(item)
      return nil unless item.is_a?(ItemProper)
      id = item.default_id_with_narrowing(session)
      return id if id
      return nil if item.input_initializer.blank?
      case item.input_initializer.strip
      when /\Anarrowing\((\d+)\)\z/
        narrowing = NarrowingById.find($1.to_i)
        key = narrowing.value_keys.first
        return session[key]
      end
    rescue ActiveRecord::RecordNotFound
      # fall through
    ensure
      nil
    end

  end

end
