# -*- coding: utf-8 -*-
module PasswordUtil

  # user のパスワードを変更する
  def self.change_password(user, old_password, new_password1, new_password2)
    raise PasswordMismatchError unless new_password1 == new_password2
    raise AuthenticationFailedError unless User.authenticate(user.login, old_password)
    user.change_password(new_password1)
    user.save!
  end

  # user のパスワードを強制的に変更する
  def self.force_change_password(user, new_password)
    user.change_password(new_password)
    user.save!
  end

  class AuthenticationFailedError < StandardError
  end
  class PasswordMismatchError < StandardError
  end
end
