# -*- coding: utf-8 -*-
# app/controllers/calendar_controller.rb のクラス CalendarController をテストする。

require File.dirname(__FILE__) + '/../test_helper'
require 'calendar_controller'

# Re-raise errors caught by the controller.
class CalendarController; def rescue_action(e) raise e end; end

class CalendarControllerTest < Test::Unit::TestCase
  def setup
    @controller = CalendarController.new
    @request    = ActionController::TestRequest.new
    @response   = ActionController::TestResponse.new

    # set logged in
    @request.session[:user_id] = User.find_by_login("tesla")
    @user = @request.session[:user_id]
  end

  # CalendarController#index がリダイレクトを行うことをテストする。
  def test_index
    get :index
    assert_response :redirect
    assert_redirected_to :action => 'test'
  end

  # CalendarController#test がテンプレート 'test' を使って出力することをテストする。
  def test_test
    get :test
    assert_response :success
    assert_template "test"
    assert_select "div"
  end

  # CalendarController#calendar がテンプレート 'calendar' を使って出力することをテストする。
  def test_calendar
    get :calendar
    assert_response :success
    assert_template "calendar"
    assert_form
  end

  # CalendarController#calendar に年および月のパラメータが与えられた場合に
  # 適切な出力が行われることをテストする。
  def test_calendar_with_param
    get :calendar, :year => 2007, :month => 9
    assert_response :success
    assert_template "calendar"
    assert_form
    assert_selection(2007,9)
  end

  # CalendarController#calendar に前年への操作にあたるパラメータを与えられた場合に
  # 適切な出力が行われることをテストする。
  def test_calendar_previous_year
    get :calendar, :year => 2007, :month => 9, :previous_year => 1
    assert_response :success
    assert_template "calendar"
    assert_form
    assert_selection(2006,9)
  end

  # CalendarController#calendar に先月への操作にあたるパラメータを与えられた場合に
  # 適切な出力が行われることをテストする。
  def test_calendar_previous_month
    get :calendar, :year => 2007, :month => 9, :previous_month => 1
    assert_response :success
    assert_template "calendar"
    assert_form
    assert_selection(2007,8)
  end

  # CalendarController#calendar に翌月への操作にあたるパラメータを与えられた場合に
  # 適切な出力が行われることをテストする。
  def test_calendar_next_month
    get :calendar, :year => 2007, :month => 9, :next_month => 1
    assert_response :success
    assert_template "calendar"
    assert_form
    assert_selection(2007,10)
  end

  # CalendarController#calendar に翌年への操作にあたるパラメータを与えられた場合に
  # 適切な出力が行われることをテストする。
  def test_calendar_next_year
    get :calendar, :year => 2007, :month => 9, :next_year => 1
    assert_response :success
    assert_template "calendar"
    assert_form
    assert_selection(2008,9)
  end

  private

  def assert_form
    assert_select "table#calendar"
    assert_select "form input[name=previous_year]", {:count => 2} do
      assert_select "[value=&lt;&lt;]"
    end
    assert_select "form input[name=previous_month]", {:count => 2} do
      assert_select "[value=&lt;]"
    end
    assert_select "form select[class=calendar_year]"
    assert_select "form select[class=calendar_month]"
    assert_select "form input[name=next_month]", {:count => 2} do
      assert_select "[value=&gt;]"
    end
    assert_select "form input[name=next_year]", {:count => 2} do
      assert_select "[value=&gt;&gt;]"
    end
  end

  def assert_selection(year, month)
    assert_select "form select[class=calendar_year] option[value=#{year.to_s}]" do
      assert_select "[selected]"
    end
    assert_select "form select[class=calendar_month] option[value=#{month.to_s}]" do
      assert_select "[selected]"
    end
  end
end
