# 作成者/更新者の記録をテストする。

require File.dirname(__FILE__) + '/../test_helper'
require "user_monitor"

class UserMonitorTest < ActionController::IntegrationTest
  include Session
  self.use_transactional_fixtures = false

  # ログイン後の画面操作によって作成者の情報がデータベースに記録されることをテストする。
  def test_successfully_created_by
    no_such = {
      :code => "no_such",
      :name_po => 0,
      :type => "ProductSingle",
      :model_name => "Domain",
    }
    foo = {
      :code => "foo_bar_baz",
      :name_po => 0,
      :type => "ProductSingle",
      :model_name => "Company",
    }

    tesla = login "tesla_admin", "atest"
    tesla.create_product(no_such)
    tesla.assert_equal 10000011, Product.find_by_code(no_such[:code]).attributes["created_by"]

    admin = login "admin", "atest"
    admin.create_product(foo)
    admin.assert_equal 2, Product.find_by_code(foo[:code]).attributes["created_by"]
  end

end
